/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.robotics.ai.AIRobotFetchItem;
import buildcraft.robotics.ai.AIRobotGotoSleep;
import buildcraft.robotics.ai.AIRobotGotoStationAndUnload;
import buildcraft.robotics.boards.BCBoardNBT;
import buildcraft.robotics.statements.ActionRobotFilter;
import java.util.HashSet;
import java.util.Set;

public class BoardRobotPicker
extends RedstoneBoardRobot {
    public static Set<Integer> targettedItems = new HashSet<Integer>();

    public BoardRobotPicker(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public void update() {
        this.startDelegateAI(new AIRobotFetchItem(this.robot, 250.0f, ActionRobotFilter.getGateFilter(this.robot.getLinkedStation()), this.robot.getZoneToWork()));
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotFetchItem) {
            if (ai.success()) {
                this.startDelegateAI(new AIRobotFetchItem(this.robot, 250.0f, ActionRobotFilter.getGateFilter(this.robot.getLinkedStation()), this.robot.getZoneToWork()));
            } else if (this.robot.containsItems()) {
                this.startDelegateAI(new AIRobotGotoStationAndUnload(this.robot));
            } else {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotGotoStationAndUnload && !ai.success()) {
            this.startDelegateAI(new AIRobotGotoSleep(this.robot));
        }
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BCBoardNBT.REGISTRY.get("picker");
    }
}

