/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.Transformer;

import lumien.randomthings.Configuration.ConfigBlocks;
import lumien.randomthings.Configuration.VanillaChanges;
import lumien.randomthings.Transformer.MCPNames;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class RTClassTransformer
implements IClassTransformer {
    Logger coreLogger = LogManager.getLogger((String)"RandomThingsCore");
    private static final String OBF_WORLD = "afn";

    public byte[] transform(String obfName, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.block.BlockLeavesBase") && VanillaChanges.FASTER_LEAVEDECAY) {
            return this.patchLeaveClass(basicClass);
        }
        if (transformedName.equals("net.minecraft.client.renderer.EntityRenderer")) {
            return this.patchEntityRendererClass(basicClass);
        }
        if (transformedName.equals("net.minecraft.world.World")) {
            return this.patchWorldClass(basicClass);
        }
        if (transformedName.equals("net.minecraft.item.Item")) {
            return this.patchItemClass(basicClass);
        }
        if (transformedName.equals("net.minecraft.client.renderer.RenderGlobal")) {
            return this.patchRenderGlobal(basicClass);
        }
        return basicClass;
    }

    private byte[] patchRenderGlobal(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.coreLogger.log(Level.INFO, "Found Render Global Class: " + classNode.name);
        String renderSkyName = MCPNames.method("func_72714_a");
        MethodNode renderSky = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(renderSkyName)) continue;
            renderSky = mn;
            break;
        }
        if (renderSky != null) {
            for (int i = 0; i < renderSky.instructions.size(); ++i) {
                AbstractInsnNode ain = renderSky.instructions.get(i);
                if (ain instanceof FieldInsnNode) {
                    FieldInsnNode fin = (FieldInsnNode)ain;
                    if (!fin.name.equals(MCPNames.field("field_110927_h"))) continue;
                    renderSky.instructions.insert(renderSky.instructions.get(i + 1), (AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/Handler/Bloodmoon/ClientBloodmoonHandler", "moonColorHook", "()V", false));
                    ++i;
                    continue;
                }
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.name.equals(MCPNames.method("func_72833_a"))) continue;
                renderSky.instructions.insert((AbstractInsnNode)min, (AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/Handler/Bloodmoon/ClientBloodmoonHandler", "skyColorHook", "(Lnet/minecraft/util/Vec3;)V", false));
                renderSky.instructions.insert((AbstractInsnNode)min, (AbstractInsnNode)new InsnNode(89));
                i += 2;
            }
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchItemClass(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.coreLogger.log(Level.INFO, "Found Item Class: " + classNode.name);
        String getColorFromItemStackName = MCPNames.method("func_82790_a");
        MethodNode getColorFromItemStack = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(getColorFromItemStackName)) continue;
            getColorFromItemStack = mn;
        }
        if (getColorFromItemStack != null) {
            LabelNode l0 = new LabelNode(new Label());
            LabelNode l1 = new LabelNode(new Label());
            LabelNode l2 = new LabelNode(new Label());
            getColorFromItemStack.instructions.insert((AbstractInsnNode)new InsnNode(87));
            getColorFromItemStack.instructions.insert((AbstractInsnNode)l2);
            getColorFromItemStack.instructions.insert((AbstractInsnNode)new InsnNode(172));
            getColorFromItemStack.instructions.insert((AbstractInsnNode)l1);
            getColorFromItemStack.instructions.insert((AbstractInsnNode)new JumpInsnNode(159, l2));
            getColorFromItemStack.instructions.insert((AbstractInsnNode)new LdcInsnNode((Object)0xFFFFFF));
            getColorFromItemStack.instructions.insert((AbstractInsnNode)new InsnNode(89));
            getColorFromItemStack.instructions.insert((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/Handler/CoreHandler", "getColorFromItemStack", "(Lnet/minecraft/item/ItemStack;I)I", false));
            getColorFromItemStack.instructions.insert((AbstractInsnNode)new VarInsnNode(21, 2));
            getColorFromItemStack.instructions.insert((AbstractInsnNode)new VarInsnNode(25, 1));
            getColorFromItemStack.instructions.insert((AbstractInsnNode)l0);
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchWorldClass(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.coreLogger.log(Level.INFO, "Found World Class: " + classNode.name);
        String sunBrightnessName = "getSunBrightnessBody";
        String indirectlyPoweredName = MCPNames.method("func_72864_z");
        int removeIndex = 0;
        MethodNode getSunBrightness = null;
        MethodNode isBlockIndirectlyGettingPowered = null;
        for (MethodNode mn : classNode.methods) {
            if (mn.name.equals(sunBrightnessName)) {
                getSunBrightness = mn;
                continue;
            }
            if (!mn.name.equals(indirectlyPoweredName)) continue;
            isBlockIndirectlyGettingPowered = mn;
        }
        if (getSunBrightness != null && VanillaChanges.HARDCORE_DARKNESS) {
            int i;
            for (i = 0; i < getSunBrightness.instructions.size(); ++i) {
                AbstractInsnNode an = getSunBrightness.instructions.get(i);
                if (!(an instanceof LdcInsnNode)) continue;
                LdcInsnNode lin = (LdcInsnNode)an;
                if (!lin.cst.equals(new Float("0.8"))) continue;
                removeIndex = i;
            }
            for (i = 0; i < 4; ++i) {
                getSunBrightness.instructions.remove(getSunBrightness.instructions.get(removeIndex));
            }
        }
        if (isBlockIndirectlyGettingPowered != null && ConfigBlocks.wirelessLever) {
            LabelNode l0 = new LabelNode(new Label());
            LabelNode l1 = new LabelNode(new Label());
            LabelNode l2 = new LabelNode(new Label());
            String world = "net/minecraft/world/World";
            isBlockIndirectlyGettingPowered.instructions.insert((AbstractInsnNode)l2);
            isBlockIndirectlyGettingPowered.instructions.insert((AbstractInsnNode)new InsnNode(172));
            isBlockIndirectlyGettingPowered.instructions.insert((AbstractInsnNode)new InsnNode(4));
            isBlockIndirectlyGettingPowered.instructions.insert((AbstractInsnNode)l1);
            isBlockIndirectlyGettingPowered.instructions.insert((AbstractInsnNode)new JumpInsnNode(153, l2));
            isBlockIndirectlyGettingPowered.instructions.insert((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/Handler/CoreHandler", "isBlockIndirectlyGettingPowered", "(L" + world + ";III)Z", false));
            isBlockIndirectlyGettingPowered.instructions.insert((AbstractInsnNode)new VarInsnNode(21, 3));
            isBlockIndirectlyGettingPowered.instructions.insert((AbstractInsnNode)new VarInsnNode(21, 2));
            isBlockIndirectlyGettingPowered.instructions.insert((AbstractInsnNode)new VarInsnNode(21, 1));
            isBlockIndirectlyGettingPowered.instructions.insert((AbstractInsnNode)new VarInsnNode(25, 0));
            isBlockIndirectlyGettingPowered.instructions.insert((AbstractInsnNode)l0);
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchEntityRendererClass(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.coreLogger.log(Level.INFO, "Found EntityRenderer Class: " + classNode.name);
        String methodName = MCPNames.method("func_78472_g");
        int removeIndex = 0;
        MethodNode updateLightmap = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(methodName)) continue;
            updateLightmap = mn;
        }
        if (updateLightmap != null) {
            int i;
            boolean insertedHook = false;
            for (i = 0; i < updateLightmap.instructions.size(); ++i) {
                AbstractInsnNode an = updateLightmap.instructions.get(i);
                if (an instanceof VarInsnNode && !insertedHook) {
                    VarInsnNode iin = (VarInsnNode)an;
                    if (iin.getOpcode() != 54 || iin.var != 21) continue;
                    updateLightmap.instructions.insert((AbstractInsnNode)iin, (AbstractInsnNode)new VarInsnNode(54, 21));
                    updateLightmap.instructions.insert((AbstractInsnNode)iin, (AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/Handler/LightmapHandler", "manipulateBlue", "(I)I", false));
                    updateLightmap.instructions.insert((AbstractInsnNode)iin, (AbstractInsnNode)new VarInsnNode(21, 21));
                    updateLightmap.instructions.insert((AbstractInsnNode)iin, (AbstractInsnNode)new VarInsnNode(54, 20));
                    updateLightmap.instructions.insert((AbstractInsnNode)iin, (AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/Handler/LightmapHandler", "manipulateGreen", "(I)I", false));
                    updateLightmap.instructions.insert((AbstractInsnNode)iin, (AbstractInsnNode)new VarInsnNode(21, 20));
                    updateLightmap.instructions.insert((AbstractInsnNode)iin, (AbstractInsnNode)new VarInsnNode(54, 19));
                    updateLightmap.instructions.insert((AbstractInsnNode)iin, (AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/Handler/LightmapHandler", "manipulateRed", "(I)I", false));
                    updateLightmap.instructions.insert((AbstractInsnNode)iin, (AbstractInsnNode)new VarInsnNode(21, 19));
                    insertedHook = true;
                    continue;
                }
                if (!VanillaChanges.HARDCORE_DARKNESS || !(an instanceof LdcInsnNode)) continue;
                LdcInsnNode lin = (LdcInsnNode)an;
                if (!lin.cst.equals(new Float("0.95"))) continue;
                removeIndex = i;
            }
            if (VanillaChanges.HARDCORE_DARKNESS) {
                for (i = 0; i < 4; ++i) {
                    updateLightmap.instructions.remove(updateLightmap.instructions.get(removeIndex));
                }
            }
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchLeaveClass(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.coreLogger.log(Level.INFO, "Found Leave Class: " + classNode.name);
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        String methodName = MCPNames.method("func_149695_a");
        String worldClass = "net/minecraft/world/World";
        String leaveClass = "net/minecraft/block/BlockLeavesBase";
        String blockClass = "net/minecraft/block/Block";
        MethodVisitor mv = writer.visitMethod(1, methodName, "(L" + worldClass + ";IIIL" + blockClass + ";)V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(81, l0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(21, 2);
        mv.visitVarInsn(21, 3);
        mv.visitVarInsn(21, 4);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "lumien/randomthings/Handler/CoreHandler", "handleLeaveDecay", "(L" + worldClass + ";IIIL" + blockClass + ";)V", false);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(82, l1);
        mv.visitInsn(177);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLocalVariable("this", "Llumien/randomthings/Transformer/RTClassTransformer;", null, l0, l2, 0);
        mv.visitLocalVariable("p_149695_1_", "L" + worldClass + ";", null, l0, l2, 1);
        mv.visitLocalVariable("p_149695_2_", "I", null, l0, l2, 2);
        mv.visitLocalVariable("p_149695_3_", "I", null, l0, l2, 3);
        mv.visitLocalVariable("p_149695_4_", "I", null, l0, l2, 4);
        mv.visitLocalVariable("p_149695_5_", "L" + blockClass + ";", null, l0, l2, 5);
        mv.visitMaxs(5, 6);
        mv.visitEnd();
        return writer.toByteArray();
    }
}

