/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.apiimpl.v1;

import com.InfinityRaider.AgriCraft.api.v1.ISeedStats;
import com.InfinityRaider.AgriCraft.api.v1.ITrowel;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PlantStats
implements ISeedStats {
    private static final short MAX = (short)ConfigurationHandler.cropStatCap;
    private static final short MIN = 1;
    private short growth;
    private short gain;
    private short strength;

    public PlantStats() {
        this(1, 1, 1);
    }

    public PlantStats(int growth, int gain, int strength) {
        this.setStats(growth, gain, strength);
    }

    public void setStats(int growth, int gain, int strength) {
        this.setGrowth(growth);
        this.setGain(gain);
        this.setStrength(strength);
    }

    @Override
    public short getGrowth() {
        return this.growth;
    }

    @Override
    public short getGain() {
        return this.gain;
    }

    @Override
    public short getStrength() {
        return this.strength;
    }

    @Override
    public short getMaxGrowth() {
        return MAX;
    }

    @Override
    public short getMaxGain() {
        return MAX;
    }

    @Override
    public short getMaxStrength() {
        return MAX;
    }

    public void setGrowth(int growth) {
        this.growth = this.moveIntoBounds(growth);
    }

    public void setGain(int gain) {
        this.gain = this.moveIntoBounds(gain);
    }

    public void setStrength(int strength) {
        this.strength = this.moveIntoBounds(strength);
    }

    private short moveIntoBounds(int stat) {
        int lowerLimit = Math.max(1, stat);
        return (short)Math.min(MAX, lowerLimit);
    }

    public PlantStats copy() {
        return new PlantStats(this.getGrowth(), this.getGain(), this.getStrength());
    }

    public static PlantStats getStatsFromStack(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        if (stack.func_77973_b() instanceof ITrowel) {
            ((ITrowel)stack.func_77973_b()).getStats(stack);
        }
        return PlantStats.readFromNBT(stack.func_77978_p());
    }

    public static PlantStats readFromNBT(NBTTagCompound tag) {
        if (tag != null && tag.func_74764_b("growth") && tag.func_74764_b("gain") && tag.func_74764_b("strength")) {
            PlantStats stats = new PlantStats();
            stats.setGrowth(tag.func_74765_d("growth"));
            stats.setGain(tag.func_74765_d("gain"));
            stats.setStrength(tag.func_74765_d("strength"));
            return stats;
        }
        return null;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74777_a("growth", this.growth);
        tag.func_74777_a("gain", this.gain);
        tag.func_74777_a("strength", this.strength);
        return tag;
    }
}

