/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.apiimpl.v1.cropplant;

import com.InfinityRaider.AgriCraft.api.v1.IAgriCraftPlant;
import com.InfinityRaider.AgriCraft.apiimpl.v1.cropplant.CropPlant;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class CropPlantAgriCraft
extends CropPlant {
    IAgriCraftPlant plant;

    public CropPlantAgriCraft(IAgriCraftPlant plant) {
        this.plant = plant;
    }

    @Override
    public int tier() {
        return this.plant.getSeed().tier();
    }

    @Override
    public ItemStack getSeed() {
        return this.plant.getSeedStack(1);
    }

    @Override
    public Block getBlock() {
        return this.plant.getBlock();
    }

    @Override
    public ArrayList<ItemStack> getAllFruits() {
        return this.plant.getAllFruits();
    }

    @Override
    public ItemStack getRandomFruit(Random rand) {
        return this.plant.getRandomFruit(rand);
    }

    @Override
    public ArrayList<ItemStack> getFruitsOnHarvest(int gain, Random rand) {
        int amount = (int)Math.ceil(((double)gain + 0.0) / 3.0);
        return this.plant.getFruit(amount, rand);
    }

    @Override
    public boolean canBonemeal() {
        return this.getTier() < 4;
    }

    @Override
    public boolean onAllowedGrowthTick(World world, int x, int y, int z, int oldGrowthStage) {
        return false;
    }

    @Override
    public boolean isFertile(World world, int x, int y, int z) {
        return this.plant.getGrowthRequirement().canGrow(world, x, y, z);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getHeight(int meta) {
        return 0.8125f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getPlantIcon(int growthStage) {
        return this.plant.getIcon(growthStage);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderAsFlower() {
        return this.plant.renderAsFlower();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getInformation() {
        return this.plant.getSeed().getInformation();
    }
}

