/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.blocks;

import com.InfinityRaider.AgriCraft.api.v1.BlockWithMeta;
import com.InfinityRaider.AgriCraft.api.v1.IAgriCraftPlant;
import com.InfinityRaider.AgriCraft.api.v1.RenderMethod;
import com.InfinityRaider.AgriCraft.api.v1.RequirementType;
import com.InfinityRaider.AgriCraft.apiimpl.v1.GrowthRequirement;
import com.InfinityRaider.AgriCraft.apiimpl.v1.cropplant.CropPlantAgriCraftShearable;
import com.InfinityRaider.AgriCraft.compatibility.applecore.AppleCoreHelper;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.farming.CropProduce;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.items.ItemModSeed;
import com.InfinityRaider.AgriCraft.reference.Constants;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import com.InfinityRaider.AgriCraft.utility.RegisterHelper;
import com.InfinityRaider.AgriCraft.utility.exception.MissingArgumentsException;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class BlockModPlant
extends BlockCrops
implements IAgriCraftPlant {
    private GrowthRequirement growthRequirement;
    public CropProduce products = new CropProduce();
    private ItemModSeed seed;
    public int tier;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    private RenderMethod renderType;

    public BlockModPlant(Object ... arguments) throws MissingArgumentsException {
        String name = null;
        ItemStack fruit = null;
        ItemStack shearable = null;
        BlockWithMeta soil = null;
        RequirementType type = RequirementType.NONE;
        BlockWithMeta base = null;
        int tier = -1;
        RenderMethod renderType = null;
        for (Object arg : arguments) {
            if (arg == null) continue;
            if (arg instanceof String) {
                name = (String)arg;
                continue;
            }
            if (arg instanceof ItemStack) {
                if (fruit == null) {
                    fruit = (ItemStack)arg;
                    continue;
                }
                shearable = (ItemStack)arg;
                continue;
            }
            if (arg instanceof RequirementType) {
                type = (RequirementType)((Object)arg);
            }
            if (arg instanceof BlockWithMeta) {
                if (type != RequirementType.NONE) {
                    base = (BlockWithMeta)arg;
                    base = base.getBlock() == null ? null : base;
                    continue;
                }
                soil = (BlockWithMeta)arg;
                soil = soil.getBlock() == null ? null : soil;
                continue;
            }
            if (arg instanceof RenderMethod) {
                renderType = (RenderMethod)((Object)arg);
                continue;
            }
            if (!(arg instanceof Integer)) continue;
            tier = (Integer)arg;
        }
        if (name == null || fruit == null || tier < 0 || renderType == null) {
            throw new MissingArgumentsException();
        }
        GrowthRequirement.Builder builder = new GrowthRequirement.Builder();
        if (base != null && type != RequirementType.NONE) {
            builder.requiredBlock(base, type, true);
        }
        this.growthRequirement = soil == null ? builder.build() : builder.soil(soil).build();
        this.products.addProduce(fruit);
        this.tier = tier;
        this.func_149675_a(true);
        this.field_149783_u = true;
        this.renderType = renderType;
        RegisterHelper.registerCrop(this, name);
        this.seed = new ItemModSeed(this, "agricraft_journal." + Character.toLowerCase(name.charAt(0)) + name.substring(1));
        try {
            if (shearable == null) {
                CropPlantHandler.registerPlant(this);
            } else {
                CropPlantHandler.registerPlant(new CropPlantAgriCraftShearable(this, shearable));
            }
        }
        catch (Exception e) {
            LogHelper.printStackTrace(e);
        }
    }

    @Override
    public ItemModSeed getSeed() {
        return this.seed;
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @Override
    public ItemStack getSeedStack(int amount) {
        return new ItemStack((Item)this.seed, amount);
    }

    @Override
    public ArrayList<ItemStack> getAllFruits() {
        return this.products.getAllProducts();
    }

    @Override
    public ItemStack getRandomFruit(Random rand) {
        ArrayList<ItemStack> fruits = this.getFruit(1, rand);
        return fruits.size() > 0 ? fruits.get(0) : null;
    }

    @Override
    public ArrayList<ItemStack> getFruit(int nr, Random rand) {
        return this.products.getProduce(nr, rand);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int meta) {
        return this.func_149691_a(0, meta);
    }

    @Override
    public boolean renderAsFlower() {
        return this.renderType == RenderMethod.CROSSED;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Crop;
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isRemote) {
        return this.tier <= 3 && super.func_149851_a(world, x, y, z, isRemote);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        LogHelper.debug("registering icon for: " + this.func_149739_a());
        this.icons = new IIcon[4];
        for (int i = 1; i < this.icons.length + 1; ++i) {
            this.icons[i - 1] = reg.func_94245_a(this.func_149739_a().substring(this.func_149739_a().indexOf(46) + 1) + i);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rnd) {
        int meta = this.getPlantMetadata((IBlockAccess)world, x, y, z);
        if (meta < 7 && this.isFertile(world, x, y, z)) {
            int newMeta;
            int growthRate = this.tier > 0 && this.tier <= Constants.GROWTH_TIER.length ? Constants.GROWTH_TIER[this.tier] : Constants.GROWTH_TIER[0];
            double bonus = 1.1;
            float global = 2.0f - ConfigurationHandler.growthMultiplier;
            int n = newMeta = rnd.nextDouble() > (double)growthRate * bonus * (double)global / 100.0 ? meta : meta + 1;
            if (newMeta != meta) {
                world.func_72921_c(x, y, z, newMeta, 2);
                AppleCoreHelper.announceGrowthTick((Block)this, world, x, y, z);
            }
        }
    }

    public boolean isMature(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) >= 7;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        switch (meta) {
            case 0: 
            case 1: {
                return this.icons[0];
            }
            case 2: 
            case 3: 
            case 4: {
                return this.icons[1];
            }
            case 5: 
            case 6: {
                return this.icons[2];
            }
            case 7: {
                return this.icons[3];
            }
        }
        return this.icons[meta / 5];
    }

    public void func_149690_a(World world, int x, int y, int z, int meta, float f, int i) {
        super.func_149690_a(world, x, y, z, meta, f, 0);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((Item)this.seed, 1, 0));
        if (metadata == 7) {
            list.add(this.getRandomFruit(world.field_73012_v));
        }
        return list;
    }

    public Item func_149650_a(int meta, Random rand, int side) {
        return meta >= 7 ? this.func_149865_P() : this.func_149866_i();
    }

    public int func_149745_a(Random rand) {
        return 1;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return this.growthRequirement.isValidSoil(world, x, y - 1, z);
    }

    public boolean isFertile(World world, int x, int y, int z) {
        return this.growthRequirement.canGrow(world, x, y, z);
    }

    protected Item func_149866_i() {
        return this.seed;
    }

    protected Item func_149865_P() {
        Item randomFruit = this.getRandomFruit(new Random()).func_77973_b();
        return randomFruit == null ? null : randomFruit;
    }

    public int func_149645_b() {
        return this.renderType.renderId();
    }

    @Override
    public GrowthRequirement getGrowthRequirement() {
        return this.growthRequirement;
    }
}

