/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.compatibility.NEI;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.InfinityRaider.AgriCraft.api.v1.BlockWithMeta;
import com.InfinityRaider.AgriCraft.api.v1.IGrowthRequirement;
import com.InfinityRaider.AgriCraft.api.v1.RequirementType;
import com.InfinityRaider.AgriCraft.apiimpl.v1.cropplant.CropPlant;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.farming.GrowthRequirementHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class NEICropProductHandler
extends TemplateRecipeHandler {
    private static String name = StatCollector.func_74838_a((String)"agricraft_nei.cropProduct.title");
    private static String id = "cropProduct";
    private static final int COLOR_BLACK = 0x191616;

    public void loadCraftingRecipes(String id, Object ... results) {
        block3: {
            block2: {
                if (!id.equalsIgnoreCase(NEICropProductHandler.id)) break block2;
                ArrayList<CropPlant> plants = CropPlantHandler.getPlants();
                for (CropPlant plant : plants) {
                    if (plant.getSeed() == null || plant.getSeed().func_77973_b() == null) continue;
                    this.arecipes.add(new CachedCropProductRecipe(plant.getSeed()));
                }
                break block3;
            }
            if (!id.equalsIgnoreCase("item")) break block3;
            for (Object object : results) {
                if (!(object instanceof ItemStack) || ((Object)((Object)this)).getClass() != NEICropProductHandler.class) continue;
                this.loadCraftingRecipes(new ItemStack(((ItemStack)object).func_77973_b(), 1, ((ItemStack)object).func_77960_j()));
            }
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        block0: for (CropPlant plant : CropPlantHandler.getPlants()) {
            ArrayList<ItemStack> drops = plant.getAllFruits();
            if (drops == null) continue;
            for (ItemStack drop : drops) {
                if (drop == null || drop.func_77973_b() == null || drop.func_77973_b() != result.func_77973_b() || drop.func_77960_j() != result.func_77960_j()) continue;
                this.arecipes.add(new CachedCropProductRecipe(plant.getSeed()));
                continue block0;
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (CropPlantHandler.isValidSeed(ingredient)) {
            this.arecipes.add(new CachedCropProductRecipe(ingredient));
        } else if (ingredient.func_77973_b() instanceof ItemBlock) {
            BlockWithMeta block = new BlockWithMeta(((ItemBlock)ingredient.func_77973_b()).field_150939_a, ingredient.func_77960_j());
            ArrayList<CropPlant> plants = CropPlantHandler.getPlants();
            for (CropPlant plant : plants) {
                if (plant.getSeed() == null || plant.getSeed().func_77973_b() == null) continue;
                IGrowthRequirement req = GrowthRequirementHandler.getGrowthRequirement(plant.getSeed().func_77973_b(), plant.getSeed().func_77960_j());
                if (req.isValidSoil(block)) {
                    this.arecipes.add(new CachedCropProductRecipe(plant.getSeed()));
                    continue;
                }
                if (!block.equals(req.getRequiredBlock())) continue;
                this.arecipes.add(new CachedCropProductRecipe(plant.getSeed()));
            }
        }
    }

    public String getRecipeName() {
        return name;
    }

    public String getOverlayIdentifier() {
        return id;
    }

    public String getGuiTexture() {
        return new ResourceLocation("AgriCraft".toLowerCase(), "textures/gui/nei/cropProduce.png").toString();
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(72, 27, 18, 6), id, new Object[0]));
    }

    public void drawBackground(int recipe) {
        CachedCropProductRecipe cropProductRecipe = (CachedCropProductRecipe)((Object)this.arecipes.get(recipe));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)85);
        String soil = StatCollector.func_74838_a((String)"agricraft_nei.soil");
        GuiDraw.drawStringR((String)(soil + ":"), (int)37, (int)51, (int)0x191616, (boolean)false);
        if (cropProductRecipe.requiredType != RequirementType.NONE) {
            String needs = StatCollector.func_74838_a((String)"agricraft_nei.needs");
            String modifier = cropProductRecipe.requiredType == RequirementType.BELOW ? StatCollector.func_74838_a((String)"agricraft_nei.below") : StatCollector.func_74838_a((String)"agricraft_nei.nearby");
            GuiDraw.drawStringR((String)(needs + ":"), (int)37, (int)72, (int)0x191616, (boolean)false);
            GuiDraw.drawString((String)modifier, (int)67, (int)72, (int)0x191616, (boolean)false);
        }
    }

    public class CachedCropProductRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack seed;
        List<PositionedStack> products;
        List<PositionedStack> soils;
        PositionedStack requiredBlock;
        RequirementType requiredType;

        public CachedCropProductRecipe(ItemStack stack) {
            IGrowthRequirement growthReq;
            super((TemplateRecipeHandler)NEICropProductHandler.this);
            this.soils = new ArrayList<PositionedStack>();
            this.seed = new PositionedStack((Object)stack, 44, 21);
            this.products = new ArrayList<PositionedStack>();
            ArrayList<ItemStack> drops = CropPlantHandler.getPlantFromStack(stack).getAllFruits();
            if (drops != null) {
                for (int i = 0; i < drops.size(); ++i) {
                    this.products.add(new PositionedStack(drops.get(i), 106 + 16 * (i % 3), 21 + 16 * (i / 3 - 1)));
                }
            }
            if ((growthReq = GrowthRequirementHandler.getGrowthRequirement(stack.func_77973_b(), stack.func_77960_j())).getSoil() != null) {
                this.soils.add(new PositionedStack((Object)growthReq.getSoil().toStack(), 44, 47));
            } else {
                for (BlockWithMeta blockWithMeta : GrowthRequirementHandler.defaultSoils) {
                    this.soils.add(new PositionedStack((Object)blockWithMeta.toStack(), 44, 47));
                }
            }
            this.requiredType = growthReq.getRequiredType();
            if (this.requiredType != RequirementType.NONE) {
                this.requiredBlock = new PositionedStack((Object)growthReq.requiredBlockAsItemStack(), 44, 68);
            }
        }

        public PositionedStack getIngredient() {
            return this.seed;
        }

        public List<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> list = new ArrayList<PositionedStack>();
            list.add(this.seed);
            list.add(this.soils.get(NEICropProductHandler.this.cycleticks / 20 % this.soils.size()));
            if (this.requiredBlock != null) {
                list.add(this.requiredBlock);
            }
            list.addAll(this.products);
            return list;
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

