/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.compatibility.computercraft.method;

import com.InfinityRaider.AgriCraft.compatibility.computercraft.method.MethodBase;
import com.InfinityRaider.AgriCraft.compatibility.computercraft.method.MethodException;
import com.InfinityRaider.AgriCraft.compatibility.computercraft.method.MethodParameter;
import com.InfinityRaider.AgriCraft.items.ItemJournal;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCrop;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityPeripheral;
import com.InfinityRaider.AgriCraft.tileentity.TileEntitySeedAnalyzer;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class MethodCropBase
extends MethodBase {
    private final String name;

    public MethodCropBase(String name) {
        this.name = name;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Object[] call(TileEntityPeripheral peripheral, World world, int x, int y, int z, ItemStack journal, Object ... args) throws MethodException {
        boolean hasJournal;
        ForgeDirection dir = this.getDirection(args);
        if (dir == ForgeDirection.UNKNOWN) {
            throw new MethodException(this, "INVALID DIRECTION");
        }
        TileEntity tile = world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        if (tile == null || !(tile instanceof TileEntityCrop)) {
            throw new MethodException(this, "There is no crop there");
        }
        TileEntityCrop crop = (TileEntityCrop)tile;
        boolean bl = hasJournal = journal != null;
        if (this.requiresJournal()) {
            if (!hasJournal) {
                throw new MethodException(this, "Journal is missing");
            }
            if (!this.isSeedDiscovered(world.func_147438_o(x, y, z), crop)) {
                throw new MethodException(this, "No information about this seed in the journal");
            }
        }
        return this.onMethodCalled(crop);
    }

    private ForgeDirection getDirection(Object ... args) {
        for (Object obj : args) {
            ForgeDirection dir = ForgeDirection.UNKNOWN;
            if (obj == null) continue;
            if (obj instanceof Object[]) {
                dir = this.getDirection((Object[])obj);
            } else if (obj instanceof String) {
                dir = ForgeDirection.valueOf((String)((String)obj));
            }
            if (dir == null || dir == ForgeDirection.UNKNOWN) continue;
            return dir;
        }
        return ForgeDirection.UNKNOWN;
    }

    private boolean isSeedDiscovered(TileEntity tile, TileEntityCrop crop) {
        if (tile == null || !(tile instanceof TileEntitySeedAnalyzer)) {
            return false;
        }
        TileEntitySeedAnalyzer analyzer = (TileEntitySeedAnalyzer)tile;
        ItemStack journal = analyzer.getJournal();
        return ((ItemJournal)journal.func_77973_b()).isSeedDiscovered(journal, crop.getSeedStack());
    }

    protected abstract Object[] onMethodCalled(TileEntityCrop var1) throws MethodException;

    protected abstract boolean requiresJournal();

    @Override
    protected ArrayList<MethodParameter> getParameters() {
        ArrayList<MethodParameter> list = new ArrayList<MethodParameter>();
        list.add(MethodParameter.DIRECTION);
        return list;
    }
}

