/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.compatibility.waila;

import com.InfinityRaider.AgriCraft.blocks.BlockCrop;
import com.InfinityRaider.AgriCraft.init.Items;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCrop;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class AgriCraftCropDataProvider
implements IWailaDataProvider {
    public ItemStack getWailaStack(IWailaDataAccessor dataAccessor, IWailaConfigHandler configHandler) {
        Block block = dataAccessor.getBlock();
        if (block instanceof BlockCrop) {
            return new ItemStack((Item)Items.crops, 1, 0);
        }
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> list, IWailaDataAccessor dataAccessor, IWailaConfigHandler configHandler) {
        return list;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> list, IWailaDataAccessor dataAccessor, IWailaConfigHandler configHandler) {
        Block block = dataAccessor.getBlock();
        TileEntity te = dataAccessor.getTileEntity();
        if (block != null && block instanceof BlockCrop && te != null && te instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)te;
            if (crop.hasPlant()) {
                short growth = crop.getGrowth();
                short gain = crop.getGain();
                short strength = crop.getStrength();
                boolean analyzed = crop.isAnalyzed();
                int meta = dataAccessor.getMetadata();
                String seedName = crop.getSeedStack().func_82833_r();
                list.add(StatCollector.func_74838_a((String)"agricraft_tooltip.seed") + ": " + seedName);
                String growthStage = meta == 7 ? StatCollector.func_74838_a((String)"agricraft_tooltip.mature") : (int)(100.0f * ((float)meta + 0.0f) / 7.0f) + "%";
                list.add(StatCollector.func_74838_a((String)"agricraft_tooltip.growthStage") + ": " + growthStage);
                if (analyzed) {
                    list.add(" - " + StatCollector.func_74838_a((String)"agricraft_tooltip.growth") + ": " + growth);
                    list.add(" - " + StatCollector.func_74838_a((String)"agricraft_tooltip.gain") + ": " + gain);
                    list.add(" - " + StatCollector.func_74838_a((String)"agricraft_tooltip.strength") + ": " + strength);
                } else {
                    list.add(StatCollector.func_74838_a((String)"agricraft_tooltip.analyzed"));
                }
                list.add(StatCollector.func_74838_a((String)(crop.isFertile() ? "agricraft_tooltip.fertile" : "agricraft_tooltip.notFertile")));
            } else if (crop.hasWeed()) {
                list.add(StatCollector.func_74838_a((String)"agricraft_tooltip.weeds"));
            } else {
                list.clear();
                list.add(StatCollector.func_74838_a((String)"agricraft_tooltip.empty"));
            }
        }
        return list;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> list, IWailaDataAccessor dataAccessor, IWailaConfigHandler configHandler) {
        return list;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        return null;
    }
}

