/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.farming;

import com.InfinityRaider.AgriCraft.api.v1.IAgriCraftPlant;
import com.InfinityRaider.AgriCraft.apiimpl.v1.cropplant.CropPlant;
import com.InfinityRaider.AgriCraft.apiimpl.v1.cropplant.CropPlantAgriCraft;
import com.InfinityRaider.AgriCraft.apiimpl.v1.cropplant.CropPlantNetherWart;
import com.InfinityRaider.AgriCraft.apiimpl.v1.cropplant.CropPlantOreDict;
import com.InfinityRaider.AgriCraft.apiimpl.v1.cropplant.CropPlantStem;
import com.InfinityRaider.AgriCraft.apiimpl.v1.cropplant.CropPlantVanilla;
import com.InfinityRaider.AgriCraft.compatibility.ModHelper;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import com.InfinityRaider.AgriCraft.utility.OreDictHelper;
import com.InfinityRaider.AgriCraft.utility.SeedHelper;
import com.InfinityRaider.AgriCraft.utility.exception.BlacklistedCropPlantException;
import com.InfinityRaider.AgriCraft.utility.exception.DuplicateCropPlantException;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class CropPlantHandler {
    private static HashMap<Item, HashMap<Integer, CropPlant>> cropPlants = new HashMap();
    private static ArrayList<CropPlant> plantsToRegister = new ArrayList();

    public static void registerPlant(IAgriCraftPlant plant) throws DuplicateCropPlantException, BlacklistedCropPlantException {
        CropPlantHandler.registerPlant(new CropPlantAgriCraft(plant));
    }

    public static void registerPlant(CropPlant plant) throws DuplicateCropPlantException, BlacklistedCropPlantException {
        ItemStack stack = plant.getSeed();
        if (SeedHelper.isSeedBlackListed(stack)) {
            throw new BlacklistedCropPlantException();
        }
        LogHelper.debug("Registering plant for " + stack.func_77977_a());
        Item seed = stack.func_77973_b();
        int meta = stack.func_77960_j();
        HashMap<Integer, CropPlant> entryForSeed = cropPlants.get(seed);
        if (entryForSeed != null) {
            if (entryForSeed.get(meta) != null) {
                throw new DuplicateCropPlantException();
            }
            entryForSeed.put(meta, plant);
        } else {
            entryForSeed = new HashMap();
            entryForSeed.put(meta, plant);
            cropPlants.put(seed, entryForSeed);
        }
    }

    private static void suppressedRegisterPlant(CropPlant plant) {
        try {
            CropPlantHandler.registerPlant(plant);
        }
        catch (DuplicateCropPlantException e) {
            LogHelper.debug("Unable to register duplicate plant: " + plant.getSeed().func_77977_a());
            LogHelper.printStackTrace(e);
        }
        catch (BlacklistedCropPlantException e) {
            LogHelper.warn("Blacklisted plant " + plant.getSeed().func_77977_a() + " was not registered.");
        }
    }

    public static void addCropToRegister(CropPlant plant) {
        plantsToRegister.add(plant);
    }

    public static boolean isValidSeed(ItemStack stack) {
        if (stack != null && cropPlants.containsKey(stack.func_77973_b())) {
            return cropPlants.get(stack.func_77973_b()).containsKey(stack.func_77960_j());
        }
        return false;
    }

    public static boolean isValidPlant(ItemStack stack) {
        if (cropPlants.containsKey(stack.func_77973_b())) {
            return cropPlants.get(stack.func_77973_b()).containsKey(stack.func_77960_j());
        }
        return false;
    }

    public static NBTTagCompound writePlantToNBT(CropPlant plant) {
        return plant.getSeed().func_77955_b(new NBTTagCompound());
    }

    public static CropPlant readPlantFromNBT(NBTTagCompound tag) {
        return CropPlantHandler.getPlantFromStack(ItemStack.func_77949_a((NBTTagCompound)tag));
    }

    public static CropPlant getPlantFromStack(ItemStack stack) {
        if (CropPlantHandler.isValidPlant(stack)) {
            return cropPlants.get(stack.func_77973_b()).get(stack.func_77960_j());
        }
        return null;
    }

    public static ArrayList<CropPlant> getPlants() {
        ArrayList<CropPlant> plants = new ArrayList<CropPlant>();
        for (HashMap<Integer, CropPlant> subMap : cropPlants.values()) {
            plants.addAll(subMap.values());
        }
        return plants;
    }

    public static ArrayList<CropPlant> getPlantsUpToTier(int tier) {
        ArrayList<CropPlant> list = new ArrayList<CropPlant>();
        for (HashMap<Integer, CropPlant> subMap : cropPlants.values()) {
            for (CropPlant plant : subMap.values()) {
                if (plant.getTier() > tier) continue;
                list.add(plant);
            }
        }
        return list;
    }

    public static void init() {
        OreDictionary.registerOre((String)"seedMelon", (Item)Items.field_151081_bc);
        OreDictionary.registerOre((String)"cropMelon", (Item)Items.field_151127_ba);
        OreDictionary.registerOre((String)"seedPumpkin", (Item)Items.field_151080_bb);
        OreDictionary.registerOre((String)"cropPumpkin", (Block)Blocks.field_150423_aK);
        CropPlantHandler.suppressedRegisterPlant(new CropPlantVanilla((BlockCrops)Blocks.field_150464_aj, (ItemSeeds)Items.field_151014_N));
        CropPlantHandler.suppressedRegisterPlant(new CropPlantStem((ItemSeeds)Items.field_151081_bc, Blocks.field_150440_ba));
        CropPlantHandler.suppressedRegisterPlant(new CropPlantStem((ItemSeeds)Items.field_151080_bb, Blocks.field_150423_aK));
        CropPlantHandler.suppressedRegisterPlant(new CropPlantNetherWart());
        ModHelper.initModPlants();
        for (CropPlant plant : plantsToRegister) {
            CropPlantHandler.suppressedRegisterPlant(plant);
        }
        plantsToRegister = null;
        ArrayList seeds = OreDictionary.getOres((String)"listAllseed");
        for (ItemStack seed : seeds) {
            ArrayList<ItemStack> fruits;
            if (CropPlantHandler.isValidSeed(seed) || !(seed.func_77973_b() instanceof ItemSeeds) || (fruits = OreDictHelper.getFruitsFromOreDict(seed)) == null || fruits.size() <= 0) continue;
            CropPlantHandler.suppressedRegisterPlant(new CropPlantOreDict((ItemSeeds)seed.func_77973_b()));
        }
    }
}

