/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.farming;

import com.InfinityRaider.AgriCraft.api.v1.BlockWithMeta;
import com.InfinityRaider.AgriCraft.api.v1.IAgriCraftSeed;
import com.InfinityRaider.AgriCraft.api.v1.IGrowthRequirement;
import com.InfinityRaider.AgriCraft.api.v1.ISoilContainer;
import com.InfinityRaider.AgriCraft.api.v1.ItemWithMeta;
import com.InfinityRaider.AgriCraft.apiimpl.v1.GrowthRequirement;
import com.InfinityRaider.AgriCraft.apiimpl.v1.cropplant.CropPlant;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.utility.IOHelper;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import com.InfinityRaider.AgriCraft.utility.exception.InvalidSeedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class GrowthRequirementHandler {
    private static Map<ItemWithMeta, IGrowthRequirement> growthRequirements = new HashMap<ItemWithMeta, IGrowthRequirement>();
    public static List<BlockWithMeta> defaultSoils = new ArrayList<BlockWithMeta>();
    static List<BlockWithMeta> soils = new ArrayList<BlockWithMeta>();

    public static void registerGrowthRequirement(ItemWithMeta item, IGrowthRequirement requirement) throws InvalidSeedException {
        if (CropPlantHandler.isValidSeed(item.toStack())) {
            throw new InvalidSeedException();
        }
        growthRequirements.put(item, requirement);
    }

    public static boolean isSoilValid(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        BlockWithMeta soil = block instanceof ISoilContainer ? new BlockWithMeta(((ISoilContainer)block).getSoil(world, x, y, z), ((ISoilContainer)block).getSoilMeta(world, x, y, z)) : new BlockWithMeta(block, meta);
        return soils.contains(soil) || defaultSoils.contains(soil);
    }

    public static void init() {
        GrowthRequirementHandler.registerSoils();
        GrowthRequirementHandler.initGrowthReqs();
        GrowthRequirementHandler.registerOverrides();
        GrowthRequirementHandler.registerCustomEntries();
    }

    private static void registerSoils() {
        GrowthRequirementHandler.addDefaultSoil(new BlockWithMeta(Blocks.field_150458_ak));
    }

    private static void initGrowthReqs() {
        ArrayList<IGrowthRequirement> darkCrops = new ArrayList<IGrowthRequirement>();
        darkCrops.add(GrowthRequirementHandler.getGrowthRequirement((Item)Item.field_150901_e.func_82594_a("AgriCraft:seedShroomRed"), 0));
        darkCrops.add(GrowthRequirementHandler.getGrowthRequirement((Item)Item.field_150901_e.func_82594_a("AgriCraft:seedShroomBrown"), 0));
        if (ConfigurationHandler.resourcePlants) {
            darkCrops.add(GrowthRequirementHandler.getGrowthRequirement((Item)Item.field_150901_e.func_82594_a("AgriCraft:seedNitorWart"), 0));
        }
        darkCrops.add(GrowthRequirementHandler.getGrowthRequirement(Items.field_151075_bm, 0));
        for (IGrowthRequirement req : darkCrops) {
            req.setBrightnessRange(0, 8);
        }
    }

    private static void registerOverrides() {
        GrowthRequirement netherWartReq = new GrowthRequirement.Builder().soil(new BlockWithMeta(Blocks.field_150425_aM)).brightnessRange(0, 8).build();
        growthRequirements.put(new ItemWithMeta(Items.field_151075_bm, 0), netherWartReq);
    }

    private static void registerCustomEntries() {
        LogHelper.info("Registering soils to whitelist:");
        String[] data = IOHelper.getLinesArrayFromData(ConfigurationHandler.readSoils());
        String total = " of " + data.length + ".";
        for (String line : data) {
            Block block;
            LogHelper.debug("  Parsing " + line + total);
            ItemStack stack = IOHelper.getStack(line);
            Block block2 = block = stack != null && stack.func_77973_b() instanceof ItemBlock ? ((ItemBlock)stack.func_77973_b()).field_150939_a : null;
            if (block != null) {
                GrowthRequirementHandler.addDefaultSoil(new BlockWithMeta(block, stack.func_77960_j()));
                continue;
            }
            LogHelper.info(" Error when adding block to soil whitelist: Invalid block (line: " + line + ")");
        }
        LogHelper.info("Completed soil whitelist:");
        for (BlockWithMeta soil : soils) {
            LogHelper.info(" - " + Block.field_149771_c.func_148750_c((Object)soil.getBlock()) + ":" + soil.getMeta());
        }
    }

    public static void addAllToSoilWhitelist(Collection<? extends BlockWithMeta> list) {
        for (BlockWithMeta blockWithMeta : list) {
            GrowthRequirementHandler.addDefaultSoil(blockWithMeta);
        }
    }

    public static void removeAllFromSoilWhitelist(Collection<? extends BlockWithMeta> list) {
        defaultSoils.removeAll(list);
    }

    public static IGrowthRequirement getGrowthRequirement(Item seed, int meta) {
        if (seed == null) {
            return null;
        }
        if (seed instanceof IAgriCraftSeed) {
            return ((IAgriCraftSeed)seed).getPlant().getGrowthRequirement();
        }
        IGrowthRequirement growthRequirement = growthRequirements.get(new ItemWithMeta(seed, meta));
        if (growthRequirement == null) {
            growthRequirement = new GrowthRequirement.Builder().build();
            growthRequirements.put(new ItemWithMeta(seed, meta), growthRequirement);
        }
        return growthRequirement;
    }

    public static IGrowthRequirement getGrowthRequirement(CropPlant plant) {
        ItemStack seed = plant.getSeed();
        return GrowthRequirementHandler.getGrowthRequirement(seed.func_77973_b(), seed.func_77960_j());
    }

    public static void addSoil(BlockWithMeta block) {
        if (!soils.contains(block)) {
            soils.add(block);
        }
    }

    public static boolean addDefaultSoil(BlockWithMeta block) {
        if (!defaultSoils.contains(block)) {
            defaultSoils.add(block);
            return true;
        }
        return false;
    }
}

