/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.gui;

import com.InfinityRaider.AgriCraft.apiimpl.v1.PlantStats;
import com.InfinityRaider.AgriCraft.container.ContainerSeedStorageBase;
import com.InfinityRaider.AgriCraft.gui.Component;
import com.InfinityRaider.AgriCraft.tileentity.storage.ISeedStorageControllable;
import com.InfinityRaider.AgriCraft.tileentity.storage.SeedStorageSlot;
import com.InfinityRaider.AgriCraft.utility.SeedHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class GuiSeedStorageBase
extends GuiContainer {
    public ContainerSeedStorageBase container;
    Item activeSeed;
    int activeMeta;
    private int scrollPositionVertical;
    private int scrollPositionHorizontal;
    private int sortStatId = -1;
    protected static final int buttonIdGrowth = 0;
    protected static final int buttonIdGain = 1;
    protected static final int buttonIdStrength = 2;
    protected static final int buttonIdScrollDown = 3;
    protected static final int buttonIdScrollUp = 4;
    protected static final int buttonIdScrollLeft = 5;
    protected static final int buttonIdScrollRight = 6;
    protected static final int buttonIdDownEnd = 7;
    protected static final int buttonIdUpEnd = 8;
    protected static final int buttonIdLeftEnd = 9;
    protected static final int buttonIdRightEnd = 10;
    private final int maxVertSlots;
    private final int maxHorSlots;
    private final int sortButtonX;
    private final int sortButtonY;
    private final int setActiveSeedButtonOffset_X;
    private final int setActiveSeedButtonOffset_Y;
    private final int seedSlotButtonOffset_X;
    private final int seedSlotButtonOffset_Y;
    protected List<Component<PlantStatsStorage>> activeSeeds;
    protected List<Component<ItemStack>> setActiveSeedButtons;

    public GuiSeedStorageBase(ContainerSeedStorageBase container, int maxVertSlots, int maxHorSlots, int sortButtonX, int sortButtonY, int setActiveSeedButtonsX, int setActiveSeedButtonsY, int seedSlotsX, int seedSlotsY) {
        super((Container)container);
        this.container = container;
        this.maxVertSlots = maxVertSlots;
        this.maxHorSlots = maxHorSlots;
        this.sortButtonX = sortButtonX;
        this.sortButtonY = sortButtonY;
        this.setActiveSeedButtonOffset_X = setActiveSeedButtonsX;
        this.setActiveSeedButtonOffset_Y = setActiveSeedButtonsY;
        this.seedSlotButtonOffset_X = seedSlotsX;
        this.seedSlotButtonOffset_Y = seedSlotsY;
    }

    protected boolean hasActiveSeed() {
        return this.activeSeed != null;
    }

    protected void getActiveSeed() {
        TileEntity tile = this.container.getTileEntity();
        if (tile == null || !(tile instanceof ISeedStorageControllable)) {
            return;
        }
        ISeedStorageControllable storage = (ISeedStorageControllable)tile;
        ItemStack stack = storage.getLockedSeed();
        if (stack != null && stack.func_77973_b() != null) {
            this.activeSeed = stack.func_77973_b();
            this.activeMeta = stack.func_77960_j();
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.loadButtons();
    }

    protected void loadButtons() {
        this.field_146292_n.clear();
        int buttonWidth = 60;
        int buttonHeight = 12;
        this.field_146292_n.add(new GuiButton(0, this.field_147003_i + this.sortButtonX, this.field_147009_r + this.sortButtonY, buttonWidth, buttonHeight, StatCollector.func_74838_a((String)"agricraft_tooltip.growth")));
        this.field_146292_n.add(new GuiButton(1, this.field_147003_i + this.sortButtonX, this.field_147009_r + this.sortButtonY + buttonHeight + 1, buttonWidth, buttonHeight, StatCollector.func_74838_a((String)"agricraft_tooltip.gain")));
        this.field_146292_n.add(new GuiButton(2, this.field_147003_i + this.sortButtonX, this.field_147009_r + this.sortButtonY + 2 * (buttonHeight + 1), buttonWidth, buttonHeight, StatCollector.func_74838_a((String)"agricraft_tooltip.strength")));
        this.field_146292_n.add(new GuiButton(9, this.field_147003_i + this.sortButtonX, this.field_147009_r + this.sortButtonY + 3 * (buttonHeight + 1), -1 + buttonWidth / 4, buttonHeight, "<<"));
        this.field_146292_n.add(new GuiButton(5, this.field_147003_i + this.sortButtonX + buttonWidth / 4, this.field_147009_r + this.sortButtonY + 3 * (buttonHeight + 1), -1 + buttonWidth / 4, buttonHeight, "<"));
        this.field_146292_n.add(new GuiButton(6, this.field_147003_i + this.sortButtonX + 1 + 2 * buttonWidth / 4, this.field_147009_r + this.sortButtonY + 3 * (buttonHeight + 1), -1 + buttonWidth / 4, buttonHeight, ">"));
        this.field_146292_n.add(new GuiButton(10, this.field_147003_i + this.sortButtonX + 1 + 3 * buttonWidth / 4, this.field_147009_r + this.sortButtonY + 3 * (buttonHeight + 1), -1 + buttonWidth / 4, buttonHeight, ">>"));
    }

    private void initSetActiveSeedButtons() {
        if (this.setActiveSeedButtonOffset_X < 0 || this.setActiveSeedButtonOffset_Y < 0) {
            return;
        }
        this.setActiveSeedButtons = new ArrayList<Component<ItemStack>>();
        List<ItemStack> list = this.container.getSeedEntries();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                int xOffset = this.setActiveSeedButtonOffset_X + 16 * i % 64;
                int yOffset = this.setActiveSeedButtonOffset_Y + 16 * (i / 4);
                this.setActiveSeedButtons.add(new Component<ItemStack>(list.get(i), xOffset, yOffset, 16, 16));
            }
        }
    }

    private void initSeedSlots() {
        this.getActiveSeed();
        this.activeSeeds = new ArrayList<Component<PlantStatsStorage>>();
        List<SeedStorageSlot> list = this.container.getSeedSlots(this.activeSeed, this.activeMeta);
        if (list != null) {
            this.sortByStat(list);
            for (int i = this.scrollPositionHorizontal; i < Math.min(list.size(), this.scrollPositionHorizontal + this.maxHorSlots); ++i) {
                SeedStorageSlot slot = list.get(i);
                PlantStatsStorage stats = new PlantStatsStorage(slot.getId(), slot.getStack(this.activeSeed, this.activeMeta));
                this.activeSeeds.add(new Component<PlantStatsStorage>(stats, this.field_147003_i + this.seedSlotButtonOffset_X + (i - this.scrollPositionHorizontal) * 16, this.field_147009_r + this.seedSlotButtonOffset_Y, 16, 16));
            }
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k <= 2 && this.activeSeed != null) {
            this.sortStatId = button.field_146127_k;
        } else {
            switch (button.field_146127_k) {
                case 3: {
                    this.scrollVertical(-1);
                    break;
                }
                case 4: {
                    this.scrollVertical(1);
                    break;
                }
                case 6: {
                    this.scrollHorizontal(1);
                    break;
                }
                case 5: {
                    this.scrollHorizontal(-1);
                    break;
                }
                case 7: {
                    this.scrollVertical(this.getMaxVerticalScroll());
                    break;
                }
                case 8: {
                    this.scrollVertical(-this.getMaxVerticalScroll());
                    break;
                }
                case 9: {
                    this.scrollHorizontal(-this.getMaxHorizontalScroll());
                    break;
                }
                case 10: {
                    this.scrollHorizontal(this.getMaxHorizontalScroll());
                }
            }
        }
        this.func_73876_c();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.initSetActiveSeedButtons();
        this.initSeedSlots();
    }

    protected void func_73864_a(int x, int y, int rightClick) {
        if (this.setActiveSeedButtons != null) {
            for (Component<Object> component : this.setActiveSeedButtons) {
                if (!component.isOverComponent(this.field_147003_i + x, this.field_147009_r + y)) continue;
                this.setActiveSeed((ItemStack)component.getComponent());
                return;
            }
        }
        if (this.hasActiveSeed()) {
            for (Component<Object> component : this.activeSeeds) {
                if (!component.isOverComponent(x, y)) continue;
                PlantStatsStorage stats = (PlantStatsStorage)component.getComponent();
                int stackSize = GuiSeedStorageBase.func_146272_n() ? 64 : 1;
                this.container.moveStackFromTileEntityToPlayer(stats.id, new ItemStack(this.activeSeed, stackSize, this.activeMeta));
                this.func_73876_c();
                return;
            }
        }
        super.func_73864_a(x, y, rightClick);
    }

    private void sortByStat(List<SeedStorageSlot> list) {
        String stat = null;
        switch (this.sortStatId) {
            case 0: {
                stat = "growth";
                break;
            }
            case 1: {
                stat = "gain";
                break;
            }
            case 2: {
                stat = "strength";
            }
        }
        if (stat != null && this.activeSeed != null) {
            Collections.sort(list, new SeedStorageSlot.SlotComparator(stat));
        }
    }

    private void scrollVertical(int amount) {
        int newPos = this.scrollPositionVertical + amount;
        newPos = newPos < 0 ? 0 : newPos;
        int maxScrollY = this.getMaxVerticalScroll();
        this.scrollPositionVertical = newPos = newPos > maxScrollY ? maxScrollY : newPos;
    }

    private int getMaxVerticalScroll() {
        int nrSeedButtons = this.setActiveSeedButtons.size();
        int nrRows = (nrSeedButtons % 4 > 0 ? 1 : 0) + nrSeedButtons / 4;
        if (nrRows <= this.maxVertSlots) {
            return 0;
        }
        return nrRows - this.maxVertSlots;
    }

    private void scrollHorizontal(int amount) {
        if (this.hasActiveSeed()) {
            int newPos = this.scrollPositionHorizontal + amount;
            newPos = newPos < 0 ? 0 : newPos;
            int maxScrollX = this.getMaxHorizontalScroll();
            this.scrollPositionHorizontal = newPos = newPos > maxScrollX ? maxScrollX : newPos;
        }
    }

    private int getMaxHorizontalScroll() {
        int nrSlots = this.seedSlotAmount();
        if (nrSlots <= this.maxHorSlots) {
            return 0;
        }
        return nrSlots - this.maxHorSlots;
    }

    private int seedSlotAmount() {
        return this.hasActiveSeed() ? this.container.getSeedSlots(this.activeSeed, this.activeMeta).size() : 0;
    }

    protected void drawActiveEntries(int x, int y, ResourceLocation texture, int xOffset, int yOffset) {
        if (!this.hasActiveSeed()) {
            return;
        }
        int textureSize = 256;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < this.activeSeeds.size(); ++i) {
            Component<PlantStatsStorage> component = this.activeSeeds.get(i);
            if (component == null || component.getComponent() == null) continue;
            PlantStatsStorage stats = component.getComponent();
            short growth = stats.getGrowth();
            short gain = stats.getGain();
            short strength = stats.getStrength();
            ItemStack stack = new ItemStack(this.activeSeed, stats.amount, this.activeMeta);
            stack.field_77990_d = SeedHelper.setNBT(new NBTTagCompound(), growth, gain, strength, true);
            field_146296_j.func_77015_a(this.field_146289_q, Minecraft.func_71410_x().func_110434_K(), stack, component.xOffset(), component.yOffset());
            field_146296_j.func_77021_b(this.field_146289_q, Minecraft.func_71410_x().func_110434_K(), stack, component.xOffset(), component.yOffset());
            Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
            GL11.glDisable((int)2896);
            this.func_73729_b(this.field_147003_i + xOffset + i * 16 + 1, this.field_147009_r + yOffset - growth, 0, textureSize - growth, 3, growth);
            this.func_73729_b(this.field_147003_i + xOffset + i * 16 + 6, this.field_147009_r + yOffset - gain, 0, textureSize - gain, 3, gain);
            this.func_73729_b(this.field_147003_i + xOffset + i * 16 + 11, this.field_147009_r + yOffset - strength, 0, textureSize - strength, 3, strength);
            GL11.glEnable((int)2896);
        }
    }

    protected void drawScrollBarHorizontal(ResourceLocation texture) {
        int nrSlots = this.seedSlotAmount();
        int total = 224;
        int slotWidth = 16;
        int fullLength = nrSlots <= this.maxHorSlots ? total : slotWidth * nrSlots;
        float unit = (float)slotWidth / (float)fullLength * (float)total;
        int offset = (int)((float)this.scrollPositionHorizontal * unit);
        int length = (int)((float)this.maxHorSlots * unit);
        length = length <= 2 ? 0 : (length >= total ? total - 2 : length);
        offset = offset == 0 ? offset : offset - 1;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        int xOffset = this.field_147003_i + 6;
        int yOffset = this.field_147009_r + 39;
        this.func_73729_b(xOffset + offset, yOffset, 0, 135, 1, 5);
        this.func_73729_b(xOffset + offset + 1, yOffset, 1, 135, length, 4);
        this.func_73729_b(xOffset + offset + 1 + length, yOffset, total - 1, 135, 1, 5);
        GL11.glEnable((int)2896);
    }

    protected void drawTooltip(int x, int y) {
        if (!this.hasActiveSeed()) {
            return;
        }
        for (int i = 0; i < this.activeSeeds.size(); ++i) {
            Component<PlantStatsStorage> component = this.activeSeeds.get(i);
            if (component == null || component.getComponent() == null || !component.isOverComponent(x, y)) continue;
            PlantStatsStorage stats = component.getComponent();
            short growth = stats.getGrowth();
            short gain = stats.getGain();
            short strength = stats.getStrength();
            ItemStack stack = new ItemStack(this.activeSeed, stats.amount, this.activeMeta);
            stack.field_77990_d = SeedHelper.setNBT(new NBTTagCompound(), growth, gain, strength, true);
            List toolTip = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, true);
            this.drawHoveringText(toolTip, x - this.field_147003_i, y - this.field_147009_r, this.field_146289_q);
        }
    }

    protected void setActiveSeed(ItemStack stack) {
        this.activeSeed = stack.func_77973_b();
        this.activeMeta = stack.func_77960_j();
    }

    public boolean func_73868_f() {
        return false;
    }

    protected static class PlantStatsStorage
    extends PlantStats {
        private int id;
        private int amount;

        public PlantStatsStorage(int id, ItemStack stack) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag != null) {
                PlantStats temp = PlantStats.readFromNBT(tag);
                this.setStats(temp.getGrowth(), temp.getGain(), temp.getStrength());
            }
            this.amount = stack.field_77994_a;
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public int amount() {
            return this.amount;
        }
    }
}

