/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.gui.journal;

import com.InfinityRaider.AgriCraft.gui.Component;
import com.InfinityRaider.AgriCraft.gui.journal.JournalPage;
import com.InfinityRaider.AgriCraft.gui.journal.JournalPageIntroduction;
import com.InfinityRaider.AgriCraft.gui.journal.JournalPageSeed;
import com.InfinityRaider.AgriCraft.gui.journal.JournalPageTitle;
import com.InfinityRaider.AgriCraft.items.ItemJournal;
import com.InfinityRaider.AgriCraft.utility.IOHelper;
import com.InfinityRaider.AgriCraft.utility.RenderHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiJournal
extends GuiScreen {
    private static final int MINIMUM_PAGES = 2;
    private int xSize;
    private int ySize;
    private int guiLeft;
    private int guiTop;
    private int currentPage;
    private ItemStack journal;

    public GuiJournal(ItemStack journal) {
        this.journal = journal;
        int pageWidth = 128;
        this.xSize = pageWidth * 2;
        this.ySize = pageWidth * 3 / 2;
    }

    public void func_73866_w_() {
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - 16 - this.ySize) / 2;
    }

    public void func_73863_a(int x, int y, float opacity) {
        ArrayList<Component<ItemStack>> itemComponents;
        ArrayList<Component<ResourceLocation>> iconComponents;
        JournalPage page = this.getCurrentPage();
        this.func_146278_c(0);
        this.drawTexture(page.getForeground());
        ArrayList<Component<String>> textComponents = page.getTextComponents();
        if (textComponents != null) {
            for (Component<String> textComponent : textComponents) {
                this.drawTextComponent(textComponent);
            }
        }
        if ((iconComponents = page.getTextureComponents()) != null) {
            for (Component<ResourceLocation> iconComponent : iconComponents) {
                this.drawTextureComponent(iconComponent);
            }
        }
        if ((itemComponents = page.getItemComponents()) != null) {
            for (Component<ItemStack> itemComponent : itemComponents) {
                this.drawItemComponent(itemComponent);
            }
        }
        this.drawNavigationArrows(x, y);
        ArrayList<String> toolTip = page.getTooltip(x - this.guiLeft, y - this.guiTop);
        if (toolTip != null) {
            this.drawTooltip(toolTip, x, y);
        }
    }

    public void func_73864_a(int x, int y, int rightClick) {
        int pageIncrement = 0;
        if (y > this.guiTop + 172 && y <= this.guiTop + 172 + 16 && rightClick == 0) {
            if (x > this.guiLeft + 221 && x <= this.guiLeft + 221 + 16) {
                pageIncrement = 1;
            } else if (x > this.guiLeft + 19 && x <= this.guiLeft + 19 + 16 && this.currentPage > 0) {
                pageIncrement = -1;
            }
        } else {
            pageIncrement = this.getCurrentPage().getPagesToBrowseOnMouseClick(x - this.guiLeft, y - this.guiTop);
        }
        int newPage = this.currentPage + pageIncrement;
        newPage = Math.max(0, newPage);
        newPage = Math.min(newPage, this.getNumberOfPages() - 1);
        if (newPage != this.currentPage) {
            this.currentPage = newPage;
        }
    }

    private JournalPage getCurrentPage() {
        switch (this.currentPage) {
            case 0: {
                return new JournalPageTitle();
            }
            case 1: {
                return new JournalPageIntroduction();
            }
        }
        ArrayList<ItemStack> discoveredSeeds = this.getDiscoveredSeeds();
        return new JournalPageSeed(discoveredSeeds, this.currentPage - 2);
    }

    private ArrayList<ItemStack> getDiscoveredSeeds() {
        return ((ItemJournal)this.journal.func_77973_b()).getDiscoveredSeeds(this.journal);
    }

    private int getNumberOfPages() {
        return 2 + this.getDiscoveredSeeds().size();
    }

    public void func_146278_c(int i) {
        this.drawTexture(JournalPage.getBackground());
    }

    private void drawTexture(ResourceLocation texture) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    private void drawTextComponent(Component<String> component) {
        if (component != null) {
            float scale = component.scale();
            int x = this.guiLeft + component.xOffset();
            int y = this.guiTop + component.yOffset();
            String[] text = IOHelper.getLinesArrayFromData(component.getComponent());
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            for (String paragraph : text) {
                String[] write = IOHelper.getLinesArrayFromData(RenderHelper.splitInLines(this.field_146289_q, paragraph, 95.0f, scale));
                for (int i = 0; i < write.length; ++i) {
                    String line = write[i];
                    int xOffset = component.centered() ? -this.field_146289_q.func_78256_a(line) / 2 : 0;
                    int yOffset = i * this.field_146289_q.field_78288_b;
                    this.field_146289_q.func_78276_b(line, (int)((float)x / scale) + xOffset, (int)((float)y / scale) + yOffset, 0x191616);
                }
                y += (int)((float)this.field_146289_q.field_78288_b / scale);
            }
            GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
        }
    }

    private void drawTextureComponent(Component<ResourceLocation> component) {
        if (component != null) {
            ResourceLocation texture = component.getComponent();
            int xSize = component.xSize();
            int ySize = component.ySize();
            int x = this.guiLeft + component.xOffset();
            int y = this.guiTop + component.yOffset();
            Tessellator tessellator = Tessellator.field_78398_a;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)x, (double)(y + ySize), (double)this.field_73735_i, 0.0, 1.0);
            tessellator.func_78374_a((double)(x + xSize), (double)(y + ySize), (double)this.field_73735_i, 1.0, 1.0);
            tessellator.func_78374_a((double)(x + xSize), (double)y, (double)this.field_73735_i, 1.0, 0.0);
            tessellator.func_78374_a((double)x, (double)y, (double)this.field_73735_i, 0.0, 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)2896);
        }
    }

    private void drawItemComponent(Component<ItemStack> component) {
        if (component != null) {
            int x = this.guiLeft + component.xOffset();
            int y = this.guiTop + component.yOffset();
            ItemStack stack = component.getComponent();
            GuiScreen.field_146296_j.func_77015_a(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), stack, x, y);
        }
    }

    private void drawNavigationArrows(int x, int y) {
        if (y > this.guiTop + 172 && y <= this.guiTop + 172 + 16) {
            if (x > this.guiLeft + 221 && x <= this.guiLeft + 221 + 16) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(JournalPage.getBackground());
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)2896);
                GL11.glEnable((int)3008);
                this.func_73729_b(this.guiLeft + 223, this.guiTop + 178, 224, 239, 32, 17);
                GL11.glDisable((int)3008);
                GL11.glEnable((int)2896);
            } else if (x > this.guiLeft + 19 && x <= this.guiLeft + 19 + 16 && this.currentPage > 0) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(JournalPage.getBackground());
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)2896);
                GL11.glEnable((int)3008);
                this.func_73729_b(this.guiLeft + 1, this.guiTop + 178, 0, 239, 32, 17);
                GL11.glDisable((int)3008);
                GL11.glEnable((int)2896);
            }
        }
    }

    private void drawTooltip(ArrayList<String> toolTip, int x, int y) {
        this.drawHoveringText(toolTip, x, y, this.field_146289_q);
    }

    public boolean func_73868_f() {
        return false;
    }
}

