/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.gui.journal;

import com.InfinityRaider.AgriCraft.api.v1.BlockWithMeta;
import com.InfinityRaider.AgriCraft.apiimpl.v1.cropplant.CropPlant;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.farming.GrowthRequirementHandler;
import com.InfinityRaider.AgriCraft.farming.mutation.Mutation;
import com.InfinityRaider.AgriCraft.farming.mutation.MutationHandler;
import com.InfinityRaider.AgriCraft.gui.Component;
import com.InfinityRaider.AgriCraft.gui.journal.JournalPage;
import com.InfinityRaider.AgriCraft.utility.RenderHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

@SideOnly(value=Side.CLIENT)
public class JournalPageSeed
extends JournalPage {
    private static final ResourceLocation ICON_FRAME = new ResourceLocation("AgriCraft".toLowerCase(), "textures/gui/journal/GuiJournalSeedFrame.png");
    private static final ResourceLocation MUTATION_TEMPLATE = new ResourceLocation("AgriCraft".toLowerCase(), "textures/gui/journal/GuiJournalMutationTemplate.png");
    private ArrayList<ItemStack> discoveredSeeds;
    private int page;
    private CropPlant plant;
    private ArrayList<Component<ItemStack>> fruits;
    private ArrayList<Component<ItemStack>> seeds;

    public JournalPageSeed(ArrayList<ItemStack> discoveredSeeds, int page) {
        this.discoveredSeeds = discoveredSeeds;
        this.page = page;
        this.plant = CropPlantHandler.getPlantFromStack(discoveredSeeds.get(page));
        this.fruits = this.getFruits();
        this.seeds = this.getSeeds();
    }

    @Override
    public ResourceLocation getForeground() {
        return new ResourceLocation("AgriCraft".toLowerCase(), "textures/gui/journal/GuiJournalSeedPage.png");
    }

    @Override
    public ArrayList<String> getTooltip(int x, int y) {
        for (Component<ItemStack> component : this.fruits) {
            if (!component.isOverComponent(x, y)) continue;
            ArrayList<String> toolTip = new ArrayList<String>();
            toolTip.add(component.getComponent().func_82833_r());
            return toolTip;
        }
        for (Component<ItemStack> component : this.seeds) {
            if (!component.isOverComponent(x, y)) continue;
            ArrayList<String> toolTip = new ArrayList<String>();
            toolTip.add(component.getComponent().func_82833_r());
            return toolTip;
        }
        return null;
    }

    @Override
    public int getPagesToBrowseOnMouseClick(int x, int y) {
        for (Component<ItemStack> component : this.seeds) {
            if (!component.isOverComponent(x, y)) continue;
            ItemStack selected = component.getComponent();
            for (int i = 0; i < this.discoveredSeeds.size(); ++i) {
                ItemStack current = this.discoveredSeeds.get(i);
                if (selected.func_77973_b() != current.func_77973_b() || selected.func_77960_j() != current.func_77960_j()) continue;
                return i - this.page;
            }
        }
        return 0;
    }

    @Override
    public ArrayList<Component<String>> getTextComponents() {
        ArrayList<Component<String>> textComponents = new ArrayList<Component<String>>();
        textComponents.add(this.getTitle());
        textComponents.add(this.getDescriptionHead());
        textComponents.add(this.getSeedInformation());
        textComponents.add(this.getTier());
        textComponents.add(this.getFruitTitle());
        textComponents.add(this.getGrowthTitle());
        textComponents.addAll(this.getMutationTitles());
        return textComponents;
    }

    private Component<String> getTitle() {
        String text = this.plant.getSeed().func_82833_r();
        int x = 82;
        int y = 17;
        float scale = 0.8f;
        while ((float)Minecraft.func_71410_x().field_71466_p.func_78256_a(text) * scale > 74.0f) {
            scale -= 0.1f;
        }
        return new Component<String>(text, x, y, scale, true);
    }

    private Component<String> getDescriptionHead() {
        String text = StatCollector.func_74838_a((String)"agricraft_journal.information") + ": ";
        int x = 29;
        int y = 31;
        float scale = 0.5f;
        return new Component<String>(text, x, y, scale);
    }

    private Component<String> getSeedInformation() {
        String text = StatCollector.func_74838_a((String)this.plant.getInformation());
        int x = 29;
        int y = 38;
        float scale = 0.5f;
        return new Component<String>(text, x, y, scale);
    }

    private Component<String> getTier() {
        String text = StatCollector.func_74838_a((String)"agricraft_journal.tier") + ": " + this.plant.getTier();
        int x = 29;
        int y = 70;
        float scale = 0.5f;
        return new Component<String>(text, x, y, scale);
    }

    private Component<String> getFruitTitle() {
        String text = StatCollector.func_74838_a((String)"agricraft_journal.fruits") + ": ";
        int x = 29;
        int y = 84;
        float scale = 0.5f;
        return new Component<String>(text, x, y, scale);
    }

    private Component<String> getGrowthTitle() {
        String text = StatCollector.func_74838_a((String)"agricraft_journal.growthStages") + ": ";
        int x = 29;
        int y = 117;
        float scale = 0.5f;
        return new Component<String>(text, x, y, scale);
    }

    private ArrayList<Component<String>> getMutationTitles() {
        String parentText = StatCollector.func_74838_a((String)"agricraft_journal.parentMutations") + ": ";
        String childText = StatCollector.func_74838_a((String)"agricraft_journal.childMutations") + ": ";
        int x = 132;
        int y = 13;
        int n = this.getDiscoveredParentMutations().size();
        int m = this.getDiscoveredChildMutations().size();
        int offset = n == 0 ? 0 : n * 20 + 10;
        float scale = 0.5f;
        ArrayList<Component<String>> list = new ArrayList<Component<String>>();
        if (n > 0) {
            list.add(new Component<String>(parentText, x, y, scale));
        }
        if (m > 0) {
            list.add(new Component<String>(childText, x, y + offset, scale));
        }
        return list;
    }

    @Override
    public ArrayList<Component<ItemStack>> getItemComponents() {
        ArrayList<Component<ItemStack>> itemComponents = new ArrayList<Component<ItemStack>>();
        itemComponents.add(this.getSeed());
        itemComponents.addAll(this.fruits);
        itemComponents.addAll(this.seeds);
        return itemComponents;
    }

    private Component<ItemStack> getSeed() {
        ItemStack stack = this.plant.getSeed();
        int x = 26;
        int y = 11;
        return new Component<ItemStack>(stack, x, y);
    }

    private ArrayList<Component<ItemStack>> getFruits() {
        if (this.plant == null) {
            this.plant = CropPlantHandler.getPlantFromStack(this.discoveredSeeds.get(this.page));
        }
        ArrayList<Component<ItemStack>> fruits = new ArrayList<Component<ItemStack>>();
        ArrayList<ItemStack> allFruits = this.plant.getAllFruits();
        if (allFruits != null) {
            for (int i = 0; i < allFruits.size(); ++i) {
                ItemStack stack = allFruits.get(i);
                if (stack == null || stack.func_77973_b() == null) continue;
                int x = 30 + 24 * i;
                int y = 91;
                fruits.add(new Component<ItemStack>(stack, x, y, 16, 16));
            }
        }
        return fruits;
    }

    private ArrayList<Component<ItemStack>> getSeeds() {
        ItemStack parent2Stack;
        ItemStack parent1Stack;
        ItemStack resultStack;
        int x;
        int y;
        Mutation mutation;
        int i;
        ArrayList<Mutation> parentMutations = this.getDiscoveredParentMutations();
        ArrayList<Mutation> childMutations = this.getDiscoveredChildMutations();
        ArrayList<Component<ItemStack>> seeds = new ArrayList<Component<ItemStack>>();
        int n = parentMutations.size();
        for (i = 0; i < n; ++i) {
            mutation = parentMutations.get(i);
            y = 21 + i * 20;
            x = 132;
            resultStack = mutation.getResult();
            parent1Stack = mutation.getParents()[0];
            parent2Stack = mutation.getParents()[1];
            seeds.add(new Component<ItemStack>(parent1Stack, x, y, 16, 16));
            seeds.add(new Component<ItemStack>(parent2Stack, x + 35, y, 16, 16));
            seeds.add(new Component<ItemStack>(resultStack, x + 69, y, 16, 16));
        }
        for (i = 0; i < childMutations.size(); ++i) {
            mutation = childMutations.get(i);
            y = (n == 0 ? 21 : 31) + (n + i) * 20;
            x = 132;
            resultStack = mutation.getResult();
            parent1Stack = mutation.getParents()[0];
            parent2Stack = mutation.getParents()[1];
            seeds.add(new Component<ItemStack>(parent1Stack, x, y, 16, 16));
            seeds.add(new Component<ItemStack>(parent2Stack, x + 35, y, 16, 16));
            seeds.add(new Component<ItemStack>(resultStack, x + 69, y, 16, 16));
        }
        return seeds;
    }

    private ArrayList<Mutation> getDiscoveredParentMutations() {
        ArrayList<Mutation> allMutations = new ArrayList<Mutation>();
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        allMutations.addAll(Arrays.asList(MutationHandler.getMutationsFromParent(this.discoveredSeeds.get(this.page))));
        for (Mutation mutation : allMutations) {
            if (!this.isMutationDiscovered(mutation)) continue;
            mutations.add(mutation);
        }
        return mutations;
    }

    private ArrayList<Mutation> getDiscoveredChildMutations() {
        ArrayList<Mutation> allMutations = new ArrayList<Mutation>();
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        allMutations.addAll(Arrays.asList(MutationHandler.getMutationsFromChild(this.discoveredSeeds.get(this.page))));
        for (Mutation mutation : allMutations) {
            if (!this.isMutationDiscovered(mutation)) continue;
            mutations.add(mutation);
        }
        return mutations;
    }

    private boolean isMutationDiscovered(Mutation mutation) {
        ItemStack resultStack = mutation.getResult();
        ItemStack parent1Stack = mutation.getParents()[0];
        ItemStack parent2Stack = mutation.getParents()[1];
        return this.isSeedDiscovered(parent1Stack) && this.isSeedDiscovered(parent2Stack) && this.isSeedDiscovered(resultStack);
    }

    private boolean isSeedDiscovered(ItemStack seed) {
        for (ItemStack current : this.discoveredSeeds) {
            if (current.func_77973_b() != seed.func_77973_b() || current.func_77960_j() != seed.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<Component<ResourceLocation>> getTextureComponents() {
        ArrayList<Component<ResourceLocation>> textureComponents = new ArrayList<Component<ResourceLocation>>();
        textureComponents.add(this.getSoil());
        textureComponents.addAll(this.getGrowthStages());
        textureComponents.addAll(this.getFruitIconFrames());
        textureComponents.addAll(this.getMutationTemplates());
        return textureComponents;
    }

    private Component<ResourceLocation> getSoil() {
        ItemStack seed = this.plant.getSeed();
        BlockWithMeta soil = GrowthRequirementHandler.getGrowthRequirement(seed.func_77973_b(), seed.func_77960_j()).getSoil();
        ResourceLocation texture = soil != null ? RenderHelper.getBlockResource(soil.getBlock().func_149691_a(1, soil.getMeta())) : RenderHelper.getBlockResource(Blocks.field_150458_ak.func_149691_a(1, 7));
        int x = 26;
        int y = 11;
        return new Component<ResourceLocation>(texture, x, y, 16, 16);
    }

    private ArrayList<Component<ResourceLocation>> getGrowthStages() {
        ArrayList<Component<ResourceLocation>> growthStages = new ArrayList<Component<ResourceLocation>>();
        for (int i = 0; i < 8; ++i) {
            ResourceLocation texture = RenderHelper.getBlockResource(this.plant.getPlantIcon(i));
            int x = 30 + 24 * (i % 4);
            int y = 124 + 24 * (i / 4);
            growthStages.add(new Component<ResourceLocation>(texture, x, y, 16, 16));
        }
        return growthStages;
    }

    private ArrayList<Component<ResourceLocation>> getFruitIconFrames() {
        if (this.fruits == null) {
            this.fruits = this.getFruits();
        }
        ArrayList<Component<ResourceLocation>> components = new ArrayList<Component<ResourceLocation>>();
        for (int i = 0; i < this.fruits.size(); ++i) {
            components.add(new Component<ResourceLocation>(ICON_FRAME, 29 + 24 * i, 90, 18, 18));
        }
        return components;
    }

    private ArrayList<Component<ResourceLocation>> getMutationTemplates() {
        int i;
        int n = this.getDiscoveredParentMutations().size();
        int m = this.getDiscoveredChildMutations().size();
        ArrayList<Component<ResourceLocation>> components = new ArrayList<Component<ResourceLocation>>();
        for (i = 0; i < n; ++i) {
            components.add(new Component<ResourceLocation>(MUTATION_TEMPLATE, 132, 20 + 20 * i, 86, 18));
        }
        for (i = 0; i < m; ++i) {
            components.add(new Component<ResourceLocation>(MUTATION_TEMPLATE, 132, (n == 0 ? 20 : 30) + 20 * (i + n), 86, 18));
        }
        return components;
    }
}

