/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.init;

import com.InfinityRaider.AgriCraft.blocks.BlockCustomWood;
import com.InfinityRaider.AgriCraft.compatibility.ModHelper;
import com.InfinityRaider.AgriCraft.compatibility.computercraft.ComputerCraftHelper;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.init.Blocks;
import com.InfinityRaider.AgriCraft.init.Items;
import com.InfinityRaider.AgriCraft.items.ItemAgricraft;
import com.InfinityRaider.AgriCraft.items.blocks.ItemBlockCustomWood;
import com.InfinityRaider.AgriCraft.items.crafting.RecipeJournal;
import com.InfinityRaider.AgriCraft.items.crafting.RecipeShapelessCustomWood;
import com.InfinityRaider.AgriCraft.reference.Data;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import com.InfinityRaider.AgriCraft.utility.OreDictHelper;
import com.InfinityRaider.AgriCraft.utility.RegisterHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class Recipes {
    public static final ItemStack REFERENCE = new ItemStack(net.minecraft.init.Blocks.field_150344_f, 1);
    private static List<ItemStack> woodList;

    public static void init() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Items.crops, ConfigurationHandler.cropsPerCraft), new Object[]{"ss", "ss", Character.valueOf('s'), "stickWood"}));
        if (ConfigurationHandler.cropsPerCraft == 3) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(net.minecraft.init.Items.field_151055_y, 6 / ConfigurationHandler.cropsPerCraft), (Object[])new Object[]{new ItemStack((Item)Items.crops), new ItemStack((Item)Items.crops)});
        } else {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(net.minecraft.init.Items.field_151055_y, 4 / ConfigurationHandler.cropsPerCraft), (Object[])new Object[]{new ItemStack((Item)Items.crops)});
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.blockSeedAnalyzer, 1), new Object[]{"sgs", " bs", "pwp", Character.valueOf('s'), "stickWood", Character.valueOf('g'), "paneGlass", Character.valueOf('b'), net.minecraft.init.Blocks.field_150333_U, Character.valueOf('p'), "plankWood", Character.valueOf('w'), "slabWood"}));
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)Item.field_150901_e.func_82594_a("AgriCraft:seedPotato")), (Object[])new Object[]{new ItemStack(net.minecraft.init.Items.field_151174_bG)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)Item.field_150901_e.func_82594_a("AgriCraft:seedCarrot")), (Object[])new Object[]{new ItemStack(net.minecraft.init.Items.field_151172_bF)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(net.minecraft.init.Items.field_151014_N), (Object[])new Object[]{new ItemStack(net.minecraft.init.Items.field_151015_O)});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Items.journal, 1), new Object[]{"csc", "sbs", "csc", Character.valueOf('c'), Items.crops, Character.valueOf('s'), "listAllseed", Character.valueOf('b'), net.minecraft.init.Items.field_151099_bA}));
        GameRegistry.addRecipe((IRecipe)new RecipeJournal());
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Items.trowel, 1, 0), new Object[]{"  s", "ii ", Character.valueOf('s'), "stickWood", Character.valueOf('i'), "ingotIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Items.magnifyingGlass, 1, 0), new Object[]{"sgs", " s ", " s ", Character.valueOf('s'), "stickWood", Character.valueOf('g'), "paneGlass"}));
        if (ConfigurationHandler.enableHandRake && Items.handRake != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Items.handRake, 1, 0), new Object[]{"fs", Character.valueOf('f'), net.minecraft.init.Blocks.field_150422_aJ, Character.valueOf('s'), "stickWood"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Items.handRake, 1, 1), new Object[]{"fs", Character.valueOf('f'), net.minecraft.init.Blocks.field_150411_aY, Character.valueOf('s'), "stickWood"}));
        }
        if (ModHelper.allowIntegration("ComputerCraft") && Blocks.blockPeripheral != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.blockPeripheral, 1), new Object[]{"iai", "rcr", "iri", Character.valueOf('i'), "ingotIron", Character.valueOf('a'), Blocks.blockSeedAnalyzer, Character.valueOf('r'), net.minecraft.init.Items.field_151132_bS, Character.valueOf('c'), ComputerCraftHelper.getComputerBlock()}));
        }
        Recipes.registerCustomWoodRecipes();
        if (!ConfigurationHandler.disableIrrigation) {
            RegisterHelper.removeRecipe(new ItemStack(net.minecraft.init.Items.field_151054_z));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(net.minecraft.init.Items.field_151054_z, 4), new Object[]{"w w", " w ", Character.valueOf('w'), "slabWood"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.blockSprinkler, 1), new Object[]{" w ", " i ", "bcb", Character.valueOf('w'), "plankWood", Character.valueOf('i'), "ingotIron", Character.valueOf('b'), net.minecraft.init.Blocks.field_150411_aY, Character.valueOf('c'), net.minecraft.init.Items.field_151133_ar}));
        }
        if (ConfigurationHandler.resourcePlants) {
            if (OreDictHelper.getNuggetForName("Diamond") instanceof ItemAgricraft) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(net.minecraft.init.Items.field_151045_i, 1), new Object[]{"nnn", "nnn", "nnn", Character.valueOf('n'), "nuggetDiamond"}));
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(OreDictHelper.getNuggetForName("Diamond"), 9), new Object[]{"gemDiamond"}));
            }
            if (OreDictHelper.getNuggetForName("Emerald") instanceof ItemAgricraft) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(net.minecraft.init.Items.field_151166_bC, 1), new Object[]{"nnn", "nnn", "nnn", Character.valueOf('n'), "nuggetEmerald"}));
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(OreDictHelper.getNuggetForName("Emerald"), 9), new Object[]{"gemEmerald"}));
            }
            if (OreDictHelper.getNuggetForName("Iron") instanceof ItemAgricraft) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(net.minecraft.init.Items.field_151042_j, 1), new Object[]{"nnn", "nnn", "nnn", Character.valueOf('n'), "nuggetIron"}));
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(OreDictHelper.getNuggetForName("Iron"), 9), new Object[]{"ingotIron"}));
            }
            if (OreDictHelper.getNuggetForName("Quartz") instanceof ItemAgricraft) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(net.minecraft.init.Items.field_151128_bU, 1), new Object[]{"nnn", "nnn", "nnn", Character.valueOf('n'), "nuggetQuartz"}));
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(OreDictHelper.getNuggetForName("Quartz"), 9), new Object[]{new ItemStack(net.minecraft.init.Items.field_151128_bU, 1)}));
            }
            for (String[] data : Data.modResources) {
                String oreName = data[0];
                Item nuggetItem = OreDictHelper.getNuggetForName(oreName);
                if (nuggetItem == null || !(nuggetItem instanceof ItemAgricraft)) continue;
                ItemStack nugget = new ItemStack(nuggetItem, 9, OreDictHelper.getNuggetMetaForName(oreName));
                ItemStack ingot = OreDictHelper.getIngot(oreName);
                if (ingot != null) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ingot, new Object[]{"nnn", "nnn", "nnn", Character.valueOf('n'), "nugget" + oreName}));
                }
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(nugget, new Object[]{"ingot" + oreName}));
            }
            LogHelper.debug("Recipes Registered");
        }
    }

    private static void registerCustomWoodRecipes() {
        if (Recipes.initWoodList()) {
            if (!ConfigurationHandler.disableIrrigation) {
                ItemStack channel = new ItemStack(Blocks.blockWaterChannel, 1);
                ItemStack channelFull = new ItemStack(Blocks.blockWaterChannelFull, 1);
                Recipes.registerCustomWoodRecipe(Blocks.blockWaterTank, 1, true, "w w", "w w", "www", Character.valueOf('w'), REFERENCE);
                Recipes.registerCustomWoodRecipe(Blocks.blockWaterChannel, 6, true, "w w", " w ", Character.valueOf('w'), REFERENCE);
                Recipes.registerCustomWoodRecipe(Blocks.blockWaterChannelFull, 1, false, channel, channel, channel, channel);
                Recipes.registerCustomWoodRecipe(Blocks.blockWaterChannel, 4, false, channelFull);
                Recipes.registerCustomWoodRecipe(Blocks.blockChannelValve, 1, false, new ItemStack(net.minecraft.init.Items.field_151042_j, 1), new ItemStack(net.minecraft.init.Blocks.field_150442_at, 1), channel);
            }
            if (!ConfigurationHandler.disableSeedStorage) {
                Recipes.registerCustomWoodRecipe(Blocks.blockSeedStorage, 1, true, "wiw", "wcw", "wcw", Character.valueOf('w'), REFERENCE, Character.valueOf('i'), net.minecraft.init.Items.field_151042_j, Character.valueOf('c'), net.minecraft.init.Blocks.field_150486_ae);
            }
            if (!ConfigurationHandler.disableFences) {
                ItemStack fence = new ItemStack(Blocks.blockFence, 1);
                Recipes.registerCustomWoodRecipe(Blocks.blockFence, 8, true, "fff", "fwf", "fff", Character.valueOf('w'), REFERENCE, Character.valueOf('f'), net.minecraft.init.Blocks.field_150422_aJ);
                Recipes.registerCustomWoodRecipe(Blocks.blockFenceGate, 1, true, "fwf", Character.valueOf('w'), REFERENCE, Character.valueOf('f'), fence);
            }
            if (!ConfigurationHandler.disableGrates) {
                Recipes.registerCustomWoodRecipe(Blocks.blockGrate, 8, true, "w w", " w ", "w w", Character.valueOf('w'), REFERENCE);
            }
        }
    }

    private static boolean initWoodList() {
        if (woodList != null && woodList.size() > 0) {
            return true;
        }
        for (Field field : Blocks.class.getDeclaredFields()) {
            try {
                Object obj;
                if (field.get(null) == null || !((obj = field.get(null)) instanceof BlockCustomWood)) continue;
                woodList = new ArrayList<ItemStack>();
                ((ItemBlockCustomWood)Item.func_150898_a((Block)((BlockCustomWood)((Object)obj)))).getSubItems(woodList);
                return true;
            }
            catch (Exception e) {
                LogHelper.printStackTrace(e);
            }
        }
        return false;
    }

    public static void registerCustomWoodRecipe(Block block, int stackSize, boolean shaped, Object ... params) {
        for (ItemStack stack : woodList) {
            if (!stack.func_77942_o() || !stack.field_77990_d.func_74764_b("material") || !stack.field_77990_d.func_74764_b("matMeta")) continue;
            NBTTagCompound materialTag = stack.func_77978_p();
            ItemStack plank = new ItemStack((Block)Block.field_149771_c.func_82594_a(materialTag.func_74779_i("material")), 1, materialTag.func_74762_e("matMeta"));
            Object[] ingredients = Arrays.copyOf(params, params.length);
            for (int i = 0; i < ingredients.length; ++i) {
                if (ingredients[i] instanceof ItemStack && ((ItemStack)ingredients[i]).func_77969_a(REFERENCE)) {
                    ingredients[i] = plank;
                }
                if (!(ingredients[i] instanceof ItemStack) || ingredients[i] == null || !(((ItemStack)ingredients[i]).func_77973_b() instanceof ItemBlockCustomWood)) continue;
                ((ItemStack)ingredients[i]).field_77990_d = materialTag;
            }
            ItemStack result = new ItemStack(block, stackSize);
            result.field_77990_d = materialTag;
            if (shaped) {
                GameRegistry.addShapedRecipe((ItemStack)result, (Object[])ingredients);
                continue;
            }
            Recipes.addShapelessCustomWoodRecipe(result, ingredients);
        }
    }

    public static void registerCustomWoodRecipe(IRecipe recipe) {
        if (recipe instanceof ShapedRecipes) {
            ShapedRecipes shapedRecipe = (ShapedRecipes)recipe;
            Recipes.registerCustomWoodRecipe(((ItemBlock)shapedRecipe.func_77571_b().func_77973_b()).field_150939_a, shapedRecipe.func_77571_b().field_77994_a, true, shapedRecipe.field_77574_d);
        } else if (recipe instanceof ShapelessRecipes) {
            ShapelessRecipes shapelessRecipe = (ShapelessRecipes)recipe;
            Recipes.registerCustomWoodRecipe(((ItemBlock)shapelessRecipe.func_77571_b().func_77973_b()).field_150939_a, shapelessRecipe.func_77571_b().field_77994_a, false, shapelessRecipe.field_77579_b.toArray(new ItemStack[0]));
        }
    }

    private static void addShapelessCustomWoodRecipe(ItemStack output, Object ... params) {
        ArrayList<ItemStack> recipeItemsCopy = new ArrayList<ItemStack>();
        for (int j = 0; j < params.length; ++j) {
            Object recipeItem = params[j];
            if (recipeItem instanceof ItemStack) {
                recipeItemsCopy.add(((ItemStack)recipeItem).func_77946_l());
                continue;
            }
            if (recipeItem instanceof Item) {
                recipeItemsCopy.add(new ItemStack((Item)recipeItem));
                continue;
            }
            if (!(recipeItem instanceof Block)) {
                throw new RuntimeException("Invalid shapeless recipe!");
            }
            recipeItemsCopy.add(new ItemStack((Block)recipeItem));
        }
        RecipeShapelessCustomWood recipe = new RecipeShapelessCustomWood(output, recipeItemsCopy);
        GameRegistry.addRecipe((IRecipe)recipe);
    }
}

