/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.items;

import com.InfinityRaider.AgriCraft.api.v1.ISeedStats;
import com.InfinityRaider.AgriCraft.api.v1.ITrowel;
import com.InfinityRaider.AgriCraft.apiimpl.v1.PlantStats;
import com.InfinityRaider.AgriCraft.apiimpl.v1.cropplant.CropPlant;
import com.InfinityRaider.AgriCraft.creativetab.AgriCraftTab;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.items.ItemAgricraft;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import com.InfinityRaider.AgriCraft.utility.SeedHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemTrowel
extends ItemAgricraft
implements ITrowel {
    private IIcon[] icons = new IIcon[2];

    public ItemTrowel() {
        this.func_77637_a(AgriCraftTab.agriCraftTab);
        this.field_77777_bU = 1;
    }

    @Override
    protected String getInternalName() {
        return "trowel";
    }

    public boolean func_82788_x() {
        return true;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public boolean hasSeed(ItemStack trowel) {
        if (trowel == null || trowel.func_77973_b() == null || trowel.field_77990_d == null) {
            return false;
        }
        return CropPlantHandler.readPlantFromNBT(trowel.field_77990_d.func_74775_l("seed")) != null;
    }

    @Override
    public boolean isSeedAnalysed(ItemStack trowel) {
        if (!this.hasSeed(trowel)) {
            return false;
        }
        return trowel.field_77990_d.func_74764_b("analyzed") && trowel.field_77990_d.func_74767_n("analyzed");
    }

    @Override
    public void analyze(ItemStack trowel) {
        if (this.hasSeed(trowel)) {
            if (trowel.func_77942_o()) {
                NBTTagCompound tag = trowel.func_77978_p();
                tag.func_74757_a("analyzed", true);
            } else {
                NBTTagCompound tag = new NBTTagCompound();
                SeedHelper.setNBT(tag, (short)1, (short)1, (short)1, true);
                trowel.func_77982_d(tag);
            }
        }
    }

    @Override
    public ItemStack getSeed(ItemStack trowel) {
        if (!this.hasSeed(trowel)) {
            return null;
        }
        NBTTagCompound tag = trowel.func_77978_p();
        CropPlant plant = CropPlantHandler.readPlantFromNBT(tag.func_74775_l("seed"));
        if (plant == null) {
            return null;
        }
        short growth = tag.func_74765_d("growth");
        short gain = tag.func_74765_d("gain");
        short strength = tag.func_74765_d("strength");
        boolean analysed = tag.func_74767_n("analyzed");
        NBTTagCompound seedTag = new NBTTagCompound();
        SeedHelper.setNBT(seedTag, growth, gain, strength, analysed);
        ItemStack seed = plant.getSeed();
        seed.field_77990_d = seedTag;
        return seed;
    }

    @Override
    public int getGrowthStage(ItemStack trowel) {
        if (!this.hasSeed(trowel)) {
            return -1;
        }
        return trowel.field_77990_d.func_74765_d("matMeta");
    }

    @Override
    public boolean setSeed(ItemStack trowel, ItemStack seed, int growthStage) {
        if (this.hasSeed(trowel)) {
            return false;
        }
        CropPlant plant = CropPlantHandler.getPlantFromStack(seed);
        if (plant == null) {
            return false;
        }
        NBTTagCompound seedTag = seed.func_77978_p();
        boolean initialised = seedTag != null;
        short growth = initialised && seedTag.func_74764_b("growth") ? seedTag.func_74765_d("growth") : (short)1;
        short gain = initialised && seedTag.func_74764_b("gain") ? seedTag.func_74765_d("gain") : (short)1;
        short strength = initialised && seedTag.func_74764_b("strength") ? seedTag.func_74765_d("strength") : (short)1;
        boolean analysed = initialised && seedTag.func_74764_b("analyzed") && seedTag.func_74767_n("analyzed");
        NBTTagCompound tag = new NBTTagCompound();
        SeedHelper.setNBT(tag, growth, gain, strength, analysed);
        tag.func_74782_a("seed", (NBTBase)CropPlantHandler.writePlantToNBT(plant));
        tag.func_74777_a("matMeta", (short)growthStage);
        trowel.func_77982_d(tag);
        trowel.func_77964_b(1);
        return true;
    }

    @Override
    public void clearSeed(ItemStack trowel) {
        trowel.func_77982_d(null);
        trowel.func_77964_b(0);
    }

    @Override
    public ISeedStats getStats(ItemStack trowel) {
        return PlantStats.getStatsFromStack(this.getSeed(trowel));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean flag) {
        if (stack.func_77960_j() == 0) {
            list.add(StatCollector.func_74838_a((String)"agricraft_tooltip.trowel"));
        } else if (this.hasSeed(stack)) {
            ItemStack seed = this.getSeed(stack);
            list.add(StatCollector.func_74838_a((String)"agricraft_tooltip.seed") + ": " + seed.func_77973_b().func_77653_i(seed));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        LogHelper.debug("registering icon for: " + this.func_77658_a());
        this.icons[0] = reg.func_94245_a(this.func_77658_a().substring(this.func_77658_a().indexOf(46) + 1) + "_empty");
        this.icons[1] = reg.func_94245_a(this.func_77658_a().substring(this.func_77658_a().indexOf(46) + 1) + "_full");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        if (meta <= 1) {
            return this.icons[meta];
        }
        return null;
    }
}

