/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.renderers;

import com.InfinityRaider.AgriCraft.utility.RenderHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;

@SideOnly(value=Side.CLIENT)
public abstract class PlantRenderer {
    public static void renderPlantLayer(int x, int y, int z, RenderBlocks renderer, int renderType, IIcon icon, int layer) {
        if (icon != null) {
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78372_c((float)x, (float)y, (float)z);
            tessellator.func_78380_c(Blocks.field_150464_aj.func_149677_c(renderer.field_147845_a, x, y, z));
            tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
            if (renderType != 6) {
                PlantRenderer.renderCrossPattern(tessellator, icon, layer);
            } else {
                PlantRenderer.renderHashTagPattern(tessellator, icon, layer);
            }
            tessellator.func_78372_c((float)(-x), (float)(-y), (float)(-z));
        }
    }

    private static void renderHashTagPattern(Tessellator tessellator, IIcon icon, int layer) {
        int minY = 16 * layer;
        int maxY = 16 * (layer + 1);
        RenderHelper.addScaledVertexWithUV(tessellator, 0.0f, minY, 4.0f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 0.0f, maxY, 4.0f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 16.0f, maxY, 4.0f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 16.0f, minY, 4.0f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 0.0f, minY, 4.0f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 16.0f, minY, 4.0f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 16.0f, maxY, 4.0f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 0.0f, maxY, 4.0f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 4.0f, minY, 0.0f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 4.0f, minY, 16.0f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 4.0f, maxY, 16.0f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 4.0f, maxY, 0.0f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 4.0f, minY, 0.0f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 4.0f, maxY, 0.0f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 4.0f, maxY, 16.0f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 4.0f, minY, 16.0f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 0.0f, minY, 12.0f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 16.0f, minY, 12.0f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 16.0f, maxY, 12.0f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 0.0f, maxY, 12.0f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 0.0f, minY, 12.0f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 0.0f, maxY, 12.0f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 16.0f, maxY, 12.0f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 16.0f, minY, 12.0f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.0f, minY, 16.0f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.0f, minY, 0.0f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.0f, maxY, 0.0f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.0f, maxY, 16.0f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.0f, minY, 16.0f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.0f, maxY, 16.0f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.0f, maxY, 0.0f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.0f, minY, 0.0f, 16.0f, 16.0f, icon);
    }

    private static void renderCrossPattern(Tessellator tessellator, IIcon icon, int layer) {
        int minY = 12 * layer;
        int maxY = 12 * (layer + 1);
        RenderHelper.addScaledVertexWithUV(tessellator, 6.0f, minY, 4.001f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 6.0f, maxY, 4.001f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 18.0f, maxY, 4.001f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 18.0f, minY, 4.001f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, -2.0f, minY, 3.999f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, -2.0f, maxY, 3.999f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 10.0f, maxY, 3.999f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 10.0f, minY, 3.999f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 6.0f, minY, 4.001f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 18.0f, minY, 4.001f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 18.0f, maxY, 4.001f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 6.0f, maxY, 4.001f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, -2.0f, minY, 3.999f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 10.0f, minY, 3.999f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 10.0f, maxY, 3.999f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, -2.0f, maxY, 3.999f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 3.999f, minY, 6.0f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 3.999f, minY, 18.0f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 3.999f, maxY, 18.0f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 3.999f, maxY, 6.0f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 4.001f, minY, -2.0f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 4.001f, minY, 10.0f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 4.001f, maxY, 10.0f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 4.001f, maxY, -2.0f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 3.999f, minY, 6.0f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 3.999f, maxY, 6.0f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 3.999f, maxY, 18.0f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 3.999f, minY, 18.0f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 4.001f, minY, -2.0f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 4.001f, maxY, -2.0f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 4.001f, maxY, 10.0f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 4.001f, minY, 10.0f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 6.0f, minY, 11.999f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 18.0f, minY, 11.999f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 18.0f, maxY, 11.999f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 6.0f, maxY, 11.999f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, -2.0f, minY, 12.001f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 10.0f, minY, 12.001f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 10.0f, maxY, 12.001f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, -2.0f, maxY, 12.001f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 6.0f, minY, 11.999f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 6.0f, maxY, 11.999f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 18.0f, maxY, 11.999f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 18.0f, minY, 11.999f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, -2.0f, minY, 12.001f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, -2.0f, maxY, 12.001f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 10.0f, maxY, 12.001f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 10.0f, minY, 12.001f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 11.999f, minY, 18.0f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 11.999f, minY, 6.0f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 11.999f, maxY, 6.0f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 11.999f, maxY, 18.0f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.001f, minY, 10.0f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.001f, minY, -2.0f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.001f, maxY, -2.0f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.001f, maxY, 10.0f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 11.999f, minY, 18.0f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 11.999f, maxY, 18.0f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 11.999f, maxY, 6.0f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 11.999f, minY, 6.0f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.001f, minY, 10.0f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.001f, maxY, 10.0f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.001f, maxY, -2.0f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.001f, minY, -2.0f, 16.0f, 16.0f, icon);
    }

    public static void renderStemPlant(int x, int y, int z, RenderBlocks renderer, IIcon icon, int meta, Block vine, Block block, boolean mature) {
        Tessellator tessellator = Tessellator.field_78398_a;
        int translation = meta >= 6 ? 0 : 5 - meta;
        tessellator.func_78380_c(vine.func_149677_c(renderer.field_147845_a, x, y, z));
        int l = vine.func_149741_i(meta);
        float f = (float)(l >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(l & 0xFF) / 255.0f;
        tessellator.func_78386_a(f, f1, f2);
        tessellator.func_78372_c((float)x, (float)y - 0.125f * (float)translation, (float)z);
        if (mature) {
            PlantRenderer.renderStemPattern(tessellator, icon);
        } else {
            PlantRenderer.renderCrossPattern(tessellator, icon, 0);
        }
        tessellator.func_78372_c((float)(-x), (float)(-y) + 0.125f * (float)translation, (float)(-z));
        if (mature) {
            float u = 0.0625f;
            boolean renderFacesSetting = renderer.field_147837_f;
            renderer.field_147837_f = true;
            renderer.func_147782_a((double)(7.0f * u), 0.0, (double)(2.0f * u), (double)(11.0f * u), (double)(4.0f * u), (double)(6.0f * u));
            renderer.func_147784_q(block, x, y, z);
            renderer.func_147782_a((double)(10.0f * u), 0.0, (double)(7.0f * u), (double)(14.0f * u), (double)(4.0f * u), (double)(11.0f * u));
            renderer.func_147784_q(block, x, y, z);
            renderer.func_147782_a((double)(5.0f * u), 0.0, (double)(10.0f * u), (double)(9.0f * u), (double)(4.0f * u), (double)(14.0f * u));
            renderer.func_147784_q(block, x, y, z);
            renderer.func_147782_a((double)(2.0f * u), 0.0, (double)(5.0f * u), (double)(6.0f * u), (double)(4.0f * u), (double)(9.0f * u));
            renderer.func_147784_q(block, x, y, z);
            renderer.field_147837_f = renderFacesSetting;
        }
    }

    private static void renderStemPattern(Tessellator tessellator, IIcon icon) {
        boolean minY = false;
        int maxY = 12;
        RenderHelper.addScaledVertexWithUV(tessellator, -2.0f, (float)minY, 3.999f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, -2.0f, maxY, 3.999f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 10.0f, maxY, 3.999f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 10.0f, (float)minY, 3.999f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, -2.0f, (float)minY, 3.999f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 10.0f, (float)minY, 3.999f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 10.0f, maxY, 3.999f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, -2.0f, maxY, 3.999f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 3.999f, (float)minY, 6.0f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 3.999f, (float)minY, 18.0f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 3.999f, maxY, 18.0f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 3.999f, maxY, 6.0f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 3.999f, (float)minY, 6.0f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 3.999f, maxY, 6.0f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 3.999f, maxY, 18.0f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 3.999f, (float)minY, 18.0f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 6.0f, (float)minY, 11.999f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 18.0f, (float)minY, 11.999f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 18.0f, maxY, 11.999f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 6.0f, maxY, 11.999f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 6.0f, (float)minY, 11.999f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 6.0f, maxY, 11.999f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 18.0f, maxY, 11.999f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 18.0f, (float)minY, 11.999f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.001f, (float)minY, 10.0f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.001f, (float)minY, -2.0f, 16.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.001f, maxY, -2.0f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.001f, maxY, 10.0f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.001f, (float)minY, 10.0f, 0.0f, 16.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.001f, maxY, 10.0f, 0.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.001f, maxY, -2.0f, 16.0f, 0.0f, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.001f, (float)minY, -2.0f, 16.0f, 16.0f, icon);
    }
}

