/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.renderers.blocks;

import com.InfinityRaider.AgriCraft.renderers.blocks.RenderBlockCustomWood;
import com.InfinityRaider.AgriCraft.tileentity.irrigation.TileEntityTank;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderTank
extends RenderBlockCustomWood<TileEntityTank> {
    public RenderTank() {
        super(com.InfinityRaider.AgriCraft.init.Blocks.blockWaterTank, new TileEntityTank(), true);
    }

    @Override
    protected void renderInInventory(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        Tessellator tessellator = Tessellator.field_78398_a;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GL11.glDisable((int)2896);
        tessellator.func_78382_b();
        this.renderTank((TileEntityTank)this.teDummy, tessellator, item.func_77960_j());
        tessellator.func_78381_a();
        GL11.glEnable((int)2896);
    }

    @Override
    protected boolean doWorldRender(Tessellator tessellator, IBlockAccess world, double x, double y, double z, TileEntity tile, Block block, float f, int modelId, RenderBlocks renderer, boolean callFromTESR) {
        boolean success = false;
        if (tile instanceof TileEntityTank) {
            TileEntityTank tank = (TileEntityTank)tile;
            if (callFromTESR) {
                if (tank.getFluidHeight() > 0.0f) {
                    GL11.glPushMatrix();
                    GL11.glDisable((int)2896);
                    tessellator.func_78382_b();
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                    this.drawWater(tank, tessellator);
                    tessellator.func_78381_a();
                    GL11.glEnable((int)2896);
                    GL11.glPopMatrix();
                    success = true;
                }
            } else {
                success = this.renderTank(tank, tessellator, tank.func_145832_p());
            }
        }
        renderer.func_147771_a();
        return success;
    }

    private boolean renderTank(TileEntityTank tank, Tessellator tessellator, int meta) {
        this.drawWoodTank(tank, tessellator);
        if (!this.shouldBehaveAsTESR() && tank.getFluidHeight() > 0.0f) {
            this.drawWater(tank, tessellator);
        }
        return true;
    }

    @Override
    public boolean shouldBehaveAsTESR() {
        return true;
    }

    @Override
    public boolean shouldBehaveAsISBRH() {
        return true;
    }

    private void drawWoodTank(TileEntityTank tank, Tessellator tessellator) {
        this.renderBottom(tank, tessellator);
        this.renderSide(tank, tessellator, ForgeDirection.NORTH);
        this.renderSide(tank, tessellator, ForgeDirection.EAST);
        this.renderSide(tank, tessellator, ForgeDirection.SOUTH);
        this.renderSide(tank, tessellator, ForgeDirection.WEST);
    }

    private void renderBottom(TileEntityTank tank, Tessellator tessellator) {
        boolean yMin;
        boolean bottom;
        IIcon icon = tank.getIcon();
        int cm = tank.colorMultiplier();
        boolean bl = bottom = !tank.getComponent().hasNeighbour(ForgeDirection.DOWN);
        if (bottom) {
            this.drawScaledPrism(tessellator, 0.0f, 0.0f, 0.0f, 16.0f, 1.0f, 16.0f, icon, cm);
        }
        boolean bl2 = yMin = bottom;
        if (!tank.getComponent().hasNeighbour(ForgeDirection.WEST) || !tank.getComponent().hasNeighbour(ForgeDirection.NORTH)) {
            this.drawScaledPrism(tessellator, 0.0f, (float)yMin, 0.0f, 2.0f, 16.0f, 2.0f, icon, cm);
        }
        if (!tank.getComponent().hasNeighbour(ForgeDirection.EAST) || !tank.getComponent().hasNeighbour(ForgeDirection.NORTH)) {
            this.drawScaledPrism(tessellator, 14.0f, (float)yMin, 0.0f, 16.0f, 16.0f, 2.0f, icon, cm);
        }
        if (!tank.getComponent().hasNeighbour(ForgeDirection.WEST) || !tank.getComponent().hasNeighbour(ForgeDirection.SOUTH)) {
            this.drawScaledPrism(tessellator, 0.0f, (float)yMin, 14.0f, 2.0f, 16.0f, 16.0f, icon, cm);
        }
        if (!tank.getComponent().hasNeighbour(ForgeDirection.EAST) || !tank.getComponent().hasNeighbour(ForgeDirection.SOUTH)) {
            this.drawScaledPrism(tessellator, 14.0f, (float)yMin, 14.0f, 16.0f, 16.0f, 16.0f, icon, cm);
        }
    }

    private void renderSide(TileEntityTank tank, Tessellator tessellator, ForgeDirection dir) {
        boolean yMin;
        IIcon icon = tank.getIcon();
        int cm = tank.colorMultiplier();
        boolean bl = yMin = !tank.getComponent().hasNeighbour(ForgeDirection.DOWN);
        if (dir != null && dir != ForgeDirection.UNKNOWN) {
            if (tank.isConnectedToChannel(dir)) {
                this.drawScaledPrism(tessellator, 2.0f, (float)yMin, 0.0f, 14.0f, 5.0f, 2.0f, icon, cm, dir);
                this.drawScaledPrism(tessellator, 2.0f, 5.0f, 0.0f, 5.0f, 12.0f, 2.0f, icon, cm, dir);
                this.drawScaledPrism(tessellator, 11.0f, 5.0f, 0.0f, 14.0f, 12.0f, 2.0f, icon, cm, dir);
                this.drawScaledPrism(tessellator, 2.0f, 12.0f, 0.0f, 14.0f, 16.0f, 2.0f, icon, cm, dir);
            } else if (!tank.getComponent().hasNeighbour(dir)) {
                this.drawScaledPrism(tessellator, 2.0f, (float)yMin, 0.0f, 14.0f, 16.0f, 2.0f, icon, cm, dir);
            }
        }
    }

    private void drawWater(TileEntityTank tank, Tessellator tessellator) {
        if (tank.getComponent().posY == 0) {
            float y = tank.getFluidHeight() - 0.01f;
            IIcon icon = Blocks.field_150355_j.func_149691_a(1, 0);
            int l = Blocks.field_150355_j.func_149720_d((IBlockAccess)tank.func_145831_w(), tank.field_145851_c, tank.field_145848_d, tank.field_145849_e);
            float f = (float)(l >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(l & 0xFF) / 255.0f;
            float f4 = 1.0f;
            tessellator.func_78380_c(Blocks.field_150355_j.func_149677_c((IBlockAccess)tank.func_145831_w(), tank.field_145851_c, tank.field_145848_d, tank.field_145849_e));
            tessellator.func_78369_a(f4 * f, f4 * f1, f4 * f2, 0.8f);
            this.addScaledVertexWithUV(tessellator, 0.0f, y, 0.0f, 0.0f, 0.0f, icon);
            this.addScaledVertexWithUV(tessellator, 0.0f, y, 16.0f, 0.0f, 16.0f, icon);
            this.addScaledVertexWithUV(tessellator, 16.0f, y, 16.0f, 16.0f, 16.0f, icon);
            this.addScaledVertexWithUV(tessellator, 16.0f, y, 0.0f, 16.0f, 0.0f, icon);
        }
    }
}

