/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.tileentity;

import com.InfinityRaider.AgriCraft.api.v1.IDebuggable;
import com.InfinityRaider.AgriCraft.api.v1.IFertiliser;
import com.InfinityRaider.AgriCraft.api.v1.ISeedStats;
import com.InfinityRaider.AgriCraft.api.v1.ITrowel;
import com.InfinityRaider.AgriCraft.apiimpl.v1.PlantStats;
import com.InfinityRaider.AgriCraft.apiimpl.v1.cropplant.CropPlant;
import com.InfinityRaider.AgriCraft.blocks.BlockCrop;
import com.InfinityRaider.AgriCraft.compatibility.applecore.AppleCoreHelper;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.farming.mutation.CrossOverResult;
import com.InfinityRaider.AgriCraft.farming.mutation.MutationEngine;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.init.Blocks;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityAgricraft;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import com.InfinityRaider.AgriCraft.utility.SeedHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCrop
extends TileEntityAgricraft
implements IDebuggable {
    private PlantStats stats = new PlantStats();
    private boolean analyzed = false;
    private boolean crossCrop = false;
    private boolean weed = false;
    private CropPlant plant;
    private final MutationEngine mutationEngine = new MutationEngine(this);

    @Override
    public boolean isRotatable() {
        return false;
    }

    public CropPlant getPlant() {
        return this.plant;
    }

    public ISeedStats getStats() {
        return this.hasPlant() ? this.stats.copy() : new PlantStats(-1, -1, -1);
    }

    public short getGrowth() {
        return this.weed ? (short)ConfigurationHandler.weedGrowthMultiplier : this.stats.getGrowth();
    }

    public short getGain() {
        return this.stats.getGain();
    }

    public short getStrength() {
        return this.stats.getStrength();
    }

    public boolean isAnalyzed() {
        return this.analyzed;
    }

    public boolean hasWeed() {
        return this.weed;
    }

    public boolean isCrossCrop() {
        return this.crossCrop;
    }

    public void setCrossCrop(boolean status) {
        if (status != this.crossCrop) {
            this.crossCrop = status;
            this.markForUpdate();
        }
    }

    public int getGrowthRate() {
        return this.weed ? ConfigurationHandler.weedGrowthRate : this.plant.getGrowthRate();
    }

    public boolean hasPlant() {
        return this.plant != null;
    }

    public void setPlant(int growth, int gain, int strength, boolean analyzed, CropPlant plant) {
        if (!this.crossCrop && !this.hasPlant() && plant != null) {
            this.plant = plant;
            this.stats = new PlantStats(growth, gain, strength);
            this.analyzed = analyzed;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
            this.markForUpdate();
            plant.onSeedPlanted(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void setPlant(int growth, int gain, int strength, boolean analyzed, Item seed, int seedMeta) {
        this.setPlant(growth, gain, strength, analyzed, CropPlantHandler.getPlantFromStack(new ItemStack(seed, 1, seedMeta)));
    }

    public void clearPlant() {
        CropPlant oldPlant = this.getPlant();
        this.stats = new PlantStats();
        this.plant = null;
        this.analyzed = false;
        this.weed = false;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
        this.markForUpdate();
        if (oldPlant != null) {
            oldPlant.onPlantRemoved(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public boolean isFertile() {
        return this.weed || this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) && this.plant.isFertile(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public float getCropHeight() {
        return this.hasPlant() ? this.plant.getHeight(this.func_145832_p()) : 0.8125f;
    }

    public boolean canBonemeal() {
        if (this.crossCrop) {
            return ConfigurationHandler.bonemealMutation;
        }
        if (this.hasPlant() && !this.isMature()) {
            if (!this.isFertile()) {
                return false;
            }
            return this.plant.canBonemeal();
        }
        return this.hasWeed() && !this.isMature();
    }

    public boolean isMature() {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 7;
    }

    public ArrayList<ItemStack> getFruits() {
        return this.plant.getFruitsOnHarvest(this.getGain(), this.field_145850_b.field_73012_v);
    }

    public boolean allowHarvest(EntityPlayer player) {
        return this.hasPlant() && this.isMature() && this.plant.onHarvest(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, player);
    }

    public ItemStack getSeedStack() {
        if (this.plant == null) {
            return null;
        }
        ItemStack seed = this.plant.getSeed().func_77946_l();
        NBTTagCompound tag = new NBTTagCompound();
        SeedHelper.setNBT(tag, this.getGrowth(), this.getGain(), this.getStrength(), this.analyzed);
        seed.func_77982_d(tag);
        return seed;
    }

    public Block getPlantBlock() {
        return this.plant == null ? null : this.plant.getBlock();
    }

    public void spawnWeed() {
        this.crossCrop = false;
        this.clearPlant();
        this.weed = true;
        this.markForUpdate();
    }

    public void spreadWeed() {
        List<TileEntityCrop> neighbours = this.getNeighbours();
        for (TileEntityCrop crop : neighbours) {
            if (crop == null || crop.weed || !(Math.random() < crop.getWeedSpawnChance())) continue;
            crop.spawnWeed();
            break;
        }
    }

    public void updateWeed(int growthStage) {
        if (this.hasWeed()) {
            if (growthStage == 0) {
                this.weed = false;
            }
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, growthStage, 3);
            this.markForUpdate();
        }
    }

    public void clearWeed() {
        this.updateWeed(0);
    }

    private double getWeedSpawnChance() {
        if (this.hasPlant()) {
            return ConfigurationHandler.weedsWipePlants ? (double)(10 - this.getStrength()) / 10.0 : 0.0;
        }
        return this.weed ? 0.0 : 1.0;
    }

    public void onTrowelUsed(ITrowel trowel, ItemStack trowelStack) {
        if (this.hasPlant()) {
            if (!trowel.hasSeed(trowelStack)) {
                trowel.setSeed(trowelStack, this.getSeedStack(), this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                this.clearPlant();
                this.markForUpdate();
            }
        } else if (!this.hasWeed() && !this.crossCrop && trowel.hasSeed(trowelStack)) {
            ItemStack seed = trowel.getSeed(trowelStack);
            int growthStage = trowel.getGrowthStage(trowelStack);
            NBTTagCompound tag = seed.func_77978_p();
            short growth = tag.func_74765_d("growth");
            short gain = tag.func_74765_d("gain");
            short strength = tag.func_74765_d("strength");
            boolean analysed = tag.func_74767_n("analyzed");
            this.setPlant(growth, gain, strength, analysed, seed.func_77973_b(), seed.func_77960_j());
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, growthStage, 3);
            this.markForUpdate();
            trowel.clearSeed(trowelStack);
        }
    }

    public boolean allowFertiliser(IFertiliser fertiliser) {
        if (this.crossCrop) {
            return ConfigurationHandler.bonemealMutation && fertiliser.canTriggerMutation();
        }
        if (this.hasWeed()) {
            return true;
        }
        if (this.hasPlant()) {
            return fertiliser.isFertiliserAllowed(this.plant.getTier());
        }
        return false;
    }

    public void applyFertiliser(IFertiliser fertiliser, Random rand) {
        if (fertiliser.hasSpecialBehaviour()) {
            fertiliser.onFertiliserApplied(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, rand);
        }
        if (this.hasPlant() || this.hasWeed()) {
            ((BlockCrop)Blocks.blockCrop).func_149853_b(this.field_145850_b, rand, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.markForUpdate();
        } else if (this.isCrossCrop() && ConfigurationHandler.bonemealMutation) {
            this.crossOver();
        }
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.stats.writeToNBT(tag);
        tag.func_74757_a("analyzed", this.analyzed);
        tag.func_74757_a("crossCrop", this.crossCrop);
        tag.func_74757_a("weed", this.weed);
        if (this.plant != null) {
            tag.func_74782_a("seed", (NBTBase)CropPlantHandler.writePlantToNBT(this.plant));
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.stats = PlantStats.readFromNBT(tag);
        this.analyzed = tag.func_74764_b("analyzed") && tag.func_74767_n("analyzed");
        this.crossCrop = tag.func_74767_n("crossCrop");
        this.weed = tag.func_74767_n("weed");
        if (tag.func_74764_b("seed") && !tag.func_74764_b("meta")) {
            this.plant = CropPlantHandler.readPlantFromNBT(tag.func_74775_l("seed"));
        } else if (tag.func_74764_b("seed") && tag.func_74764_b("meta")) {
            this.loadPlantFromOldVersion(tag);
        } else {
            this.plant = null;
        }
    }

    @Deprecated
    private void loadPlantFromOldVersion(NBTTagCompound tag) {
        int meta;
        String name = tag.func_74779_i("seed");
        Item seed = name.equalsIgnoreCase("none") ? null : (Item)Item.field_150901_e.func_82594_a(name);
        ItemStack stack = new ItemStack(seed, 1, meta = tag.func_74762_e("meta"));
        CropPlant plant = CropPlantHandler.getPlantFromStack(stack);
        if (plant != null) {
            this.plant = plant;
        } else {
            LogHelper.info("Couldn't find plant for " + stack.func_77977_a() + " at (" + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e + "), plant has been removed");
            this.clearPlant();
        }
    }

    public void applyGrowthTick() {
        int flag = 2;
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.hasPlant()) {
            int n = flag = this.plant.onAllowedGrowthTick(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, meta) ? 2 : 6;
        }
        if (this.hasWeed() || !this.plant.isMature((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta + 1, flag);
            AppleCoreHelper.announceGrowthTick(this.func_145838_q(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void crossOver() {
        this.mutationEngine.executeCrossOver();
    }

    public void applyCrossOverResult(CrossOverResult result) {
        this.crossCrop = false;
        this.setPlant(result.getGrowth(), result.getGain(), result.getStrength(), false, result.getSeed(), result.getMeta());
        this.markForUpdate();
    }

    public List<TileEntityCrop> getNeighbours() {
        ArrayList<TileEntityCrop> neighbours = new ArrayList<TileEntityCrop>();
        this.addNeighbour(neighbours, ForgeDirection.NORTH);
        this.addNeighbour(neighbours, ForgeDirection.SOUTH);
        this.addNeighbour(neighbours, ForgeDirection.EAST);
        this.addNeighbour(neighbours, ForgeDirection.WEST);
        return neighbours;
    }

    private void addNeighbour(List<TileEntityCrop> neighbours, ForgeDirection direction) {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
        if (te == null || !(te instanceof TileEntityCrop)) {
            return;
        }
        neighbours.add((TileEntityCrop)te);
    }

    public List<TileEntityCrop> getMatureNeighbours() {
        List<TileEntityCrop> neighbours = this.getNeighbours();
        Iterator<TileEntityCrop> iterator = neighbours.iterator();
        while (iterator.hasNext()) {
            TileEntityCrop crop = iterator.next();
            if (crop.isMature()) continue;
            iterator.remove();
        }
        return neighbours;
    }

    public boolean func_145842_c(int id, int value) {
        if (this.field_145850_b.field_72995_K && id == 1) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147451_t(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            Minecraft.func_71410_x().field_71438_f.func_147586_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getPlantIcon() {
        IIcon icon = null;
        if (this.hasPlant()) {
            icon = this.plant.getPlantIcon(this.func_145832_p());
        } else if (this.weed) {
            icon = ((BlockCrop)this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e)).getWeedIcon(this.func_145832_p());
        }
        return icon;
    }

    @Override
    public void addDebugInfo(List<String> list) {
        list.add("CROP:");
        if (this.crossCrop) {
            list.add(" - This is a crosscrop");
        } else if (this.hasPlant()) {
            list.add(" - This crop has a plant");
            list.add(" - Seed: " + this.plant.getSeed().func_77973_b().func_77658_a());
            list.add(" - Seed class: " + this.plant.getSeed().func_77973_b().getClass().getName());
            list.add(" - RegisterName: " + Item.field_150901_e.func_148750_c((Object)this.plant.getSeed().func_77973_b()) + ":" + this.plant.getSeed().func_77960_j());
            list.add(" - Tier: " + this.plant.getTier());
            list.add(" - Meta: " + this.func_145832_p());
            list.add(" - Growth: " + this.getGrowth());
            list.add(" - Gain: " + this.getGain());
            list.add(" - Strength: " + this.getStrength());
            list.add(" - Fertile: " + this.isFertile());
            list.add(" - Mature: " + this.isMature());
        } else if (this.weed) {
            list.add(" - This crop has weeds");
            list.add(" - Meta: " + this.func_145832_p());
        } else {
            list.add(" - This crop has no plant");
        }
    }

    @Override
    public void addWailaInformation(List information) {
        if (this.hasPlant()) {
            information.add(StatCollector.func_74838_a((String)"agricraft_tooltip.seed") + ": " + this.getSeedStack().func_82833_r());
            if (this.isMature()) {
                information.add(StatCollector.func_74838_a((String)"agricraft_tooltip.growthStage") + ": " + StatCollector.func_74838_a((String)"agricraft_tooltip.mature"));
            } else {
                information.add(StatCollector.func_74838_a((String)"agricraft_tooltip.growthStage") + ": " + (int)(100.0f * ((float)this.func_145832_p() + 0.0f) / 7.0f) + "%");
            }
            if (this.isAnalyzed()) {
                information.add(" - " + StatCollector.func_74838_a((String)"agricraft_tooltip.growth") + ": " + this.getGrowth());
                information.add(" - " + StatCollector.func_74838_a((String)"agricraft_tooltip.gain") + ": " + this.getGain());
                information.add(" - " + StatCollector.func_74838_a((String)"agricraft_tooltip.strength") + ": " + this.getStrength());
            } else {
                information.add(StatCollector.func_74838_a((String)"agricraft_tooltip.analyzed"));
            }
            information.add(StatCollector.func_74838_a((String)(this.isFertile() ? "agricraft_tooltip.fertile" : "agricraft_tooltip.notFertile")));
        } else if (this.hasWeed()) {
            information.add(StatCollector.func_74838_a((String)"agricraft_tooltip.weeds"));
        } else {
            information.add(StatCollector.func_74838_a((String)"agricraft_tooltip.empty"));
        }
    }
}

