/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.tileentity;

import com.InfinityRaider.AgriCraft.api.v1.IDebuggable;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityAgricraft;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;

public class TileEntityCustomWood
extends TileEntityAgricraft
implements IDebuggable {
    private static final Block DEFAULT_MATERIAL = Blocks.field_150344_f;
    private static final int DEFAULT_META = 0;
    private Block material = Blocks.field_150344_f;
    private int materialMeta = 0;

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        tag.func_74778_a("material", Block.field_149771_c.func_148750_c((Object)this.getMaterial()));
        tag.func_74768_a("matMeta", this.getMaterialMeta());
        super.func_145841_b(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.setMaterial(tag);
    }

    public final boolean isSameMaterial(TileEntityCustomWood tileEntity) {
        return tileEntity != null && this.func_145832_p() == tileEntity.func_145832_p() && this.getMaterial() == tileEntity.getMaterial() && this.getMaterialMeta() == tileEntity.getMaterialMeta();
    }

    private void setMaterial(NBTTagCompound tag) {
        if (tag != null && tag.func_74764_b("material") && tag.func_74764_b("matMeta")) {
            this.setMaterial(tag.func_74779_i("material"), tag.func_74762_e("matMeta"));
        }
    }

    public final void setMaterial(ItemStack stack) {
        if (stack != null && stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemBlock) {
            this.setMaterial(stack.field_77990_d);
        }
    }

    public final void setMaterial(String name, int meta) {
        Block block = (Block)Block.field_149771_c.func_82594_a(name);
        this.setMaterial(block == Blocks.field_150350_a ? DEFAULT_MATERIAL : block, block == Blocks.field_150350_a ? 0 : meta);
    }

    public final void setMaterial(Block block, int meta) {
        if (block != null) {
            this.material = block;
            this.materialMeta = meta;
        }
    }

    public final Block getMaterial() {
        return this.material == null ? DEFAULT_MATERIAL : this.material;
    }

    public final int getMaterialMeta() {
        return this.material == null ? 0 : this.materialMeta;
    }

    public final ItemStack getMaterialStack() {
        return new ItemStack(this.getMaterial(), 1, this.getMaterialMeta());
    }

    public final String getMaterialName() {
        return Block.field_149771_c.func_148750_c((Object)this.getMaterial());
    }

    public final NBTTagCompound getMaterialTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("material", this.getMaterialName());
        tag.func_74768_a("matMeta", this.materialMeta);
        return tag;
    }

    public IIcon getIcon() {
        return this.getMaterial().func_149691_a(0, this.getMaterialMeta());
    }

    @Override
    public void addDebugInfo(List<String> list) {
        list.add("this material is: " + this.getMaterialName() + ":" + this.getMaterialMeta());
    }

    @Override
    public boolean isRotatable() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier() {
        if (this.field_145850_b == null) {
            return 0xFFFFFF;
        }
        return this.func_145838_q().func_149720_d((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void addWailaInformation(List information) {
        ItemStack mat = this.getMaterialStack();
        information.add(StatCollector.func_74838_a((String)"agricraft_tooltip.material") + ": " + mat.func_77973_b().func_77653_i(mat));
    }
}

