/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.tileentity;

import com.InfinityRaider.AgriCraft.api.v1.IDebuggable;
import com.InfinityRaider.AgriCraft.tileentity.MultiBlockComponent;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCustomWood;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityMultiBlock
extends TileEntityCustomWood
implements IDebuggable {
    private MultiBlockComponent component = new MultiBlockComponent(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 0, 0, 1, 1, 1);
    private boolean reform = false;

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.component.writeToNBT(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("nrTanks") || tag.func_74764_b("xPosition")) {
            this.reform = true;
        } else {
            this.component = MultiBlockComponent.readFromNBT(tag);
        }
        if (this.component == null) {
            this.resetComponent();
        }
    }

    public void func_145845_h() {
        if (this.component == null) {
            LogHelper.error("The multiblock component at (" + this.field_145851_c + this.field_145848_d + this.field_145849_e + ") is impossibly null.");
        }
        if (!this.field_145850_b.field_72995_K && this.reform) {
            LogHelper.debug("Reforming multiblock on request.");
            this.formMultiBlock();
            this.reform = false;
        }
    }

    public final MultiBlockComponent getComponent() {
        return this.component;
    }

    public final boolean formMultiBlock() {
        int z;
        int y;
        int x;
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        int xPosNew = this.findEnd(ForgeDirection.WEST);
        int yPosNew = this.findEnd(ForgeDirection.DOWN);
        int zPosNew = this.findEnd(ForgeDirection.NORTH);
        int xSizeNew = xPosNew + this.findEnd(ForgeDirection.EAST) + 1;
        int ySizeNew = yPosNew + this.findEnd(ForgeDirection.UP) + 1;
        int zSizeNew = zPosNew + this.findEnd(ForgeDirection.SOUTH) + 1;
        int anchorXNew = this.field_145851_c - xPosNew;
        int anchorYNew = this.field_145848_d - yPosNew;
        int anchorZNew = this.field_145849_e - zPosNew;
        if (xSizeNew == 1 && ySizeNew == 1 && zSizeNew == 1) {
            return false;
        }
        for (x = 0; x < xSizeNew; ++x) {
            for (y = 0; y < ySizeNew; ++y) {
                for (z = 0; z < zSizeNew; ++z) {
                    if (this.canJoinMultiBlock(this.field_145850_b.func_147438_o(anchorXNew + x, anchorYNew + y, anchorZNew + z))) continue;
                    return false;
                }
            }
        }
        for (x = 0; x < xSizeNew; ++x) {
            for (y = 0; y < ySizeNew; ++y) {
                for (z = 0; z < zSizeNew; ++z) {
                    TileEntity te = this.field_145850_b.func_147438_o(anchorXNew + x, anchorYNew + y, anchorZNew + z);
                    if (te instanceof TileEntityMultiBlock) {
                        TileEntityMultiBlock block = (TileEntityMultiBlock)te;
                        block.breakupMultiBlock();
                        block.component = new MultiBlockComponent(anchorXNew, anchorYNew, anchorZNew, x, y, z, xSizeNew, ySizeNew, zSizeNew);
                        block.addBlock();
                        block.markForUpdate();
                        continue;
                    }
                    LogHelper.debug("This is odd... a tile entity in the structure isn't the right type...");
                }
            }
        }
        return true;
    }

    public final void breakupMultiBlock() {
        this.breakupMultiBlock(false);
    }

    public final void breakupMultiBlock(boolean shouldReform) {
        if (this.field_145850_b.field_72995_K || !this.component.isPartOfMultiBlock) {
            return;
        }
        int anchorX = this.component.anchorX;
        int anchorY = this.component.anchorY;
        int anchorZ = this.component.anchorZ;
        int sizeX = this.component.sizeX;
        int sizeY = this.component.sizeY;
        int sizeZ = this.component.sizeZ;
        if (!(this.field_145850_b.func_147438_o(anchorX, anchorY, anchorZ) instanceof TileEntityMultiBlock)) {
            LogHelper.error("This is bad! The multiblock controller at (" + anchorX + "," + anchorY + "," + anchorZ + ") is missing! Aborting!");
            return;
        }
        TileEntityMultiBlock controller = (TileEntityMultiBlock)this.field_145850_b.func_147438_o(anchorX, anchorY, anchorZ);
        for (int x = sizeX - 1; x > -1; --x) {
            for (int y = sizeY - 1; y > -1; --y) {
                for (int z = sizeZ - 1; z > -1; --z) {
                    if (this.field_145850_b.func_147438_o(anchorX + x, anchorY + y, anchorZ + z) instanceof TileEntityMultiBlock) {
                        TileEntityMultiBlock block = (TileEntityMultiBlock)this.field_145850_b.func_147438_o(anchorX + x, anchorY + y, anchorZ + z);
                        block.breakMultiPart(controller);
                        block.resetComponent();
                        block.reform = shouldReform;
                        block.markForUpdate();
                        continue;
                    }
                    LogHelper.debug("Ooops! Went out of the multiblock when breaking it.");
                }
            }
        }
    }

    private final void resetComponent() {
        this.component = new MultiBlockComponent(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 0, 0, 1, 1, 1);
    }

    private int findEnd(ForgeDirection dir) {
        if (this.canJoinMultiBlock(this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ))) {
            return ((TileEntityMultiBlock)this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ)).findEnd(dir) + 1;
        }
        return 0;
    }

    @Override
    public void addDebugInfo(List<String> list) {
        this.formMultiBlock();
        list.add("MULTIBLOCK:");
        list.add("Multiblock:");
        super.addDebugInfo(list);
        list.add("  - MultiBlock: " + this.component.isPartOfMultiBlock);
        if (this.component.isPartOfMultiBlock) {
            list.add("  - Connected: " + this.component.size);
            list.add("  - MultiBlock Size: " + this.component.sizeX + "x" + this.component.sizeY + "x" + this.component.sizeZ);
            list.add("  - Is controller? " + this.component.isController);
            list.add("  - Clicked on layer: " + this.component.posY);
            list.add("  - Component Information: ");
            list.add("     - Position: (" + this.component.posX + "," + this.component.posY + "," + this.component.posZ + ").");
            list.add("     - Anchor: (" + this.component.anchorX + "," + this.component.anchorY + "," + this.component.anchorZ + ").");
        }
    }

    public abstract boolean canJoinMultiBlock(TileEntity var1);

    public abstract void addBlock();

    public abstract void breakMultiPart(TileEntityMultiBlock var1);
}

