/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.tileentity;

import com.InfinityRaider.AgriCraft.api.v1.ITrowel;
import com.InfinityRaider.AgriCraft.apiimpl.v1.cropplant.CropPlant;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.items.ItemJournal;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityAgricraft;
import com.InfinityRaider.AgriCraft.utility.SeedHelper;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntitySeedAnalyzer
extends TileEntityAgricraft
implements ISidedInventory {
    private ItemStack specimen = null;
    private ItemStack journal = null;
    private int progress = 0;

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.specimen != null && this.specimen.func_77973_b() != null) {
            NBTTagCompound seedTag = new NBTTagCompound();
            this.specimen.func_77955_b(seedTag);
            tag.func_74782_a("seed", (NBTBase)seedTag);
        }
        if (this.journal != null && this.journal.func_77973_b() != null) {
            NBTTagCompound journalTag = new NBTTagCompound();
            this.journal.func_77955_b(journalTag);
            tag.func_74782_a("journal", (NBTBase)journalTag);
        }
        tag.func_74768_a("progress", this.progress);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.specimen = tag.func_74764_b("seed") ? ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("seed")) : null;
        this.journal = tag.func_74764_b("journal") ? ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("journal")) : null;
        this.progress = tag.func_74762_e("progress");
    }

    public final boolean hasSpecimen() {
        return this.hasSeed() || this.hasTrowel();
    }

    public final ItemStack getSpecimen() {
        return this.specimen;
    }

    public final boolean hasSeed() {
        return CropPlantHandler.isValidSeed(this.specimen);
    }

    public final boolean hasTrowel() {
        if (this.specimen == null || this.specimen.func_77973_b() == null) {
            return false;
        }
        if (this.specimen.func_77973_b() instanceof ITrowel) {
            return ((ITrowel)this.specimen.func_77973_b()).hasSeed(this.specimen);
        }
        return false;
    }

    public final void setProgress(int value) {
        this.progress = value;
    }

    public final int getProgress() {
        return this.progress;
    }

    public final int maxProgress() {
        ItemStack seed = this.hasTrowel() ? ((ITrowel)this.specimen.func_77973_b()).getSeed(this.specimen) : this.specimen;
        if (seed != null) {
            CropPlant plant = CropPlantHandler.getPlantFromStack(seed);
            return plant == null ? 0 : plant.getTier() * 20;
        }
        return 0;
    }

    public static boolean isValid(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof ITrowel) {
            return ((ITrowel)stack.func_77973_b()).hasSeed(stack);
        }
        return CropPlantHandler.isValidSeed(stack);
    }

    public final boolean isSpecimenAnalyzed() {
        if (this.hasTrowel()) {
            return ((ITrowel)this.specimen.func_77973_b()).isSeedAnalysed(this.specimen);
        }
        if (this.hasSeed()) {
            return this.specimen.func_77942_o() && this.specimen.field_77990_d.func_74767_n("analyzed");
        }
        return false;
    }

    public void func_145845_h() {
        boolean change = false;
        if (this.isAnalyzing()) {
            int n = this.progress = this.progress < this.maxProgress() ? this.progress + 1 : this.maxProgress();
            if (this.progress == this.maxProgress() && !this.field_145850_b.field_72995_K) {
                this.analyze();
                change = true;
            }
        }
        if (change) {
            this.markForUpdate();
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 0, 0);
            this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
    }

    public void analyze() {
        if (this.hasSeed()) {
            if (this.specimen.func_77942_o()) {
                NBTTagCompound tag = this.specimen.func_77978_p();
                if (tag.func_74764_b("growth") && tag.func_74764_b("gain") && tag.func_74764_b("strength")) {
                    tag.func_74757_a("analyzed", true);
                } else {
                    SeedHelper.setNBT(tag, (short)0, (short)0, (short)0, true);
                }
            } else {
                this.specimen.func_77982_d(new NBTTagCompound());
                SeedHelper.setNBT(this.specimen.field_77990_d, (short)0, (short)0, (short)0, true);
            }
        } else if (this.hasTrowel()) {
            ((ITrowel)this.specimen.func_77973_b()).analyze(this.specimen);
        }
        if (this.hasJournal()) {
            ((ItemJournal)this.journal.func_77973_b()).addEntry(this.journal, this.hasSeed() ? this.specimen : ((ITrowel)this.specimen.func_77973_b()).getSeed(this.specimen));
        }
    }

    public final boolean isAnalyzing() {
        return this.specimen != null && !this.isSpecimenAnalyzed() && this.progress < this.maxProgress();
    }

    public final boolean hasJournal() {
        return this.journal != null && this.journal.func_77973_b() != null;
    }

    public final ItemStack getJournal() {
        return this.journal;
    }

    public final int getProgressScaled(int scale) {
        return Math.round((float)this.progress * (float)scale / (float)this.maxProgress());
    }

    public boolean func_145842_c(int id, int value) {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public int[] func_94128_d(int side) {
        return new int[]{36, 37};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (slot == 36) {
            return TileEntitySeedAnalyzer.isValid(stack);
        }
        if (slot == 37) {
            return this.journal == null && this.func_94041_b(slot, stack);
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (slot == 36 && this.specimen != null && this.specimen.func_77942_o()) {
            return this.isSpecimenAnalyzed();
        }
        return false;
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int slot) {
        switch (slot) {
            case 36: {
                return this.specimen;
            }
            case 37: {
                return this.journal;
            }
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack output = null;
        if (slot == 36 && this.specimen != null) {
            if (amount < this.specimen.field_77994_a) {
                output = this.specimen.func_77979_a(amount);
            } else {
                output = this.specimen.func_77946_l();
                this.specimen = null;
            }
        } else if (slot == 37 && this.journal != null) {
            output = this.journal.func_77946_l();
            this.journal = null;
        }
        this.progress = 0;
        return output;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stackInSlot;
        switch (slot) {
            case 36: {
                stackInSlot = this.specimen;
                break;
            }
            case 37: {
                stackInSlot = this.journal;
                break;
            }
            default: {
                return null;
            }
        }
        if (stackInSlot != null) {
            this.func_70299_a(slot, null);
        }
        return stackInSlot;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot == 36) {
            this.specimen = stack;
            if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
                stack.field_77994_a = this.func_70297_j_();
            }
            this.progress = 0;
        } else if (slot == 37) {
            this.journal = stack;
        }
    }

    public String func_145825_b() {
        return "container.agricraft:seedAnalyzer";
    }

    public final boolean func_145818_k_() {
        return true;
    }

    public final int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 36: {
                return TileEntitySeedAnalyzer.isValid(stack);
            }
            case 37: {
                return stack != null && stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemJournal;
            }
        }
        return false;
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    public void addWailaInformation(List information) {
    }
}

