/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.utility;

import com.InfinityRaider.AgriCraft.apiimpl.v1.cropplant.CropPlant;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.utility.IOHelper;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class SeedHelper {
    private static List<ItemStack> seedBlackList = new ArrayList<ItemStack>();
    private static HashMap<Item, Integer[]> spreadChances;
    private static HashMap<Item, Integer[]> seedTiers;
    private static List<ItemStack> vanillaPlantingOverrides;

    public static void init() {
        SeedHelper.initSeedBlackList();
        SeedHelper.initSpreadChancesOverrides();
        SeedHelper.initTiers();
        SeedHelper.initVannilaPlantingOverrides();
    }

    private static void initSeedBlackList() {
        String[] data = IOHelper.getLinesArrayFromData(ConfigurationHandler.readSeedBlackList());
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (String line : data) {
            LogHelper.debug(new StringBuffer("parsing ").append(line));
            ItemStack seedStack = IOHelper.getStack(line);
            Item seed = seedStack != null ? seedStack.func_77973_b() : null;
            boolean success = seed != null;
            String errorMsg = "Invalid seed";
            if (success) {
                list.add(seedStack);
                continue;
            }
            LogHelper.info(new StringBuffer("Error when adding seed to blacklist: ").append(errorMsg).append(" (line: ").append(line).append(")"));
        }
        seedBlackList = list;
        LogHelper.info("Registered seeds blacklist:");
        for (ItemStack seed : seedBlackList) {
            LogHelper.info(new StringBuffer(" - ").append(Item.field_150901_e.func_148750_c((Object)seed.func_77973_b())).append(":").append(seed.func_77960_j()));
        }
    }

    private static void initSpreadChancesOverrides() {
        SeedHelper.setMutationChances(IOHelper.getLinesArrayFromData(ConfigurationHandler.readSpreadChances()));
        LogHelper.info("Registered Mutations Chances overrides:");
        for (Map.Entry<Item, Integer[]> entry : spreadChances.entrySet()) {
            for (int i = 0; i < entry.getValue().length; ++i) {
                Integer chance = entry.getValue()[i];
                if (chance == null) continue;
                StringBuffer override = new StringBuffer(" - ").append(Item.field_150901_e.func_148750_c((Object)entry.getKey())).append(':').append(i).append(" - ").append(chance).append(" percent");
                LogHelper.info(override);
            }
        }
    }

    private static void initTiers() {
        SeedHelper.setSeedTiers(IOHelper.getLinesArrayFromData(ConfigurationHandler.readSeedTiers()));
        LogHelper.info("Registered seed tiers:");
        for (Map.Entry<Item, Integer[]> entry : seedTiers.entrySet()) {
            for (int i = 0; i < entry.getValue().length; ++i) {
                Integer tier = entry.getValue()[i];
                if (tier == null) continue;
                StringBuffer override = new StringBuffer(" - ").append(Item.field_150901_e.func_148750_c((Object)entry.getKey())).append(':').append(i).append(" - tier:").append(tier);
                LogHelper.info(override);
            }
        }
    }

    private static void initVannilaPlantingOverrides() {
        String[] data = IOHelper.getLinesArrayFromData(ConfigurationHandler.readVanillaOverrides());
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (String line : data) {
            LogHelper.debug(new StringBuffer("parsing ").append(line));
            ItemStack seedStack = IOHelper.getStack(line);
            Item seed = seedStack != null ? seedStack.func_77973_b() : null;
            boolean success = seed != null;
            String errorMsg = "Invalid seed";
            if (success) {
                list.add(seedStack);
                continue;
            }
            LogHelper.info(new StringBuffer("Error when adding seed to vanilla overrides: ").append(errorMsg).append(" (line: ").append(line).append(")"));
        }
        vanillaPlantingOverrides = list;
        LogHelper.info("Registered seeds ignoring vanilla planting rule:");
        for (ItemStack seed : seedBlackList) {
            LogHelper.info(new StringBuffer(" - ").append(Item.field_150901_e.func_148750_c((Object)seed.func_77973_b())).append(":").append(seed.func_77960_j()));
        }
    }

    private static void setMutationChances(String[] input) {
        spreadChances = new HashMap();
        LogHelper.debug("reading mutation chance overrides");
        for (String line : input) {
            String[] data = IOHelper.getData(line);
            boolean success = data.length == 2;
            String errorMsg = "Incorrect amount of arguments";
            LogHelper.debug("parsing " + line);
            if (success) {
                ItemStack seedStack = IOHelper.getStack(data[0]);
                Item seedItem = seedStack != null ? seedStack.func_77973_b() : null;
                success = seedItem != null;
                errorMsg = "Invalid seed";
                if (success) {
                    int chance = Integer.parseInt(data[1]);
                    success = chance >= 0 && chance <= 100;
                    errorMsg = "Chance should be between 0 and 100";
                    if (success) {
                        Item seed = seedStack.func_77973_b();
                        if (spreadChances.get(seed) == null) {
                            spreadChances.put(seed, new Integer[16]);
                        }
                        SeedHelper.spreadChances.get((Object)seed)[seedStack.func_77960_j()] = chance;
                    }
                }
            }
            if (success) continue;
            LogHelper.info(new StringBuffer("Error when adding mutation chance override: ").append(errorMsg).append(" (line: ").append(line).append(")"));
        }
    }

    private static void setSeedTiers(String[] input) {
        seedTiers = new HashMap();
        LogHelper.debug("reading seed tier overrides");
        for (String line : input) {
            String[] data = IOHelper.getData(line);
            boolean success = data.length == 2;
            String errorMsg = "Incorrect amount of arguments";
            LogHelper.debug("parsing " + line);
            if (success) {
                ItemStack seedStack = IOHelper.getStack(data[0]);
                Item seedItem = seedStack != null ? seedStack.func_77973_b() : null;
                success = seedItem != null;
                errorMsg = "Invalid seed";
                if (success) {
                    int tier = Integer.parseInt(data[1]);
                    success = tier >= 1 && tier <= 5;
                    errorMsg = "Chance should be between 1 and 5";
                    if (success) {
                        Item seed = seedStack.func_77973_b();
                        if (seedTiers.get(seed) == null) {
                            seedTiers.put(seed, new Integer[16]);
                        }
                        SeedHelper.seedTiers.get((Object)seed)[seedStack.func_77960_j()] = tier;
                    }
                }
            }
            if (success) continue;
            LogHelper.info(new StringBuffer("Error when adding seed tier override: ").append(errorMsg).append(" (line: ").append(line).append(")"));
        }
    }

    public static double getSpreadChance(Item seed, int meta) {
        Integer[] value = spreadChances.get(seed);
        if (value != null && value.length > meta && value[meta] != null) {
            return (double)value[meta].intValue() / 100.0;
        }
        CropPlant plant = CropPlantHandler.getPlantFromStack(new ItemStack(seed, 1, meta));
        if (plant == null) {
            return 0.0;
        }
        return 1.0 / (double)plant.getTier();
    }

    public static int getSeedTierOverride(ItemStack stack) {
        Integer tier;
        Item seed = stack.func_77973_b();
        int meta = stack.func_77960_j();
        Integer[] tierArray = seedTiers.get(seed);
        if (tierArray != null && tierArray.length > meta && (tier = seedTiers.get(seed)[meta]) != null) {
            return tier;
        }
        return -1;
    }

    public static boolean isAnalyzedSeed(ItemStack seedStack) {
        return CropPlantHandler.isValidSeed(seedStack) && seedStack.func_77942_o() && seedStack.field_77990_d.func_74764_b("analyzed") && seedStack.field_77990_d.func_74767_n("analyzed");
    }

    public static boolean isSeedBlackListed(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return true;
        }
        Item seed = stack.func_77973_b();
        int meta = stack.func_77960_j();
        for (ItemStack blacklistedSeed : seedBlackList) {
            if (blacklistedSeed.func_77973_b() != seed || blacklistedSeed.func_77960_j() != meta) continue;
            return true;
        }
        return false;
    }

    private static boolean ignoresVanillaPlantingSetting(ItemStack seed) {
        for (ItemStack stack : vanillaPlantingOverrides) {
            if (stack.func_77973_b() != seed.func_77973_b() || stack.func_77960_j() != seed.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    public static boolean allowVanillaPlanting(ItemStack seed) {
        if (seed == null || seed.func_77973_b() == null) {
            return false;
        }
        if (ConfigurationHandler.disableVanillaFarming) {
            if (SeedHelper.ignoresVanillaPlantingSetting(seed)) {
                return true;
            }
            if (CropPlantHandler.isValidSeed(seed)) {
                return false;
            }
            if (seed.func_77973_b() == Items.field_151174_bG) {
                return false;
            }
            if (seed.func_77973_b() == Items.field_151172_bF) {
                return false;
            }
            if (seed.func_77973_b() == Items.field_151120_aE) {
                return false;
            }
        }
        return true;
    }

    public static NBTTagCompound setNBT(NBTTagCompound tag, short growth, short gain, short strength, boolean analyzed) {
        short cap = (short)ConfigurationHandler.cropStatCap;
        tag.func_74777_a("growth", growth == 0 ? (short)1 : (growth > cap ? cap : growth));
        tag.func_74777_a("gain", gain == 0 ? (short)1 : (gain > cap ? cap : gain));
        tag.func_74777_a("strength", strength == 0 ? (short)1 : (strength > cap ? cap : strength));
        tag.func_74757_a("analyzed", analyzed);
        return tag;
    }

    public static ItemStack getRandomSeed(Random rand, boolean setTag) {
        return SeedHelper.getRandomSeed(rand, setTag, 5);
    }

    public static ItemStack getRandomSeed(Random rand, boolean setTag, List<CropPlant> plants) {
        boolean flag = false;
        ItemStack seed = null;
        while (!flag) {
            CropPlant plant = plants.get(rand.nextInt(plants.size()));
            seed = plant.getSeed().func_77946_l();
            flag = seed.func_77973_b() != null;
        }
        if (setTag) {
            NBTTagCompound tag = new NBTTagCompound();
            SeedHelper.setNBT(tag, (short)(rand.nextInt(ConfigurationHandler.cropStatCap) / 2 + 1), (short)(rand.nextInt(ConfigurationHandler.cropStatCap) / 2 + 1), (short)(rand.nextInt(ConfigurationHandler.cropStatCap) / 2 + 1), false);
            seed.field_77990_d = tag;
        }
        return seed;
    }

    public static ItemStack getRandomSeed(Random rand, boolean setTag, int maxTier) {
        return SeedHelper.getRandomSeed(rand, setTag, CropPlantHandler.getPlantsUpToTier(maxTier));
    }

    public static void addAllToSeedBlacklist(Collection<? extends ItemStack> seeds) {
        seedBlackList.addAll(seeds);
    }

    public static void removeAllFromSeedBlacklist(Collection<? extends ItemStack> seeds) {
        seedBlackList.removeAll(seeds);
    }

    public static int overrideSpreadChance(Item seed, int meta, int chance) {
        int oldChance = (int)(SeedHelper.getSpreadChance(seed, meta) * 100.0);
        Integer[] chances = spreadChances.get(seed);
        if (chances == null) {
            chances = new Integer[16];
            spreadChances.put(seed, chances);
        }
        chances[meta] = chance;
        return oldChance;
    }

    static {
        vanillaPlantingOverrides = new ArrayList<ItemStack>();
    }
}

