/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import toast.specialMobs.EffectHelper;
import toast.specialMobs.EnchantmentSpecial;
import toast.specialMobs.MobHelper;
import toast.specialMobs.TickHandler;
import toast.specialMobs.entity.pigzombie.EntityPlaguePigZombie;
import toast.specialMobs.entity.skeleton.EntityPoisonSkeleton;
import toast.specialMobs.entity.zombie.EntityPlagueZombie;

public class EventHandler {
    public EventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        ItemStack heldItem;
        if (event.entity instanceof EntityArrow && ((EntityArrow)event.entity).field_70250_c instanceof EntityLivingBase && (heldItem = ((EntityLivingBase)((EntityArrow)event.entity).field_70250_c).func_70694_bm()) != null) {
            int level = EnchantmentSpecial.painBow != null ? EnchantmentHelper.func_77506_a((int)EnchantmentSpecial.painBow.field_77352_x, (ItemStack)heldItem) : 0;
            if (level > 0) {
                event.entity.getEntityData().func_74768_a("SM|Pain", level);
            }
            if (EnchantmentSpecial.plagueBow != null) {
                level = EnchantmentHelper.func_77506_a((int)EnchantmentSpecial.plagueBow.field_77352_x, (ItemStack)heldItem);
            } else {
                int n = level = ((EntityArrow)event.entity).field_70250_c instanceof EntityPlagueZombie || ((EntityArrow)event.entity).field_70250_c instanceof EntityPlaguePigZombie ? 1 : 0;
            }
            if (level > 0) {
                event.entity.getEntityData().func_74768_a("SM|Plague", level);
            }
            if (EnchantmentSpecial.poisonBow != null) {
                level = EnchantmentHelper.func_77506_a((int)EnchantmentSpecial.poisonBow.field_77352_x, (ItemStack)heldItem);
            } else {
                int n = level = ((EntityArrow)event.entity).field_70250_c instanceof EntityPoisonSkeleton ? 1 : 0;
            }
            if (level > 0) {
                event.entity.getEntityData().func_74768_a("SM|Poison", level);
            }
        }
        if (!event.world.field_72995_K && event.entity instanceof EntityLiving) {
            EventHandler.replaceMob(event.world, (EntityLiving)event.entity);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingAttack(LivingHurtEvent event) {
        if (event.source != null) {
            Entity attacker = null;
            attacker = event.source.func_76364_f();
            int pain = 0;
            int plague = 0;
            int poison = 0;
            if (attacker instanceof EntityArrow) {
                pain = attacker.getEntityData().func_74762_e("SM|Pain");
                plague = attacker.getEntityData().func_74762_e("SM|Plague");
                poison = attacker.getEntityData().func_74762_e("SM|Poison");
            } else if (attacker instanceof EntityLivingBase) {
                ItemStack heldItem = ((EntityLivingBase)attacker).func_70694_bm();
                pain = heldItem != null && EnchantmentSpecial.painSword != null ? EnchantmentHelper.func_77506_a((int)EnchantmentSpecial.painSword.field_77352_x, (ItemStack)heldItem) : 0;
                if (heldItem != null && EnchantmentSpecial.plagueSword != null) {
                    plague = EnchantmentHelper.func_77506_a((int)EnchantmentSpecial.plagueSword.field_77352_x, (ItemStack)heldItem);
                } else {
                    int n = plague = attacker instanceof EntityPlagueZombie || attacker instanceof EntityPlaguePigZombie ? 1 : 0;
                }
                if (heldItem != null && EnchantmentSpecial.poisonSword != null) {
                    poison = EnchantmentHelper.func_77506_a((int)EnchantmentSpecial.poisonSword.field_77352_x, (ItemStack)heldItem);
                } else {
                    int n = poison = attacker instanceof EntityPoisonSkeleton ? 1 : 0;
                }
            }
            if (pain > 0) {
                event.entityLiving.func_70606_j(event.entityLiving.func_110143_aJ() - (float)pain);
            }
            if (plague > 0) {
                EffectHelper.plagueEffect(event.entityLiving, plague);
            }
            if (poison > 0) {
                EffectHelper.stackEffect(event.entityLiving, Potion.field_76436_u, 300, poison - 1, 3);
            }
        }
    }

    public static void replaceMob(World world, EntityLiving entity) {
        if (MobHelper.canReplace(entity)) {
            TickHandler.markEntityToBeReplaced(entity);
        }
    }
}

