/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockOre;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import toast.specialMobs.MessageExplosion;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.pigzombie.Entity_SpecialPigZombie;

public abstract class MobHelper {
    public static void clearZombieAttackAI(EntityLiving entity) {
        for (EntityAITasks.EntityAITaskEntry entry : entity.field_70714_bg.field_75782_a.toArray(new EntityAITasks.EntityAITaskEntry[0])) {
            if (!entry.field_75733_a.getClass().equals(EntityAIAttackOnCollide.class)) continue;
            entity.field_70714_bg.func_85156_a(entry.field_75733_a);
        }
    }

    public static void clearZombieTargetAI(EntityLiving entity) {
        for (EntityAITasks.EntityAITaskEntry entry : entity.field_70715_bh.field_75782_a.toArray(new EntityAITasks.EntityAITaskEntry[0])) {
            if (!entry.field_75733_a.getClass().equals(EntityAINearestAttackableTarget.class)) continue;
            entity.field_70715_bh.func_85156_a(entry.field_75733_a);
        }
    }

    public static boolean hasRangedAttack(EntityLiving entity) {
        for (EntityAITasks.EntityAITaskEntry entry : entity.field_70714_bg.field_75782_a.toArray(new EntityAITasks.EntityAITaskEntry[0])) {
            if (!(entry.field_75733_a instanceof EntityAIArrowAttack)) continue;
            return true;
        }
        return entity instanceof Entity_SpecialPigZombie && ((Entity_SpecialPigZombie)entity).willShootBow() && entity.func_70694_bm() != null && entity.func_70694_bm().func_77973_b() instanceof ItemBow;
    }

    public static void dropFewArrows(EntityLivingBase entity, boolean recentlyHit, int looting) {
        if (entity.func_70694_bm() == null || !(entity.func_70694_bm().func_77973_b() instanceof ItemBow)) {
            return;
        }
        int i = entity.func_70681_au().nextInt(3 + looting);
        while (i-- > 0) {
            entity.func_145779_a(Items.field_151032_g, 1);
        }
    }

    public static void darkExplode(Entity exploder, int radius) {
        Explosion explosion = new Explosion(exploder.field_70170_p, exploder, exploder.field_70165_t, exploder.field_70163_u, exploder.field_70161_v, (float)radius);
        float blastPower = explosion.field_77280_f * (0.7f + exploder.field_70170_p.field_73012_v.nextFloat() * 0.6f);
        HashSet<ChunkPosition> affectedBlocks = new HashSet<ChunkPosition>();
        int bX = (int)exploder.field_70165_t;
        int bY = (int)exploder.field_70163_u;
        int bZ = (int)exploder.field_70161_v;
        for (int x = -(radius <<= 2); x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    float resistance;
                    Block block;
                    if (Math.sqrt(x * x + y * y + z * z) > (double)radius || (block = exploder.field_70170_p.func_147439_a(bX + x, bY + y, bZ + z)) == null || block.func_149750_m() <= 1 || block instanceof BlockLiquid || block instanceof BlockFire || block == Blocks.field_150439_ay || block instanceof BlockOre || !(blastPower - (resistance = exploder.func_145772_a(explosion, exploder.field_70170_p, bX + x, bY + y, bZ + z, block) + 0.3f) * 0.3f > 0.0f) || !exploder.func_145774_a(explosion, exploder.field_70170_p, bX + x, bY + y, bZ + z, block, blastPower)) continue;
                    affectedBlocks.add(new ChunkPosition(bX + x, bY + y, bZ + z));
                }
            }
        }
        explosion.field_77281_g.addAll(affectedBlocks);
        explosion.func_77279_a(false);
        _SpecialMobs.CHANNEL.sendToDimension((IMessage)new MessageExplosion(explosion), exploder.field_71093_bK);
    }

    public static void dirtExplode(Entity exploder, int radius) {
        int bX = (int)exploder.field_70165_t;
        int bY = (int)exploder.field_70163_u;
        int bZ = (int)exploder.field_70161_v;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    if (Math.sqrt(x * x + y * y + z * z) > (double)radius || !Blocks.field_150346_d.func_149742_c(exploder.field_70170_p, bX + x, bY + y, bZ + z)) continue;
                    exploder.field_70170_p.func_147465_d(bX + x, bY + y, bZ + z, Blocks.field_150346_d, 0, 2);
                }
            }
        }
    }

    public static void drowningExplode(Entity exploder, int radius) {
        int bX = (int)exploder.field_70165_t;
        int bY = (int)exploder.field_70163_u;
        int bZ = (int)exploder.field_70161_v;
        for (int x = -(++radius); x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    double dist = Math.sqrt(x * x + y * y + z * z);
                    if (!(dist <= (double)radius)) continue;
                    if (dist > (double)(radius - 1)) {
                        if (!Blocks.field_150418_aU.func_149742_c(exploder.field_70170_p, bX + x, bY + y, bZ + z)) continue;
                        exploder.field_70170_p.func_147465_d(bX + x, bY + y, bZ + z, Blocks.field_150418_aU, 1, 2);
                        continue;
                    }
                    if (!Blocks.field_150355_j.func_149742_c(exploder.field_70170_p, bX + x, bY + y, bZ + z)) continue;
                    exploder.field_70170_p.func_147465_d(bX + x, bY + y, bZ + z, Blocks.field_150355_j, 0, 2);
                }
            }
        }
    }

    public static void lightningExplode(Entity exploder, int radius) {
        for (int x = -(radius /= 3); x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                exploder.field_70170_p.func_72838_d((Entity)new EntityLightningBolt(exploder.field_70170_p, exploder.field_70165_t + (double)x, exploder.field_70163_u, exploder.field_70161_v + (double)z));
            }
        }
        _SpecialMobs.CHANNEL.sendToDimension((IMessage)new MessageExplosion(exploder, radius, "lightning"), exploder.field_71093_bK);
    }

    public static ItemStack removeHeldItem(EntityPlayer player) {
        ItemStack heldItem = player.field_71071_by.func_70448_g();
        if (heldItem != null) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
        }
        return heldItem;
    }

    public static ItemStack removeRandomItem(EntityPlayer player) {
        int count = 0;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (player.field_71071_by.func_70301_a(i) == null) continue;
            ++count;
        }
        if (count > 0) {
            count = _SpecialMobs.random.nextInt(count);
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack item = player.field_71071_by.func_70301_a(i);
                if (item == null || --count >= 0) continue;
                player.field_71071_by.func_70299_a(i, (ItemStack)null);
                return item;
            }
        }
        return null;
    }

    public static boolean canReplace(EntityLiving entity) {
        return !entity.func_104002_bU() && entity.getEntityData().func_74771_c("smi") == 0;
    }
}

