/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs;

import java.util.HashMap;
import java.util.Random;
import net.minecraftforge.common.config.Configuration;
import toast.specialMobs._SpecialMobs;

public abstract class Properties {
    private static final HashMap<String, Object> map = new HashMap();
    public static final String ENCHANTS = "_enchants";
    public static final String SPAWNING = "_extra_spawning";
    public static final String GENERAL = "_general";
    public static final String STATS = "_mob_stats";
    private static boolean[] monsterVanilla = new boolean[_SpecialMobs.MONSTER_KEY.length];
    private static boolean[] monsterSpawn = new boolean[_SpecialMobs.MONSTER_KEY.length];
    private static int[][] monsterWeights = new int[_SpecialMobs.MONSTER_KEY.length][];

    public static void init(Configuration config) {
        config.load();
        Properties.add(config, ENCHANTS, "pain_bow", 160);
        Properties.add(config, ENCHANTS, "pain_sword", 161);
        Properties.add(config, ENCHANTS, "plague_bow", 162);
        Properties.add(config, ENCHANTS, "plague_sword", 163);
        Properties.add(config, ENCHANTS, "poison_bow", 164);
        Properties.add(config, ENCHANTS, "poison_sword", 165);
        Properties.add(config, SPAWNING, "end_ender_creeper", 1, 0, Integer.MAX_VALUE);
        Properties.add(config, SPAWNING, "nether_fire_creeper", 10, 0, Integer.MAX_VALUE);
        Properties.add(config, SPAWNING, "overworld_ghast_mount", 1, 0, Integer.MAX_VALUE);
        Properties.add(config, GENERAL, "random_scaling", 0.3, "The maximum magnitude for random size scaling (scaling * 50% = max difference %). Setting this to 0 disables random size scaling. Default is +/-15%");
        Properties.add(config, GENERAL, "spawn_eggs", false, "If true, the game will attempt to make a spawn egg for each special mob. Be warned, this will eat up a ton of global entity ids. Default is false.");
        Properties.add(config, GENERAL, "trolling", true, "If false, trolling will be disabled. Default is true.");
        Properties.add(config, STATS, "baby_skeleton_chance", 0.05, 0.0, 1.0, "(0 <= x <= 1) Chance that a skeleton will spawn as a baby. Default is 5%.");
        Properties.add(config, STATS, "bow_chance_pigzombie", 0.25, 0.0, 1.0, "(0 <= x <= 1) Chance that a zombie pigman will spawn with a bow, if possible. Default is 25%.");
        Properties.add(config, STATS, "bow_chance_skeleton", 0.95, 0.0, 1.0, "(0 <= x <= 1) Chance that a skeleton will spawn with a bow, if possible. Default is 95%.");
        Properties.add(config, STATS, "bow_chance_wither", 0.05, 0.0, 1.0, "(0 <= x <= 1) Chance that a wither skeleton will spawn with a bow, if possible. Default is 5%.");
        Properties.add(config, STATS, "bow_chance_zombie", 0.05, 0.0, 1.0, "(0 <= x <= 1) Chance that a zombie will spawn with a bow, if possible. Default is 5%.");
        Properties.add(config, STATS, "creeper_charge_chance", 0.01, 0.0, 1.0, "(0 <= x <= 1) Chance that any creeper spawned during a thunderstorm will be charged. Default is 1%.");
        Properties.add(config, STATS, "enderman_griefing", true, "(True/false) If true, endermen will pick up blocks and place them around randomly, as in vanilla. Default is true.");
        Properties.add(config, STATS, "hostile_cavespiders", 1.0, 0.0, 1.0, "(0 <= x <= 1) Chance that a cave spider will spawn aggressive in daylight. Default is 100%.");
        Properties.add(config, STATS, "hostile_pigzombies", 0.05, 0.0, 1.0, "(0 <= x <= 1) Chance that a zombie pigman will spawn already mad. Default is 1%.");
        Properties.add(config, STATS, "hostile_silverfish", 0.2, 0.0, 1.0, "(0 <= x <= 1) Chance that a silverfish will spawn already calling for reinforcements. Default is 20%.");
        Properties.add(config, STATS, "hostile_spiders", 0.1, 0.0, 1.0, "(0 <= x <= 1) Chance that a spider will spawn aggressive in daylight. Default is 10%.");
        Properties.add(config, STATS, "villager_infection", 1.0, 0.0, 1.0, "(0 <= x <= 1) Chance that a villager will be infected when killed by a zombie. Default is 100%.");
        Properties.add(config, STATS, "xray_ghosts", false, "(True/false) If false, ghost spiders and faint ghasts will require line of sight to aggro, unlike their normal counterparts. Default is false.");
        Properties.init(config, "monster", _SpecialMobs.MONSTER_KEY, _SpecialMobs.MONSTER_TYPES, monsterVanilla, monsterSpawn, monsterWeights);
        config.addCustomCategoryComment(ENCHANTS, "Ids for all enchantments added by this mod. Set the id to -1 to disable any specific enchantment.");
        config.addCustomCategoryComment(SPAWNING, "Weighted chances for each additional spawn. Set the weight to 0 to disable the spawn.");
        config.addCustomCategoryComment(GENERAL, "Spawn rates for each mob type and miscellaneous options.");
        config.addCustomCategoryComment(STATS, "Additional options for mobs' stats, such as the chance for the mob to have a bow or to be unusually hostile.");
        config.save();
    }

    private static void init(Configuration config, String category, String[] key, String[][] types, boolean[] keyVanilla, boolean[] keyValues, int[][] typeWeights) {
        for (int i = 0; i < key.length; ++i) {
            String pluralKey = key[i].toLowerCase();
            String MOB_CATEGORY = pluralKey + "_rates";
            pluralKey = key[i] == "Enderman" ? "endermen" : pluralKey + "s";
            keyVanilla[i] = config.get(MOB_CATEGORY, "_allow_vanilla", false, "If this false, vanilla " + pluralKey + " will be replaced with similar Special Mobs versions if not \"special\".").getBoolean(true);
            keyValues[i] = config.get(MOB_CATEGORY, "_special_" + pluralKey, true, "Set this to false to disable all special " + pluralKey + ".").getBoolean(true);
            typeWeights[i][0] = Math.max(0, config.get(MOB_CATEGORY, "_vanilla", 30).getInt(30));
            for (int j = 0; j < types[i].length; ++j) {
                typeWeights[i][j + 1] = Math.max(0, config.get(MOB_CATEGORY, types[i][j].toLowerCase(), 1).getInt(1));
            }
            config.addCustomCategoryComment(MOB_CATEGORY, "Weighted chances for each mob subtype when a vanilla " + _SpecialMobs.localizeName(key[i]) + " is spawned.");
        }
    }

    public static Random random() {
        return _SpecialMobs.random;
    }

    public static void debugException(String message) {
        _SpecialMobs.debugException(message);
    }

    public static boolean[] monsterVanilla() {
        return monsterVanilla;
    }

    public static boolean[] monsterSpawn() {
        return monsterSpawn;
    }

    public static int[][] monsterWeights() {
        return monsterWeights;
    }

    public static void add(Configuration config, String category, String field, String defaultValue, String comment) {
        map.put(category + "@" + field, config.get(category, field, defaultValue, comment).getString());
    }

    public static void add(Configuration config, String category, String field, int defaultValue) {
        map.put(category + "@" + field, config.get(category, field, defaultValue).getInt(defaultValue));
    }

    public static void add(Configuration config, String category, String field, int defaultValue, String comment) {
        map.put(category + "@" + field, config.get(category, field, defaultValue, comment).getInt(defaultValue));
    }

    public static void add(Configuration config, String category, String field, int defaultValue, int minValue, int maxValue) {
        map.put(category + "@" + field, Math.max(minValue, Math.min(maxValue, config.get(category, field, defaultValue).getInt(defaultValue))));
    }

    public static void add(Configuration config, String category, String field, int defaultValue, int minValue, int maxValue, String comment) {
        map.put(category + "@" + field, Math.max(minValue, Math.min(maxValue, config.get(category, field, defaultValue, comment).getInt(defaultValue))));
    }

    public static void add(Configuration config, String category, String field, boolean defaultValue) {
        map.put(category + "@" + field, config.get(category, field, defaultValue).getBoolean(defaultValue));
    }

    public static void add(Configuration config, String category, String field, boolean defaultValue, String comment) {
        map.put(category + "@" + field, config.get(category, field, defaultValue, comment).getBoolean(defaultValue));
    }

    public static void add(Configuration config, String category, String field, double defaultValue) {
        map.put(category + "@" + field, config.get(category, field, defaultValue).getDouble(defaultValue));
    }

    public static void add(Configuration config, String category, String field, double defaultValue, String comment) {
        map.put(category + "@" + field, config.get(category, field, defaultValue, comment).getDouble(defaultValue));
    }

    public static void add(Configuration config, String category, String field, double defaultValue, double minValue, double maxValue, String comment) {
        map.put(category + "@" + field, Math.max(minValue, Math.min(maxValue, config.get(category, field, defaultValue, comment).getDouble(defaultValue))));
    }

    public static Object getProperty(String category, String field) {
        return map.get(category + "@" + field);
    }

    public static String getString(String category, String field) {
        return Properties.getProperty(category, field).toString();
    }

    public static boolean getBoolean(String category, String field) {
        return Properties.getBoolean(category, field, Properties.random());
    }

    public static boolean getBoolean(String category, String field, Random random) {
        Object property = Properties.getProperty(category, field);
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof Integer) {
            return random.nextInt(((Number)property).intValue()) == 0;
        }
        if (property instanceof Double) {
            return random.nextDouble() < ((Number)property).doubleValue();
        }
        Properties.debugException("Tried to get boolean for invalid property! @" + property == null ? "(null)" : property.getClass().getName());
        return false;
    }

    public static int getInt(String category, String field) {
        Object property = Properties.getProperty(category, field);
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof Boolean) {
            return (Boolean)property != false ? 1 : 0;
        }
        Properties.debugException("Tried to get int for invalid property! @" + property == null ? "(null)" : property.getClass().getName());
        return 0;
    }

    public static double getDouble(String category, String field) {
        Object property = Properties.getProperty(category, field);
        if (property instanceof Number) {
            return ((Number)property).doubleValue();
        }
        if (property instanceof Boolean) {
            return (Boolean)property != false ? 1.0 : 0.0;
        }
        Properties.debugException("Tried to get double for invalid property! @" + property == null ? "(null)" : property.getClass().getName());
        return 0.0;
    }

    static {
        int i = monsterWeights.length;
        while (i-- > 0) {
            Properties.monsterWeights[i] = new int[_SpecialMobs.MONSTER_TYPES[i].length + 1];
        }
    }
}

