/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Facing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import toast.specialMobs.SpecialDamageSource;

public class EntitySpecialFireball
extends Entity {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    private boolean inGround = false;
    public EntityLivingBase shootingEntity;
    private int ticksAlive;
    private int ticksInAir = 0;
    public double accelerationX;
    public double accelerationY;
    public double accelerationZ;
    public byte type = 0;

    public EntitySpecialFireball(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntitySpecialFireball(World world, double x, double y, double z, double aX, double aY, double aZ) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        this.func_70107_b(x, y, z);
        double a = MathHelper.func_76133_a((double)(aX * aX + aY * aY + aZ * aZ));
        this.accelerationX = aX / a * 0.1;
        this.accelerationY = aY / a * 0.1;
        this.accelerationZ = aZ / a * 0.1;
    }

    public EntitySpecialFireball(World world, EntityLivingBase entity, double aX, double aY, double aZ) {
        this(world, entity, aX, aY, aZ, 0.4);
    }

    public EntitySpecialFireball(World world, EntityLivingBase entity, double aX, double aY, double aZ, double variance) {
        super(world);
        this.shootingEntity = entity;
        this.func_70105_a(1.0f, 1.0f);
        this.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        double a = MathHelper.func_76133_a((double)((aX += this.field_70146_Z.nextGaussian() * variance) * aX + (aY += this.field_70146_Z.nextGaussian() * variance) * aY + (aZ += this.field_70146_Z.nextGaussian() * variance) * aZ));
        this.accelerationX = aX / a * 0.1;
        this.accelerationY = aY / a * 0.1;
        this.accelerationZ = aZ / a * 0.1;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(30, (Object)1000);
        this.field_70180_af.func_75682_a(31, (Object)1000);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double d) {
        double d0 = this.field_70121_D.func_72320_b() * 4.0;
        return d < (d0 *= 64.0) * d0;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && (this.shootingEntity != null && this.shootingEntity.field_70128_L || !this.field_70170_p.func_72899_e((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v))) {
            this.func_70106_y();
        } else {
            super.func_70071_h_();
            this.func_70015_d(1);
            if (this.inGround) {
                Block block = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
                if (block == this.inTile) {
                    if (++this.ticksAlive == 600) {
                        this.func_70106_y();
                    }
                    return;
                }
                this.inGround = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksAlive = 0;
                this.ticksInAir = 0;
            } else {
                ++this.ticksInAir;
            }
            Vec3 posVec = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            Vec3 motionVec = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            MovingObjectPosition object = this.field_70170_p.func_72933_a(posVec, motionVec);
            posVec = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            motionVec = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            if (object != null) {
                motionVec = Vec3.func_72443_a((double)object.field_72307_f.field_72450_a, (double)object.field_72307_f.field_72448_b, (double)object.field_72307_f.field_72449_c);
            }
            Entity entityHit = null;
            List entitiesInPath = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double closestHit = Double.POSITIVE_INFINITY;
            for (Entity entityInPath : entitiesInPath) {
                double distance;
                AxisAlignedBB aabb;
                MovingObjectPosition objectInPath;
                if (!entityInPath.func_70067_L() || entityInPath.func_70028_i((Entity)this.shootingEntity) || (objectInPath = (aabb = entityInPath.field_70121_D.func_72314_b(0.3, 0.3, 0.3)).func_72327_a(posVec, motionVec)) == null || !((distance = posVec.func_72438_d(objectInPath.field_72307_f)) < closestHit)) continue;
                entityHit = entityInPath;
                closestHit = distance;
            }
            if (entityHit != null) {
                object = new MovingObjectPosition(entityHit);
            }
            if (object != null) {
                this.onImpact(object);
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float vH = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70125_A = (float)(Math.atan2(this.field_70181_x, vH) * 180.0 / Math.PI);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float accelFactor = 0.95f;
            if (this.func_70090_H()) {
                for (int i = 4; i > 0; --i) {
                    this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                accelFactor = 0.8f;
            }
            this.field_70159_w += this.accelerationX * (double)this.getSpeed();
            this.field_70181_x += this.accelerationY * (double)this.getSpeed();
            this.field_70179_y += this.accelerationZ * (double)this.getSpeed();
            this.field_70159_w *= (double)accelFactor;
            this.field_70181_x *= (double)accelFactor;
            this.field_70179_y *= (double)accelFactor;
            this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0);
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    protected void onImpact(MovingObjectPosition object) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        SpecialDamageSource damageSource = this.shootingEntity == null ? new SpecialDamageSource("onFire", this, this) : new SpecialDamageSource("fireball", this, (Entity)this.shootingEntity);
        damageSource.setFireDamage().setProjectile().setDamageBypassesArmor().setMagicDamage().setDifficultyScaled();
        if (this.type == 0) {
            if (object.field_72308_g != null) {
                object.field_72308_g.func_70097_a((DamageSource)damageSource, (float)(4 + (int)(2.0f * this.getPower())));
            }
            if (this.getPower() > 0.0f) {
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getPower(), true, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
            }
        } else if (this.type > 0) {
            if (object.field_72308_g != null) {
                object.field_72308_g.func_70015_d(this.type * 4);
                object.field_72308_g.func_70097_a((DamageSource)damageSource, (float)(4 + (int)(4.0f * (this.getPower() - 1.0f))));
            } else {
                int x = object.field_72311_b;
                int y = object.field_72312_c;
                int z = object.field_72309_d;
                if (this.field_70170_p.func_147437_c(x += Facing.field_71586_b[object.field_72310_e], y += Facing.field_71587_c[object.field_72310_e], z += Facing.field_71585_d[object.field_72310_e])) {
                    this.field_70170_p.func_147465_d(x, y, z, (Block)Blocks.field_150480_ab, 0, 2);
                }
            }
        }
        this.func_70106_y();
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74774_a("type", this.type);
        tag.func_74776_a("speed", this.getSpeed());
        tag.func_74776_a("power", this.getPower());
        tag.func_74777_a("xTile", (short)this.xTile);
        tag.func_74777_a("yTile", (short)this.yTile);
        tag.func_74777_a("zTile", (short)this.zTile);
        tag.func_74774_a("inTile", (byte)Block.func_149682_b((Block)this.inTile));
        tag.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        tag.func_74782_a("direction", (NBTBase)this.func_70087_a(new double[]{this.field_70159_w, this.field_70181_x, this.field_70179_y}));
    }

    public void func_70037_a(NBTTagCompound tag) {
        this.type = tag.func_74771_c("type");
        this.setSpeed(tag.func_74760_g("speed"));
        this.setPower(tag.func_74760_g("power"));
        this.xTile = tag.func_74765_d("xTile");
        this.yTile = tag.func_74765_d("yTile");
        this.zTile = tag.func_74765_d("zTile");
        this.inTile = Block.func_149729_e((int)(tag.func_74771_c("inTile") & 0xFF));
        this.inGround = tag.func_74771_c("inGround") == 1;
        NBTTagList list = tag.func_150295_c("direction", (int)new NBTTagDouble(0.0).func_74732_a());
        this.field_70159_w = list.func_150309_d(0);
        this.field_70181_x = list.func_150309_d(1);
        this.field_70179_y = list.func_150309_d(2);
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        this.func_70018_K();
        if (damageSource.func_76346_g() != null) {
            Vec3 lookVec = damageSource.func_76346_g().func_70040_Z();
            if (lookVec != null) {
                this.field_70159_w = lookVec.field_72450_a;
                this.field_70181_x = lookVec.field_72448_b;
                this.field_70179_y = lookVec.field_72449_c;
                this.accelerationX = this.field_70159_w * 0.1;
                this.accelerationY = this.field_70181_x * 0.1;
                this.accelerationZ = this.field_70179_y * 0.1;
            }
            this.shootingEntity = damageSource.func_76346_g() instanceof EntityLivingBase ? (EntityLivingBase)damageSource.func_76346_g() : null;
            return true;
        }
        return false;
    }

    public float getSpeed() {
        return (float)this.field_70180_af.func_75679_c(30) / 1000.0f;
    }

    public void setSpeed(float speed) {
        this.field_70180_af.func_75692_b(30, (Object)((int)(speed * 1000.0f)));
    }

    public float getPower() {
        return (float)this.field_70180_af.func_75679_c(31) / 1000.0f;
    }

    public void setPower(float power) {
        this.field_70180_af.func_75692_b(31, (Object)((int)(power * 1000.0f)));
    }

    public void setSpeedAndPower(float speed, float power) {
        this.setSpeed(speed);
        this.setPower(power);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public float func_70013_c(float partialTick) {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float partialTick) {
        return 0xF000F0;
    }
}

