/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.creeper;

import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import toast.specialMobs.EffectHelper;
import toast.specialMobs.entity.creeper.Entity_SpecialCreeper;

public class EntityEnderCreeper
extends Entity_SpecialCreeper {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("SpecialMobs:textures/models/creeper/ender.png"), new ResourceLocation("SpecialMobs:textures/models/creeper/ender_eyes.png")};
    private static final UUID attackingSpeedBoostUUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier attackingSpeedBoost = new AttributeModifier(attackingSpeedBoostUUID, "Attacking speed boost", 6.2, 0).func_111168_a(false);
    private Entity lastEntityToAttack;
    private int teleportDelay = 0;
    private int lookDelay = 0;

    public EntityEnderCreeper(World world) {
        super(world);
        this.getSpecialData().setTextures(TEXTURES);
        this.field_70728_aV += 2;
    }

    @Override
    protected void adjustTypeAttributes() {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 20.0);
        this.getSpecialData().multAttribute(SharedMonsterAttributes.field_111263_d, 1.2);
    }

    public boolean func_70650_aV() {
        return false;
    }

    @Override
    protected void func_70628_a(boolean recentlyHit, int looting) {
        super.func_70628_a(recentlyHit, looting);
        int i = this.field_70146_Z.nextInt(2 + looting);
        while (i-- > 0) {
            this.func_145779_a(Items.field_151079_bi, 1);
        }
    }

    protected void func_70600_l(int superRare) {
        ItemStack drop = new ItemStack((Item)Items.field_151112_aM);
        EffectHelper.setItemName(drop, "Whip of Destruction", 13);
        drop.func_77966_a(Enchantment.field_77338_j, 1);
        drop.func_77966_a(Enchantment.field_77347_r, 10);
        this.func_70099_a(drop, 0.0f);
    }

    protected Entity func_70782_k() {
        EntityPlayer player = this.field_70170_p.func_72856_b((Entity)this, 64.0);
        if (player != null) {
            if (this.shouldAttackPlayer(player)) {
                if (this.lookDelay++ == 5) {
                    this.lookDelay = 0;
                    return player;
                }
            } else {
                this.lookDelay = 0;
            }
        }
        return null;
    }

    private boolean shouldAttackPlayer(EntityPlayer player) {
        ItemStack itemStack = player.field_71071_by.field_70460_b[3];
        if (itemStack != null && itemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150423_aK)) {
            return false;
        }
        Vec3 lookVec = player.func_70676_i(1.0f).func_72432_b();
        Vec3 posVec = Vec3.func_72443_a((double)(this.field_70165_t - player.field_70165_t), (double)(this.field_70121_D.field_72338_b + (double)this.field_70131_O / 2.0 - player.field_70163_u - (double)player.func_70047_e()), (double)(this.field_70161_v - player.field_70161_v));
        double distance = posVec.func_72433_c();
        double dotProduct = lookVec.func_72430_b(posVec = posVec.func_72432_b());
        return dotProduct > 1.0 - 0.025 / distance ? player.func_70685_l((Entity)this) : false;
    }

    @Override
    public void func_70636_d() {
        float brightness;
        if (this.lastEntityToAttack != this.field_70789_a) {
            IAttributeInstance attribute = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            attribute.func_111124_b(attackingSpeedBoost);
            if (this.field_70789_a != null) {
                attribute.func_111121_a(attackingSpeedBoost);
            }
        }
        this.lastEntityToAttack = this.field_70789_a;
        for (int i = 0; i < 2; ++i) {
            this.field_70170_p.func_72869_a("portal", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
        }
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && (brightness = this.func_70013_c(1.0f)) > 0.5f && this.field_70170_p.func_72937_j((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v)) && this.field_70146_Z.nextFloat() * 30.0f < (brightness - 0.4f) * 2.0f) {
            this.field_70789_a = null;
            this.teleportRandomly();
        }
        if (this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
            this.field_70789_a = null;
            this.teleportRandomly();
        }
        this.field_70703_bu = false;
        if (this.field_70789_a != null) {
            if (this.field_70789_a.func_70068_e((Entity)this) < 9.0 && this.func_70685_l(this.field_70789_a)) {
                this.func_70829_a(1);
            } else {
                this.func_70829_a(-1);
            }
            this.func_70625_a(this.field_70789_a, 100.0f, 100.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (this.field_70789_a != null) {
                if (this.field_70789_a instanceof EntityPlayer && this.shouldAttackPlayer((EntityPlayer)this.field_70789_a)) {
                    if (this.func_70832_p() < 0 && this.field_70789_a.func_70068_e((Entity)this) < 16.0) {
                        this.teleportRandomly();
                    }
                    this.teleportDelay = 0;
                } else if (this.field_70789_a.func_70068_e((Entity)this) > 256.0 && this.teleportDelay++ >= 30 && this.teleportToEntity(this.field_70789_a)) {
                    this.teleportDelay = 0;
                }
            } else {
                this.teleportDelay = 0;
            }
        }
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (damageSource instanceof EntityDamageSourceIndirect) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
        }
        return super.func_70097_a(damageSource, damage);
    }

    protected boolean teleportRandomly() {
        double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double y = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(x, y, z);
    }

    protected boolean teleportToEntity(Entity entity) {
        Vec3 vector = Vec3.func_72443_a((double)(this.field_70165_t - entity.field_70165_t), (double)(this.field_70121_D.field_72338_b + (double)(this.field_70131_O / 2.0f) - entity.field_70163_u + (double)entity.func_70047_e()), (double)(this.field_70161_v - entity.field_70161_v));
        vector = vector.func_72432_b();
        double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vector.field_72450_a * 16.0;
        double y = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vector.field_72448_b * 16.0;
        double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vector.field_72449_c * 16.0;
        return this.teleportTo(x, y, z);
    }

    protected boolean teleportTo(double x, double y, double z) {
        int blockZ;
        int blockY;
        double xI = this.field_70165_t;
        double yI = this.field_70163_u;
        double zI = this.field_70161_v;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        boolean canTeleport = false;
        int blockX = (int)Math.floor(this.field_70165_t);
        if (this.field_70170_p.func_72899_e(blockX, blockY = (int)Math.floor(this.field_70163_u), blockZ = (int)Math.floor(this.field_70161_v))) {
            boolean canTeleportToBlock = false;
            while (!canTeleportToBlock && blockY > 0) {
                Block block = this.field_70170_p.func_147439_a(blockX, blockY - 1, blockZ);
                if (block != null && block.func_149688_o().func_76230_c()) {
                    canTeleportToBlock = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                --blockY;
            }
            if (canTeleportToBlock) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).size() == 0 && !this.field_70170_p.func_72953_d(this.field_70121_D)) {
                    canTeleport = true;
                }
            }
        }
        if (!canTeleport) {
            this.func_70107_b(xI, yI, zI);
            return false;
        }
        for (int i = 0; i < 128; ++i) {
            double posRelative = (double)i / 127.0;
            float vX = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float vY = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float vZ = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double dX = xI + (this.field_70165_t - xI) * posRelative + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double dY = yI + (this.field_70163_u - yI) * posRelative + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double dZ = zI + (this.field_70161_v - zI) * posRelative + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_72869_a("portal", dX, dY, dZ, (double)vX, (double)vY, (double)vZ);
        }
        this.field_70170_p.func_72908_a(xI, yI, zI, "mob.endermen.portal", 1.0f, 1.0f);
        this.field_70170_p.func_72956_a((Entity)this, "mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }
}

