/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.zombie;

import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.MobHelper;
import toast.specialMobs.Properties;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.ISpecialMob;
import toast.specialMobs.entity.SpecialMobData;

public class Entity_SpecialZombie
extends EntityZombie
implements ISpecialMob,
IRangedAttackMob {
    private static final double INFECT_CHANCE = Properties.getDouble("_mob_stats", "villager_infection");
    private static final double BOW_CHANCE = Properties.getDouble("_mob_stats", "bow_chance_zombie");
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("textures/entity/zombie/zombie.png"), new ResourceLocation("textures/entity/zombie/zombie_villager.png")};
    public EntityAIArrowAttack aiArrowAttack;
    public EntityAIAttackOnCollide[] aiAttackOnCollide;
    private final SpecialMobData specialData;

    public Entity_SpecialZombie(World world) {
        super(world);
        MobHelper.clearZombieAttackAI((EntityLiving)this);
        if (world != null && !world.field_72995_K) {
            this.setCombatTask();
        }
        this.specialData = new SpecialMobData((EntityLiving)this, TEXTURES);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.initTypeAI();
    }

    protected void initTypeAI() {
        this.setRangedAI(0.9, 23, 70, 12.0f);
        this.setMeleeAI(1.0);
    }

    protected void setRangedAI(double moveSpeed, int minDelay, int maxDelay, float range) {
        this.aiArrowAttack = new EntityAIArrowAttack((IRangedAttackMob)this, moveSpeed, minDelay, maxDelay, range);
    }

    protected void setMeleeAI(double moveSpeed) {
        this.aiAttackOnCollide = new EntityAIAttackOnCollide[]{new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, moveSpeed, false), new EntityAIAttackOnCollide((EntityCreature)this, EntityVillager.class, moveSpeed, true)};
    }

    @Override
    public SpecialMobData getSpecialData() {
        return this.specialData;
    }

    @Override
    public void adjustEntityAttributes() {
        if (this.field_70146_Z.nextDouble() < BOW_CHANCE) {
            ItemStack itemStack = new ItemStack((Item)Items.field_151031_f);
            float tension = this.field_70170_p.func_147462_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (this.field_70146_Z.nextFloat() < 0.25f * tension) {
                EnchantmentHelper.func_77504_a((Random)this.field_70146_Z, (ItemStack)itemStack, (int)((int)(5.0f + tension * (float)this.field_70146_Z.nextInt(18))));
            }
            this.func_70062_b(0, itemStack);
        }
        float prevMax = this.func_110138_aP();
        this.adjustTypeAttributes();
        this.func_70606_j(this.func_110138_aP() + this.func_110143_aJ() - prevMax);
    }

    protected void adjustTypeAttributes() {
    }

    public void func_82196_d(EntityLivingBase target, float range) {
        EntityArrow arrow = new EntityArrow(this.field_70170_p, (EntityLivingBase)this, target, 1.6f, this.getTypeArrowSpread());
        arrow.func_70239_b((double)(range * this.getTypeArrowDamage()) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.field_73013_u.func_151525_a() * 0.11f));
        int power = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)this.func_70694_bm());
        int punch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)this.func_70694_bm());
        if (power > 0) {
            arrow.func_70239_b(arrow.func_70242_d() + (double)power * 0.5 + 0.5);
        }
        if (punch > 0) {
            arrow.func_70240_a(punch);
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)this.func_70694_bm()) > 0) {
            arrow.func_70015_d(100);
        }
        this.func_85030_a("random.bow", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)arrow);
    }

    protected float getTypeArrowSpread() {
        return 14 - this.field_70170_p.field_73013_u.func_151525_a() * 4;
    }

    protected float getTypeArrowDamage() {
        return 2.0f;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getSpecialData().onUpdate();
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        return this.getSpecialData().onSpawnWithEgg(data, (EntityLiving)new EntityZombie(this.field_70170_p));
    }

    public boolean func_70631_g_() {
        if (this.field_70729_aU && !this.field_70170_p.field_72995_K) {
            return false;
        }
        return super.func_70631_g_();
    }

    public boolean func_70652_k(Entity target) {
        this.func_71038_i();
        if (super.func_70652_k(target)) {
            this.onTypeAttack(target);
            return true;
        }
        return false;
    }

    protected void onTypeAttack(Entity target) {
    }

    public void func_70074_a(EntityLivingBase entity) {
        if (!this.field_70170_p.field_72995_K && entity instanceof EntityVillager && this.field_70146_Z.nextDouble() < INFECT_CHANCE) {
            Entity_SpecialZombie zombie = null;
            try {
                zombie = (Entity_SpecialZombie)this.getClass().getConstructor(World.class).newInstance(this.field_70170_p);
            }
            catch (Exception ex) {
                _SpecialMobs.debugException("Error infecting villager! " + ex.getClass().getName() + " @" + this.getClass().getName());
                return;
            }
            zombie.func_82149_j((Entity)entity);
            this.field_70170_p.func_72838_d((Entity)zombie);
            zombie.func_110161_a(null);
            zombie.func_82229_g(true);
            zombie.func_82227_f(entity.func_70631_g_());
            this.field_70170_p.func_72889_a((EntityPlayer)null, 1016, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
            entity.func_70106_y();
        }
    }

    public void setCombatTask() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide[0]);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide[1]);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
        ItemStack itemStack = this.func_70694_bm();
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemBow) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiArrowAttack);
        } else {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiAttackOnCollide[0]);
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiAttackOnCollide[1]);
        }
    }

    public void func_70062_b(int slot, ItemStack itemStack) {
        super.func_70062_b(slot, itemStack);
        if (!this.field_70170_p.field_72995_K && slot == 0) {
            this.setCombatTask();
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        this.getSpecialData().writeToNBT(tag);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.setCombatTask();
        this.getSpecialData().readFromNBT(tag);
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        super.func_70628_a(recentlyHit, looting);
    }
}

