/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb;

import greymerk.roguelike.catacomb.CatacombLevel;
import greymerk.roguelike.worldgen.BlockJumble;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class CatacombTunneler {
    private Random rand;
    private CatacombLevel level;
    private List<Coord> tunnel;
    private Cardinal dir;
    private Coord pos;
    private boolean done;
    private int extend;

    public CatacombTunneler(World world, Random rand, CatacombLevel level, Cardinal direction, Coord origin) {
        this.rand = rand;
        this.level = level;
        this.dir = direction;
        this.pos = new Coord(origin);
        this.done = false;
        this.extend = level.getSettings().getScatter() * 2;
        this.tunnel = new ArrayList<Coord>();
        this.tunnel.add(new Coord(origin));
    }

    public void update() {
        if (this.done) {
            return;
        }
        if (this.level.hasNearbyNode(this.pos.getX(), this.pos.getZ(), this.level.getSettings().getScatter())) {
            this.advance();
        } else if (this.rand.nextInt(this.extend) == 0) {
            this.level.spawnNode(this);
            this.done = true;
        } else {
            this.advance();
            --this.extend;
        }
    }

    public void advance() {
        Coord toAdd = new Coord(this.pos);
        this.tunnel.add(new Coord(toAdd));
        toAdd.add(this.dir, 1);
        this.pos.add(this.dir);
    }

    public boolean isDone() {
        return this.done;
    }

    public Cardinal getDirection() {
        return this.dir;
    }

    public Coord getPosition() {
        return new Coord(this.pos);
    }

    public void construct(World world) {
        if (this.tunnel.isEmpty()) {
            return;
        }
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        IBlockFactory wallBlocks = this.level.getSettings().getTheme().getPrimaryWall();
        IBlockFactory floor = this.level.getSettings().getTheme().getPrimaryFloor();
        BlockJumble bridgeBlocks = new BlockJumble();
        bridgeBlocks.addBlock(floor);
        bridgeBlocks.addBlock(air);
        for (Coord location : this.tunnel) {
            int x = location.getX();
            int z = location.getZ();
            if (this.dir == Cardinal.NORTH || this.dir == Cardinal.SOUTH) {
                WorldGenPrimitive.fillRectSolid(world, this.rand, x - 1, this.pos.getY(), z, x + 1, this.pos.getY() + 2, z, air, false, true);
                WorldGenPrimitive.fillRectSolid(world, this.rand, x - 2, this.pos.getY() - 1, z, x + 2, this.pos.getY() + 4, z, wallBlocks, false, true);
                WorldGenPrimitive.fillRectSolid(world, this.rand, x - 1, this.pos.getY() - 1, z, x + 1, this.pos.getY() - 1, z, floor, false, true);
                WorldGenPrimitive.fillRectSolid(world, this.rand, x - 1, this.pos.getY() - 1, z, x + 1, this.pos.getY() - 1, z, bridgeBlocks, true, false);
                continue;
            }
            WorldGenPrimitive.fillRectSolid(world, this.rand, x, this.pos.getY(), z - 1, x, this.pos.getY() + 2, z + 1, air, false, true);
            WorldGenPrimitive.fillRectSolid(world, this.rand, x, this.pos.getY() - 1, z - 2, x, this.pos.getY() + 4, z + 2, wallBlocks, false, true);
            WorldGenPrimitive.fillRectSolid(world, this.rand, x, this.pos.getY() - 1, z - 1, x, this.pos.getY() - 1, z + 1, floor, false, true);
            WorldGenPrimitive.fillRectSolid(world, this.rand, x, this.pos.getY() - 1, z - 1, x, this.pos.getY() - 1, z + 1, bridgeBlocks, true, false);
        }
        Coord location = this.tunnel.get(this.tunnel.size() - 1);
        location.add(this.dir, 1);
        Coord start = new Coord(location);
        Cardinal[] orth = Cardinal.getOrthogonal(this.dir);
        start.add(orth[0], 2);
        start.add(Cardinal.UP, 2);
        Coord end = new Coord(location);
        end.add(orth[1], 2);
        end.add(Cardinal.DOWN, 2);
        WorldGenPrimitive.fillRectSolid(world, this.rand, start, end, wallBlocks, false, true);
    }

    public void addSegments(World world) {
        for (Coord location : this.tunnel) {
            this.level.getSettings().getSegments().genSegment(world, this.rand, this.level, this.dir, location);
        }
    }
}

