/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.dungeon.room;

import greymerk.roguelike.catacomb.dungeon.DungeonBase;
import greymerk.roguelike.catacomb.settings.CatacombLevelSettings;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.treasure.TreasureChest;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.Spawner;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class DungeonsPrison
extends DungeonBase {
    World world;
    Random rand;
    IBlockFactory blocks;
    IBlockFactory pillar;
    CatacombLevelSettings settings;

    @Override
    public boolean generate(World inWorld, Random inRandom, CatacombLevelSettings settings, Cardinal[] entrances, Coord origin) {
        int x = origin.getX();
        int y = origin.getY();
        int z = origin.getZ();
        ITheme theme = settings.getTheme();
        this.settings = settings;
        this.world = inWorld;
        this.rand = inRandom;
        this.blocks = theme.getPrimaryWall();
        this.pillar = theme.getPrimaryPillar();
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        WorldGenPrimitive.fillRectSolid(inWorld, this.rand, x - 7, y, z - 7, x + 7, y + 3, z + 7, air);
        WorldGenPrimitive.fillRectHollow(this.world, this.rand, x - 8, y - 1, z - 8, x + 8, y + 5, z + 8, this.blocks, false, true);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, x - 7, y + 3, z - 2, x + 7, y + 3, z - 2, this.blocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, x - 7, y + 3, z + 2, x + 7, y + 3, z + 2, this.blocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, x - 2, y + 3, z - 7, x - 2, y + 3, z + 7, this.blocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, x + 2, y + 3, z - 7, x + 2, y + 3, z + 7, this.blocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, x - 7, y + 4, z - 1, x - 2, y + 4, z + 1, this.blocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, x + 2, y + 4, z - 1, x + 7, y + 4, z + 1, this.blocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, x - 1, y + 4, z - 7, x + 1, y + 4, z - 2, this.blocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, x - 1, y + 4, z + 2, x + 1, y + 4, z + 7, this.blocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, x - 1, y + 4, z - 1, x + 1, y + 4, z + 1, this.blocks);
        this.createCell(x - 5, y, z - 5);
        this.createCell(x - 5, y, z + 5);
        this.createCell(x + 5, y, z - 5);
        this.createCell(x + 5, y, z + 5);
        return false;
    }

    private void createCell(int inX, int inY, int inZ) {
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 3, inY - 1, inZ - 3, inX + 3, inY - 1, inZ + 3, this.blocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 1, inY - 1, inZ - 1, inX + 1, inY - 1, inZ + 1, new MetaBlock(Blocks.field_150341_Y));
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 2, inY, inZ - 2, inX - 2, inY + 2, inZ - 2, this.pillar);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 2, inY, inZ + 2, inX - 2, inY + 2, inZ + 2, this.pillar);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX + 2, inY, inZ - 2, inX + 2, inY + 2, inZ - 2, this.pillar);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX + 2, inY, inZ + 2, inX + 2, inY + 2, inZ + 2, this.pillar);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 3, inY + 3, inZ - 3, inX + 3, inY + 6, inZ + 3, this.blocks);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 1, inY + 4, inZ - 2, inX + 1, inY + 4, inZ - 2, air);
        WorldGenPrimitive.setBlock(this.world, inX, inY + 4, inZ - 2, Blocks.field_150429_aA);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 1, inY + 4, inZ + 2, inX + 1, inY + 4, inZ + 2, air);
        WorldGenPrimitive.setBlock(this.world, inX, inY + 4, inZ + 2, Blocks.field_150429_aA);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 2, inY + 4, inZ - 1, inX - 2, inY + 4, inZ + 1, air);
        WorldGenPrimitive.setBlock(this.world, inX - 2, inY + 4, inZ, Blocks.field_150429_aA);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX + 2, inY + 4, inZ - 1, inX + 2, inY + 4, inZ + 1, air);
        WorldGenPrimitive.setBlock(this.world, inX + 2, inY + 4, inZ, Blocks.field_150429_aA);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX, inY + 3, inZ, inX, inY + 6, inZ, air);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 1, inY + 3, inZ - 1, inX - 1, inY + 6, inZ - 1, air);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 1, inY + 3, inZ + 1, inX - 1, inY + 6, inZ + 1, air);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX + 1, inY + 3, inZ - 1, inX + 1, inY + 6, inZ - 1, air);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX + 1, inY + 3, inZ + 1, inX + 1, inY + 6, inZ + 1, air);
        MetaBlock bars = new MetaBlock(Blocks.field_150411_aY);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 1, inY, inZ - 2, inX + 1, inY + 2, inZ - 2, bars);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX, inY, inZ - 2, inX, inY + 1, inZ - 2, air);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 1, inY, inZ + 2, inX + 1, inY + 2, inZ + 2, bars);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX, inY, inZ + 2, inX, inY + 1, inZ + 2, air);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 2, inY, inZ - 1, inX - 2, inY + 2, inZ + 1, bars);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX - 2, inY, inZ, inX - 2, inY + 1, inZ, air);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX + 2, inY, inZ - 1, inX + 2, inY + 2, inZ + 1, bars);
        WorldGenPrimitive.fillRectSolid(this.world, this.rand, inX + 2, inY, inZ, inX + 2, inY + 1, inZ, air);
        if (this.rand.nextBoolean()) {
            switch (this.rand.nextInt(4)) {
                case 0: {
                    Spawner.generate(this.world, this.rand, this.settings, new Coord(inX - 2, inY + 4, inZ - 2), Spawner.ZOMBIE);
                    break;
                }
                case 1: {
                    Spawner.generate(this.world, this.rand, this.settings, new Coord(inX - 2, inY + 4, inZ + 2), Spawner.ZOMBIE);
                    break;
                }
                case 2: {
                    Spawner.generate(this.world, this.rand, this.settings, new Coord(inX + 2, inY + 4, inZ - 2), Spawner.ZOMBIE);
                    break;
                }
                case 3: {
                    Spawner.generate(this.world, this.rand, this.settings, new Coord(inX + 2, inY + 4, inZ + 2), Spawner.ZOMBIE);
                }
            }
        }
        if (this.rand.nextBoolean()) {
            TreasureChest.generate(this.world, this.rand, this.settings, new Coord(inX, inY, inZ));
        }
    }

    @Override
    public int getSize() {
        return 10;
    }
}

