/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.segment.part;

import greymerk.roguelike.catacomb.CatacombLevel;
import greymerk.roguelike.catacomb.dungeon.SecretFactory;
import greymerk.roguelike.catacomb.segment.part.SegmentBase;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Door;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class SegmentSewerDoor
extends SegmentBase {
    @Override
    protected void genWall(World world, Random rand, CatacombLevel level, Cardinal dir, ITheme theme, int x, int y, int z) {
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        MetaBlock stair = theme.getSecondaryStair();
        MetaBlock bars = new MetaBlock(Blocks.field_150411_aY);
        MetaBlock water = new MetaBlock((Block)Blocks.field_150358_i);
        MetaBlock leaves = new MetaBlock((Block)Blocks.field_150362_t, 4);
        MetaBlock glowstone = new MetaBlock(Blocks.field_150426_aN);
        Cardinal[] orth = Cardinal.getOrthogonal(dir);
        Coord cursor = new Coord(x, y, z);
        cursor.add(Cardinal.DOWN);
        bars.setBlock(world, cursor);
        Coord start = new Coord(cursor);
        Coord end = new Coord(start);
        start.add(orth[0]);
        end.add(orth[1]);
        WorldGenPrimitive.blockOrientation(stair, orth[0], true).setBlock(world, start);
        WorldGenPrimitive.blockOrientation(stair, orth[1], true).setBlock(world, end);
        cursor = new Coord(x, y, z);
        cursor.add(Cardinal.DOWN);
        bars.setBlock(world, cursor);
        start.add(Cardinal.DOWN);
        end.add(Cardinal.DOWN);
        WorldGenPrimitive.fillRectSolid(world, rand, start, end, water, true, true);
        cursor = new Coord(x, y, z);
        cursor.add(Cardinal.UP, 3);
        bars.setBlock(world, cursor);
        cursor.add(Cardinal.UP);
        WorldGenPrimitive.setBlock(world, rand, cursor, leaves, false, true);
        cursor.add(dir);
        WorldGenPrimitive.setBlock(world, rand, cursor, water, false, true);
        cursor.add(dir);
        WorldGenPrimitive.setBlock(world, rand, cursor, glowstone, false, true);
        cursor = new Coord(x, y, z);
        cursor.add(dir, 2);
        start = new Coord(cursor);
        start.add(orth[0], 1);
        end = new Coord(cursor);
        end.add(orth[1], 1);
        end.add(Cardinal.UP, 2);
        WorldGenPrimitive.fillRectSolid(world, rand, start, end, air, true, true);
        SecretFactory secrets = level.getSettings().getSecrets();
        boolean room = secrets.genRoom(world, rand, level.getSettings(), dir, new Coord(x, y, z));
        start.add(dir, 1);
        end.add(dir, 1);
        WorldGenPrimitive.fillRectSolid(world, rand, start, end, theme.getSecondaryWall(), false, true);
        cursor.add(Cardinal.UP, 2);
        for (Cardinal d : orth) {
            Coord c = new Coord(cursor);
            c.add(d, 1);
            stair.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.reverse(d), true));
            WorldGenPrimitive.setBlock(world, rand, c, stair, true, true);
        }
        if (room) {
            cursor = new Coord(x, y, z);
            cursor.add(dir, 3);
            Door.generate(world, cursor, Cardinal.reverse(dir), Door.IRON);
        }
    }
}

