/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.settings.builtin;

import greymerk.roguelike.catacomb.dungeon.Dungeon;
import greymerk.roguelike.catacomb.dungeon.DungeonFactory;
import greymerk.roguelike.catacomb.settings.CatacombLevelSettings;
import greymerk.roguelike.catacomb.settings.CatacombSettings;
import greymerk.roguelike.catacomb.settings.CatacombTowerSettings;
import greymerk.roguelike.catacomb.settings.SpawnCriteria;
import greymerk.roguelike.catacomb.theme.Theme;
import greymerk.roguelike.catacomb.tower.Tower;
import greymerk.roguelike.treasure.loot.Loot;
import greymerk.roguelike.treasure.loot.LootSettings;
import greymerk.roguelike.treasure.loot.WeightedRandomLoot;
import greymerk.roguelike.util.WeightedRandomizer;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.BiomeDictionary;

public class CatacombSettingsWitchTheme
extends CatacombSettings {
    public CatacombSettingsWitchTheme() {
        this.depth = 2;
        this.criteria = new SpawnCriteria();
        ArrayList<BiomeDictionary.Type> biomes = new ArrayList<BiomeDictionary.Type>();
        biomes.add(BiomeDictionary.Type.SWAMP);
        this.criteria.setBiomeTypes(biomes);
        this.towerSettings = new CatacombTowerSettings(Tower.WITCH, Theme.getTheme(Theme.DARKOAK));
        Theme[] themes = new Theme[]{Theme.DARKHALL, Theme.MUDDY, Theme.MOSSY, Theme.MOSSY, Theme.NETHER};
        for (int i = 0; i < 5; ++i) {
            DungeonFactory factory;
            CatacombLevelSettings level = new CatacombLevelSettings();
            level.setTheme(Theme.getTheme(themes[i]));
            if (i == 0) {
                level.setDifficulty(1);
                factory = new DungeonFactory();
                factory.addRandom(Dungeon.BRICK, 5);
                factory.addRandom(Dungeon.CORNER, 5);
                factory.addRandom(Dungeon.DARKHALL, 1);
                factory.addSingle(Dungeon.LIBRARY);
                factory.addSingle(Dungeon.FIRE);
                level.setRooms(factory);
            }
            if (i == 1) {
                level.setDifficulty(2);
                factory = new DungeonFactory();
                factory.addRandom(Dungeon.BRICK, 5);
                factory.addRandom(Dungeon.CORNER, 5);
                factory.addRandom(Dungeon.PIT, 2);
                factory.addSingle(Dungeon.PRISON);
                factory.addRandom(Dungeon.LAB, 2);
                factory.addRandom(Dungeon.SPIDER, 3);
                level.setRooms(factory);
            }
            LootSettings loot = new LootSettings(2);
            WeightedRandomizer<ItemStack> junk = new WeightedRandomizer<ItemStack>();
            junk.add(new WeightedRandomLoot(Items.field_151073_bk, 1));
            junk.add(new WeightedRandomLoot(Items.field_151065_br, 3));
            junk.add(new WeightedRandomLoot(Items.field_151170_bI, 5));
            junk.add(new WeightedRandomLoot((Block)Blocks.field_150337_Q, 5));
            junk.add(new WeightedRandomLoot((Block)Blocks.field_150338_P, 5));
            junk.add(new WeightedRandomLoot(Items.field_151055_y, 10));
            junk.add(new WeightedRandomLoot(Items.field_151072_bj, 1));
            junk.add(new WeightedRandomLoot(Items.field_151102_aT, 8));
            junk.add(new WeightedRandomLoot(Items.field_151075_bm, 1));
            junk.add(new WeightedRandomLoot(Items.field_151064_bs, 2));
            junk.add(new WeightedRandomLoot(Items.field_151120_aE, 1));
            junk.add(new WeightedRandomLoot(Items.field_151016_H, 3));
            junk.add(new WeightedRandomLoot(Items.field_151069_bo, 8));
            junk.add(new WeightedRandomLoot(Items.field_151137_ax, 0, 1, 3, 5));
            loot.set(Loot.JUNK, junk);
            level.setLoot(loot);
            this.levels.put(i, level);
        }
    }
}

