/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.theme;

import com.google.gson.JsonObject;
import greymerk.roguelike.catacomb.theme.BlockSet;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.catacomb.theme.ThemeBase;
import greymerk.roguelike.catacomb.theme.ThemeBling;
import greymerk.roguelike.catacomb.theme.ThemeBrick;
import greymerk.roguelike.catacomb.theme.ThemeCave;
import greymerk.roguelike.catacomb.theme.ThemeChecker;
import greymerk.roguelike.catacomb.theme.ThemeCrypt;
import greymerk.roguelike.catacomb.theme.ThemeDarkHall;
import greymerk.roguelike.catacomb.theme.ThemeDarkOak;
import greymerk.roguelike.catacomb.theme.ThemeEnder;
import greymerk.roguelike.catacomb.theme.ThemeEniIce;
import greymerk.roguelike.catacomb.theme.ThemeEniQuartz;
import greymerk.roguelike.catacomb.theme.ThemeEniko;
import greymerk.roguelike.catacomb.theme.ThemeEniko2;
import greymerk.roguelike.catacomb.theme.ThemeEtho;
import greymerk.roguelike.catacomb.theme.ThemeEthoTower;
import greymerk.roguelike.catacomb.theme.ThemeIce;
import greymerk.roguelike.catacomb.theme.ThemeJungle;
import greymerk.roguelike.catacomb.theme.ThemeMineShaft;
import greymerk.roguelike.catacomb.theme.ThemeMossy;
import greymerk.roguelike.catacomb.theme.ThemeMuddy;
import greymerk.roguelike.catacomb.theme.ThemeNether;
import greymerk.roguelike.catacomb.theme.ThemeOak;
import greymerk.roguelike.catacomb.theme.ThemePyramid;
import greymerk.roguelike.catacomb.theme.ThemeQuartz;
import greymerk.roguelike.catacomb.theme.ThemeRainbow;
import greymerk.roguelike.catacomb.theme.ThemeSandstone;
import greymerk.roguelike.catacomb.theme.ThemeSewer;
import greymerk.roguelike.catacomb.theme.ThemeSnow;
import greymerk.roguelike.catacomb.theme.ThemeSpruce;
import greymerk.roguelike.catacomb.theme.ThemeTower;

public enum Theme {
    OAK,
    SPRUCE,
    CRYPT,
    MOSSY,
    MUDDY,
    NETHER,
    SANDSTONE,
    QUARTZ,
    BLING,
    CHECKER,
    RAINBOW,
    SNOW,
    JUNGLE,
    BRICK,
    DARKOAK,
    ICE,
    ENIKO,
    ENIKO2,
    ENIQUARTZ,
    ENIICE,
    TOWER,
    ETHO,
    CAVE,
    SEWER,
    ENDER,
    MINESHAFT,
    ETHOTOWER,
    PYRAMID,
    DARKHALL;


    public static ITheme getTheme(Theme type) {
        ThemeBase theme;
        switch (type) {
            case OAK: {
                theme = new ThemeOak();
                break;
            }
            case SPRUCE: {
                theme = new ThemeSpruce();
                break;
            }
            case CRYPT: {
                theme = new ThemeCrypt();
                break;
            }
            case MOSSY: {
                theme = new ThemeMossy();
                break;
            }
            case MUDDY: {
                theme = new ThemeMuddy();
                break;
            }
            case NETHER: {
                theme = new ThemeNether();
                break;
            }
            case SANDSTONE: {
                theme = new ThemeSandstone();
                break;
            }
            case QUARTZ: {
                theme = new ThemeQuartz();
                break;
            }
            case BLING: {
                theme = new ThemeBling();
                break;
            }
            case CHECKER: {
                theme = new ThemeChecker();
                break;
            }
            case RAINBOW: {
                theme = new ThemeRainbow();
                break;
            }
            case SNOW: {
                theme = new ThemeSnow();
                break;
            }
            case JUNGLE: {
                theme = new ThemeJungle();
                break;
            }
            case BRICK: {
                theme = new ThemeBrick();
                break;
            }
            case DARKOAK: {
                theme = new ThemeDarkOak();
                break;
            }
            case ICE: {
                theme = new ThemeIce();
                break;
            }
            case ENIKO: {
                theme = new ThemeEniko();
                break;
            }
            case ENIKO2: {
                theme = new ThemeEniko2();
                break;
            }
            case ENIQUARTZ: {
                theme = new ThemeEniQuartz();
                break;
            }
            case ENIICE: {
                theme = new ThemeEniIce();
                break;
            }
            case TOWER: {
                theme = new ThemeTower();
                break;
            }
            case ETHO: {
                theme = new ThemeEtho();
                break;
            }
            case CAVE: {
                theme = new ThemeCave();
                break;
            }
            case SEWER: {
                theme = new ThemeSewer();
                break;
            }
            case ENDER: {
                theme = new ThemeEnder();
                break;
            }
            case MINESHAFT: {
                theme = new ThemeMineShaft();
                break;
            }
            case ETHOTOWER: {
                theme = new ThemeEthoTower();
                break;
            }
            case PYRAMID: {
                theme = new ThemePyramid();
                break;
            }
            case DARKHALL: {
                theme = new ThemeDarkHall();
                break;
            }
            default: {
                return null;
            }
        }
        return theme;
    }

    public static ITheme create(JsonObject json) {
        JsonObject data;
        BlockSet primary = null;
        BlockSet secondary = null;
        if (json.has("primary")) {
            data = json.get("primary").getAsJsonObject();
            primary = new BlockSet(data);
        }
        if (json.has("secondary")) {
            data = json.get("secondary").getAsJsonObject();
            secondary = new BlockSet(data);
        }
        if (json.has("base")) {
            ITheme theme = Theme.getTheme(Theme.valueOf(json.get("base").getAsString()));
            return new ThemeBase((ThemeBase)theme, primary, secondary);
        }
        ThemeOak theme = new ThemeOak();
        return new ThemeBase(theme, primary, secondary);
    }
}

