/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.tower;

import greymerk.roguelike.catacomb.tower.EniTower;
import greymerk.roguelike.catacomb.tower.EthoTower;
import greymerk.roguelike.catacomb.tower.ITower;
import greymerk.roguelike.catacomb.tower.JungleTower;
import greymerk.roguelike.catacomb.tower.PyramidTower;
import greymerk.roguelike.catacomb.tower.RogueTower;
import greymerk.roguelike.catacomb.tower.WitchTower;
import greymerk.roguelike.worldgen.Coord;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public enum Tower {
    ROGUE,
    ENIKO,
    ETHO,
    PYRAMID,
    JUNGLE,
    WITCH;


    public static ITower get(Tower type) {
        switch (type) {
            case ROGUE: {
                return new RogueTower();
            }
            case ENIKO: {
                return new EniTower();
            }
            case ETHO: {
                return new EthoTower();
            }
            case PYRAMID: {
                return new PyramidTower();
            }
            case JUNGLE: {
                return new JungleTower();
            }
            case WITCH: {
                return new WitchTower();
            }
        }
        return new RogueTower();
    }

    public static Coord getBaseCoord(World world, int x, int y, int z) {
        ArrayList<Object> invalidBlocks = new ArrayList<Object>();
        invalidBlocks.add(Blocks.field_150350_a);
        invalidBlocks.add(Blocks.field_150364_r);
        invalidBlocks.add(Blocks.field_150363_s);
        invalidBlocks.add(Blocks.field_150362_t);
        invalidBlocks.add(Blocks.field_150361_u);
        invalidBlocks.add(Blocks.field_150434_aF);
        invalidBlocks.add(Blocks.field_150436_aH);
        invalidBlocks.add(Blocks.field_150395_bd);
        invalidBlocks.add(Blocks.field_150433_aE);
        invalidBlocks.add(Blocks.field_150431_aC);
        invalidBlocks.add(Blocks.field_150375_by);
        int tempY = 128;
        Block block = world.func_147439_a(x, tempY, z);
        while (tempY > 60 && invalidBlocks.indexOf(block) != -1) {
            block = world.func_147439_a(x, --tempY, z);
        }
        int yOffset = tempY - y;
        if (yOffset < 14) {
            yOffset = 14;
        }
        return new Coord(x, y + yOffset, z);
    }
}

