/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure;

import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.treasure.InventorySlot;
import greymerk.roguelike.treasure.TreasureChestBase;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.Loot;
import greymerk.roguelike.treasure.loot.LootSettings;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.provider.ItemSpecialty;
import java.util.Iterator;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntityChest;

public class TreasureChestStarter
extends TreasureChestBase {
    private ItemStack getStarterLoot(LootSettings loot, int choice) {
        if (!RogueConfig.getBoolean(RogueConfig.GENEROUS)) {
            return loot.get(Loot.JUNK, this.rand);
        }
        switch (choice) {
            case 4: {
                return loot.get(Loot.TOOL, this.rand);
            }
            case 3: {
                return loot.get(Loot.WEAPON, this.rand);
            }
            case 2: {
                return loot.get(Loot.FOOD, this.rand);
            }
            case 1: {
                if (!RogueConfig.getBoolean(RogueConfig.GENEROUS)) break;
                return ItemSpecialty.getRandomItem(Equipment.LEGS, this.rand, Quality.WOOD);
            }
        }
        return new ItemStack(Blocks.field_150478_aa, 1 + this.rand.nextInt(RogueConfig.getBoolean(RogueConfig.GENEROUS) ? 7 : 3));
    }

    @Override
    protected void fillChest(TileEntityChest chest, LootSettings loot, int level) {
        int quantity = RogueConfig.getBoolean(RogueConfig.GENEROUS) ? 8 : 4;
        Iterator<InventorySlot> itr = this.iterator();
        for (int i = 0; i < quantity; ++i) {
            ItemStack item = this.getStarterLoot(loot, i % 5);
            if (!itr.hasNext()) continue;
            itr.next().set(item);
        }
        if (itr.hasNext()) {
            itr.next().set(this.book());
        }
    }

    private ItemStack book() {
        ItemStack book = new ItemStack(Items.field_151164_bB);
        book.func_77983_a("author", (NBTBase)new NBTTagString("Greymerk"));
        book.func_77983_a("title", (NBTBase)new NBTTagString("Collective Nouns"));
        String page1 = "Stumble of Zombies\nRattle of Skeletons\nClutter of Spiders\nGrief of Creepers\n\n- Greymerk\n";
        String page2 = "Roguelike Dungeons v1.3.6.3\nMar 17th 2015\n\nCredits\n\nAuthor: Greymerk\n\nBits: Drainedsoul\n\nIdeas: Eniko @enichan";
        NBTTagList pages = new NBTTagList();
        pages.func_74742_a((NBTBase)new NBTTagString(page1));
        pages.func_74742_a((NBTBase)new NBTTagString(page2));
        book.func_77983_a("pages", (NBTBase)pages);
        return book;
    }
}

