/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.MetaBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.world.World;

public enum FlowerPot {
    DANDELION,
    POPPY,
    ORCHID,
    ALLIUM,
    BLUET,
    REDTULIP,
    ORANGETULIP,
    WHITETULIP,
    PINKTULIP,
    DAISY,
    REDMUSHROOM,
    BROWNMUSHROOM,
    CACTUS,
    OAK,
    BIRCH,
    SPRUCE,
    JUNGLE,
    ACACIA,
    DARKOAK,
    SHRUB,
    FERN;


    public static void generate(World world, Coord pos, FlowerPot type) {
        MetaBlock pot = new MetaBlock(Blocks.field_150457_bL);
        if (!pot.setBlock(world, pos)) {
            return;
        }
        TileEntity potEntity = world.func_147438_o(pos.getX(), pos.getY(), pos.getZ());
        if (potEntity == null) {
            return;
        }
        if (!(potEntity instanceof TileEntityFlowerPot)) {
            return;
        }
        TileEntityFlowerPot flower = (TileEntityFlowerPot)potEntity;
        FlowerPot.setData(flower, type);
    }

    public static void generate(World world, Random rand, Coord pos) {
        FlowerPot choice = FlowerPot.values()[rand.nextInt(FlowerPot.values().length)];
        FlowerPot.generate(world, pos, choice);
    }

    public static void setData(TileEntityFlowerPot pot, FlowerPot type) {
        switch (type) {
            case DANDELION: {
                pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150327_N), 0);
                return;
            }
            case POPPY: {
                pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150328_O), 0);
                return;
            }
            case ORCHID: {
                pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150328_O), 1);
                return;
            }
            case ALLIUM: {
                pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150328_O), 2);
                return;
            }
            case BLUET: {
                pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150328_O), 3);
                return;
            }
            case REDTULIP: {
                pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150328_O), 4);
                return;
            }
            case ORANGETULIP: {
                pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150328_O), 5);
                return;
            }
            case WHITETULIP: {
                pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150328_O), 6);
                return;
            }
            case PINKTULIP: {
                pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150328_O), 7);
                return;
            }
            case DAISY: {
                pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150328_O), 8);
                return;
            }
            case REDMUSHROOM: {
                pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150337_Q), 0);
                return;
            }
            case BROWNMUSHROOM: {
                pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150338_P), 0);
                return;
            }
            case CACTUS: {
                pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150434_aF), 0);
                return;
            }
            case OAK: {
                pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150345_g), 0);
                return;
            }
            case SPRUCE: {
                pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150345_g), 1);
                return;
            }
            case BIRCH: {
                pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150345_g), 2);
                return;
            }
            case JUNGLE: {
                pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150345_g), 3);
                return;
            }
            case ACACIA: {
                pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150345_g), 4);
                return;
            }
            case DARKOAK: {
                pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150345_g), 5);
                return;
            }
            case SHRUB: {
                pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150329_H), 0);
                return;
            }
            case FERN: {
                pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150329_H), 2);
                return;
            }
        }
        pot.func_145964_a(Item.func_150898_a((Block)Blocks.field_150327_N), 0);
    }

    public static ItemStack getFlowerItem(FlowerPot type) {
        switch (type) {
            case DANDELION: {
                return new ItemStack((Block)Blocks.field_150327_N);
            }
            case POPPY: {
                return new ItemStack((Block)Blocks.field_150328_O, 0);
            }
            case ORCHID: {
                return new ItemStack((Block)Blocks.field_150328_O, 1);
            }
            case ALLIUM: {
                return new ItemStack((Block)Blocks.field_150328_O, 2);
            }
            case BLUET: {
                return new ItemStack((Block)Blocks.field_150328_O, 3);
            }
            case REDTULIP: {
                return new ItemStack((Block)Blocks.field_150328_O, 4);
            }
            case ORANGETULIP: {
                return new ItemStack((Block)Blocks.field_150328_O, 5);
            }
            case WHITETULIP: {
                return new ItemStack((Block)Blocks.field_150328_O, 6);
            }
            case PINKTULIP: {
                return new ItemStack((Block)Blocks.field_150328_O, 7);
            }
            case DAISY: {
                return new ItemStack((Block)Blocks.field_150328_O, 8);
            }
            case REDMUSHROOM: {
                return new ItemStack((Block)Blocks.field_150337_Q);
            }
            case BROWNMUSHROOM: {
                return new ItemStack((Block)Blocks.field_150338_P);
            }
            case CACTUS: {
                return new ItemStack(Blocks.field_150434_aF);
            }
            case OAK: {
                return new ItemStack(Blocks.field_150345_g, 0);
            }
            case SPRUCE: {
                return new ItemStack(Blocks.field_150345_g, 1);
            }
            case BIRCH: {
                return new ItemStack(Blocks.field_150345_g, 2);
            }
            case JUNGLE: {
                return new ItemStack(Blocks.field_150345_g, 3);
            }
            case ACACIA: {
                return new ItemStack(Blocks.field_150345_g, 4);
            }
            case DARKOAK: {
                return new ItemStack(Blocks.field_150345_g, 5);
            }
            case SHRUB: {
                return new ItemStack((Block)Blocks.field_150329_H, 0);
            }
            case FERN: {
                return new ItemStack((Block)Blocks.field_150329_H, 2);
            }
        }
        return new ItemStack((Block)Blocks.field_150327_N);
    }
}

