/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.GameRegistry;
import glenn.gasesframework.api.GasesFrameworkAPI;
import glenn.gasesframework.api.IGasesFramework;
import glenn.gasesframework.api.ItemKey;
import glenn.gasesframework.api.gastype.GasType;
import glenn.gasesframework.api.gasworldgentype.GasWorldGenType;
import glenn.gasesframework.api.lanterntype.LanternType;
import glenn.gasesframework.api.mechanical.IGasTransposerHandler;
import glenn.gasesframework.common.CommonProxy;
import glenn.gasesframework.common.ConfigGasFurnaceRecipes;
import glenn.gasesframework.common.GasBottleTransposerHandler;
import glenn.gasesframework.common.GasesFrameworkMainConfigurations;
import glenn.gasesframework.common.GuiHandler;
import glenn.gasesframework.common.block.BlockGas;
import glenn.gasesframework.common.block.BlockGasCollector;
import glenn.gasesframework.common.block.BlockGasFurnace;
import glenn.gasesframework.common.block.BlockGasPipe;
import glenn.gasesframework.common.block.BlockGasPump;
import glenn.gasesframework.common.block.BlockGasTank;
import glenn.gasesframework.common.block.BlockGasTransposer;
import glenn.gasesframework.common.block.BlockInfiniteGasDrain;
import glenn.gasesframework.common.block.BlockInfiniteGasPump;
import glenn.gasesframework.common.block.BlockLantern;
import glenn.gasesframework.common.item.ItemGasBottle;
import glenn.gasesframework.common.item.ItemGasPipe;
import glenn.gasesframework.common.item.ItemGasSampler;
import glenn.gasesframework.common.reaction.ReactionIgnition;
import glenn.gasesframework.common.tileentity.TileEntityGasCollector;
import glenn.gasesframework.common.tileentity.TileEntityGasFurnace;
import glenn.gasesframework.common.tileentity.TileEntityGasPump;
import glenn.gasesframework.common.tileentity.TileEntityGasTank;
import glenn.gasesframework.common.tileentity.TileEntityGasTransposer;
import glenn.gasesframework.common.tileentity.TileEntityInfiniteGasDrain;
import glenn.gasesframework.common.tileentity.TileEntityInfiniteGasPump;
import glenn.gasesframework.common.worldgen.WorldGeneratorGasesFramework;
import glenn.gasesframework.network.message.MessageGasEffects;
import glenn.gasesframework.network.message.MessageSetTransposerMode;
import glenn.gasesframework.waila.GasesFrameworkWaila;
import java.io.File;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@Mod(modid="gasesFramework", name="Gases Framework", version="1.1.2", dependencies="required-after:gasesFrameworkCore", acceptedMinecraftVersions="[1.7.10]")
public class GasesFramework
implements IGasesFramework {
    @Mod.Instance(value="gasesFramework")
    public static GasesFramework instance;
    @SidedProxy(clientSide="glenn.gasesframework.client.ClientProxy", serverSide="glenn.gasesframework.server.ServerProxy")
    public static CommonProxy proxy;
    public static final String MODID = "gasesFramework";
    public static final String VERSION = "1.1.2";
    public static final String TARGETVERSION = "1.7.10";
    public static final GuiHandler guiHandler;
    public static SimpleNetworkWrapper networkWrapper;
    public static GasesFrameworkMainConfigurations configurations;
    public static final WorldGeneratorGasesFramework worldGenerator;
    public static Block gasPump;
    public static Block gasTank;
    public static Block gasCollector;
    public static Block gasFurnaceIdle;
    public static Block gasFurnaceActive;
    public static Block infiniteGasPump;
    public static Block infiniteGasDrain;
    public static Block gasTransposer;

    private void initBlocksAndItems() {
        GasesFrameworkAPI.gasBottle = new ItemGasBottle().func_77655_b("gf_gasBottle").func_77637_a(GasesFrameworkAPI.creativeTab).func_111206_d("gasesframework:gas_bottle");
        GameRegistry.registerItem((Item)GasesFrameworkAPI.gasBottle, (String)"gasBottle");
        GasesFrameworkAPI.gasSamplerIncluder = new ItemGasSampler(false).func_77655_b("gf_gasSamplerIncluder").func_77637_a(GasesFrameworkAPI.creativeTab).func_111206_d("gasesframework:sampler");
        GameRegistry.registerItem((Item)GasesFrameworkAPI.gasSamplerIncluder, (String)"gasSamplerIncluder");
        GasesFrameworkAPI.gasSamplerExcluder = new ItemGasSampler(true).func_77655_b("gf_gasSamplerExcluder").func_77637_a(GasesFrameworkAPI.creativeTab).func_111206_d("gasesframework:sampler");
        GameRegistry.registerItem((Item)GasesFrameworkAPI.gasSamplerExcluder, (String)"gasSamplerExcluder");
        gasPump = new BlockGasPump(true).func_149711_c(2.5f).func_149672_a(Block.field_149769_e).func_149647_a(GasesFrameworkAPI.creativeTab).func_149663_c("gf_gasPump").func_149658_d("gasesframework:pump");
        GameRegistry.registerBlock((Block)gasPump, (String)"gasPump");
        gasTank = new BlockGasTank().func_149711_c(3.5f).func_149672_a(Block.field_149769_e).func_149647_a(GasesFrameworkAPI.creativeTab).func_149663_c("gf_gasTank").func_149658_d("gasesframework:tank");
        GameRegistry.registerBlock((Block)gasTank, (String)"gasTank");
        gasCollector = new BlockGasCollector().func_149711_c(2.5f).func_149672_a(Block.field_149769_e).func_149647_a(GasesFrameworkAPI.creativeTab).func_149663_c("gf_gasCollector").func_149658_d("gasesframework:collector");
        GameRegistry.registerBlock((Block)gasCollector, (String)"gasCollector");
        gasFurnaceIdle = new BlockGasFurnace(false).func_149711_c(3.5f).func_149672_a(Block.field_149769_e).func_149663_c("gf_gasFurnace").func_149647_a(GasesFrameworkAPI.creativeTab).func_149658_d("gasesframework:gas_furnace");
        GameRegistry.registerBlock((Block)gasFurnaceIdle, (String)"gasFurnaceIdle");
        gasFurnaceActive = new BlockGasFurnace(true).func_149711_c(3.5f).func_149672_a(Block.field_149769_e).func_149715_a(0.25f).func_149663_c("gf_gasFurnaceWarm").func_149658_d("gasesframework:gas_furnace");
        GameRegistry.registerBlock((Block)gasFurnaceActive, (String)"gasFurnaceActive");
        infiniteGasPump = new BlockInfiniteGasPump().func_149711_c(-1.0f).func_149663_c("gf_infiniteGasPump").func_149647_a(GasesFrameworkAPI.creativeTab).func_149658_d("gasesframework:pump_infinite");
        GameRegistry.registerBlock((Block)infiniteGasPump, (String)"infiniteGasPump");
        infiniteGasDrain = new BlockInfiniteGasDrain().func_149711_c(-1.0f).func_149663_c("gf_infiniteGasDrain").func_149647_a(GasesFrameworkAPI.creativeTab).func_149658_d("gasesframework:drain");
        GameRegistry.registerBlock((Block)infiniteGasDrain, (String)"infiniteGasDrain");
        gasTransposer = new BlockGasTransposer().func_149711_c(2.5f).func_149663_c("gf_gasTransposer").func_149647_a(GasesFrameworkAPI.creativeTab).func_149658_d("gasesframework:transposer");
        GameRegistry.registerBlock((Block)gasTransposer, (String)"gasTransposer");
        GasesFrameworkAPI.registerLanternType(GasesFrameworkAPI.lanternTypeEmpty, GasesFrameworkAPI.creativeTab);
        for (int i = 0; i < GasesFrameworkAPI.lanternTypesGas.length; ++i) {
            GasesFrameworkAPI.registerLanternType(GasesFrameworkAPI.lanternTypesGas[i]);
        }
        GasesFrameworkAPI.registerGasType(GasesFrameworkAPI.gasTypeAir);
        GasesFrameworkAPI.registerGasType(GasesFrameworkAPI.gasTypeSmoke, GasesFrameworkAPI.creativeTab);
        GasesFrameworkAPI.registerGasType(GasesFrameworkAPI.gasTypeFire, GasesFrameworkAPI.creativeTab);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        proxy.registerMessage(MessageGasEffects.Handler.class, MessageGasEffects.class, 0);
        proxy.registerMessage(MessageSetTransposerMode.Handler.class, MessageSetTransposerMode.class, 1);
        GasesFrameworkAPI.modInstance = instance;
        GasesFrameworkAPI.creativeTab = new CreativeTabs("tabGases"){

            public Item func_78016_d() {
                return Item.func_150898_a((Block)GasesFrameworkAPI.lanternTypeEmpty.block);
            }
        };
        this.initBlocksAndItems();
        configurations = new GasesFrameworkMainConfigurations(event.getSuggestedConfigurationFile());
        ConfigGasFurnaceRecipes.load(new File(event.getModConfigurationDirectory().getAbsolutePath() + "/gasesframework_GasFurnaceRecipes.json"));
        GasesFrameworkAPI.registerIgnitionBlock(Blocks.field_150478_aa);
        GasesFrameworkAPI.registerIgnitionBlock((Block)Blocks.field_150480_ab);
        GasesFrameworkAPI.registerIgnitionBlock(GasesFrameworkAPI.gasTypeFire.block);
        proxy.registerEventHandlers();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.registerRenderers();
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldGenerator, (int)10);
        GameRegistry.addRecipe((ItemStack)new ItemStack(GasesFrameworkAPI.lanternTypeEmpty.block, 4), (Object[])new Object[]{"I", "G", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('G'), Blocks.field_150359_w});
        GameRegistry.addRecipe((ItemStack)new ItemStack(GasesFrameworkAPI.gasTypeAir.pipeBlock, 24), (Object[])new Object[]{"III", Character.valueOf('I'), Items.field_151042_j});
        GameRegistry.addRecipe((ItemStack)new ItemStack(GasesFrameworkAPI.gasTypeAir.pipeBlock, 24, 1), (Object[])new Object[]{"GGG", "III", "GGG", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('G'), Blocks.field_150410_aZ});
        GameRegistry.addRecipe((ItemStack)new ItemStack(gasPump), (Object[])new Object[]{" I ", "PRP", " I ", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('P'), GasesFrameworkAPI.gasTypeAir.pipeBlock, Character.valueOf('R'), Items.field_151137_ax});
        GameRegistry.addRecipe((ItemStack)new ItemStack(gasCollector), (Object[])new Object[]{" P ", "PUP", " P ", Character.valueOf('U'), gasPump, Character.valueOf('P'), GasesFrameworkAPI.gasTypeAir.pipeBlock});
        GameRegistry.addRecipe((ItemStack)new ItemStack(gasTank), (Object[])new Object[]{"IPI", "P P", "IPI", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('P'), GasesFrameworkAPI.gasTypeAir.pipeBlock});
        GameRegistry.addRecipe((ItemStack)new ItemStack(gasFurnaceIdle), (Object[])new Object[]{" I ", "IFI", " I ", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('F'), Blocks.field_150460_al});
        GameRegistry.addRecipe((ItemStack)new ItemStack(gasTransposer), (Object[])new Object[]{" P ", "PHP", " P ", Character.valueOf('P'), GasesFrameworkAPI.gasTypeAir.pipeBlock, Character.valueOf('H'), Blocks.field_150438_bZ});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(GasesFrameworkAPI.gasSamplerExcluder), (Object[])new Object[]{new ItemStack(Items.field_151069_bo), new ItemStack(Items.field_151100_aR, 1, 0)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(GasesFrameworkAPI.gasSamplerIncluder), (Object[])new Object[]{new ItemStack(Items.field_151069_bo), new ItemStack(Items.field_151100_aR, 1, 15)});
        for (LanternType lanternType : LanternType.getAllLanternTypes()) {
            if (lanternType == GasesFrameworkAPI.lanternTypeEmpty) continue;
            for (ItemKey itemIn : lanternType.getAllAcceptedItems()) {
                if (itemIn.item == null) continue;
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(lanternType.block), (Object[])new Object[]{new ItemStack(GasesFrameworkAPI.lanternTypeEmpty.block), new ItemStack(itemIn.item, 1, itemIn.damage)});
            }
        }
        GameRegistry.registerTileEntity(TileEntityGasPump.class, (String)"gasPump");
        GameRegistry.registerTileEntity(TileEntityGasCollector.class, (String)"gasCollector");
        GameRegistry.registerTileEntity(TileEntityGasTank.class, (String)"gasTank");
        GameRegistry.registerTileEntity(TileEntityGasFurnace.class, (String)"gasPoweredFurnace");
        GameRegistry.registerTileEntity(TileEntityInfiniteGasPump.class, (String)"infiniteGasPump");
        GameRegistry.registerTileEntity(TileEntityInfiniteGasDrain.class, (String)"infiniteGasDrain");
        GameRegistry.registerTileEntity(TileEntityGasTransposer.class, (String)"gasTransposer");
        GasesFrameworkAPI.registerReaction(new ReactionIgnition());
        GasesFrameworkAPI.registerGasTransposerHandler(new GasBottleTransposerHandler());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)guiHandler);
        for (String string : GasesFramework.configurations.other_removedIgnitionBlocks) {
            Block block = Block.func_149684_b((String)string);
            if (block == null) continue;
            GasesFrameworkAPI.unregisterIgnitionBlock(block);
        }
        for (String string : GasesFramework.configurations.other_removedIgnitionItems) {
            Item item = (Item)Item.field_150901_e.func_82594_a(string);
            if (item == null) continue;
            GasesFrameworkAPI.unregisterIgnitionItem(item);
        }
        GasesFrameworkWaila.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Item item;
        Block block;
        for (String s : GasesFramework.configurations.other_additionalIgnitionBlocks) {
            block = Block.func_149684_b((String)s);
            if (block == null) continue;
            GasesFrameworkAPI.registerIgnitionBlock(block);
        }
        for (String s : GasesFramework.configurations.other_additionalIgnitionItems) {
            item = (Item)Item.field_150901_e.func_82594_a(s);
            if (item == null) continue;
            GasesFrameworkAPI.registerIgnitionItem(item);
        }
        for (String s : GasesFramework.configurations.other_removedIgnitionBlocks) {
            block = Block.func_149684_b((String)s);
            if (block == null) continue;
            GasesFrameworkAPI.unregisterIgnitionBlock(block);
        }
        for (String s : GasesFramework.configurations.other_removedIgnitionItems) {
            item = (Item)Item.field_150901_e.func_82594_a(s);
            if (item == null) continue;
            GasesFrameworkAPI.unregisterIgnitionItem(item);
        }
    }

    @Override
    public void addSpecialFurnaceRecipe(ItemStack ingredient, ItemStack result, int cookTime, int exp) {
        TileEntityGasFurnace.specialFurnaceRecipes.add(new TileEntityGasFurnace.SpecialFurnaceRecipe(ingredient, result, cookTime));
    }

    @Override
    public boolean canFillWithGas(World world, int x, int y, int z, GasType type) {
        if (type == GasesFrameworkAPI.gasTypeAir) {
            Block block = world.func_147439_a(x, y, z);
            if (block instanceof BlockGas) {
                return world.func_72805_g(x, y, z) > 0;
            }
            return !block.func_149662_c();
        }
        int firstBlockCapacity = GasesFramework.fillCapacity(world, x, y, z, type);
        if (firstBlockCapacity >= 16) {
            return true;
        }
        if (firstBlockCapacity >= 0) {
            int capacity = 0;
            int[] sideCapacity = new int[6];
            for (int side = 0; side < 6; ++side) {
                int zDirection;
                int yDirection;
                if (side == 0 & type.density > 0 | side == 1 & type.density < 0) {
                    sideCapacity[side] = -1;
                    continue;
                }
                int xDirection = x + (side == 4 ? 1 : (side == 5 ? -1 : 0));
                sideCapacity[side] = GasesFramework.fillCapacity(world, xDirection, yDirection = y + (side == 0 ? 1 : (side == 1 ? -1 : 0)), zDirection = z + (side == 2 ? 1 : (side == 3 ? -1 : 0)), type);
                if (sideCapacity[side] <= 0) continue;
                capacity += sideCapacity[side];
            }
            return capacity + firstBlockCapacity >= 16;
        }
        return false;
    }

    @Override
    public boolean fillWithGas(World world, Random random, int x, int y, int z, GasType type) {
        if (type == GasesFrameworkAPI.gasTypeAir) {
            Block block = world.func_147439_a(x, y, z);
            if (block instanceof BlockGas) {
                return world.func_72805_g(x, y, z) > 0;
            }
            return !block.func_149662_c();
        }
        int firstBlockCapacity = GasesFramework.fillCapacity(world, x, y, z, type);
        if (firstBlockCapacity >= 16) {
            GasesFramework.fill(world, x, y, z, type, 16);
            return true;
        }
        if (firstBlockCapacity >= 0) {
            int side;
            int capacity = 0;
            int[] sideCapacity = new int[6];
            for (int side2 = 0; side2 < 6; ++side2) {
                int zDirection;
                int yDirection;
                if (side2 == 0 & type.density > 0 | side2 == 1 & type.density < 0) {
                    sideCapacity[side2] = -1;
                    continue;
                }
                int xDirection = x + (side2 == 4 ? 1 : (side2 == 5 ? -1 : 0));
                sideCapacity[side2] = GasesFramework.fillCapacity(world, xDirection, yDirection = y + (side2 == 0 ? 1 : (side2 == 1 ? -1 : 0)), zDirection = z + (side2 == 2 ? 1 : (side2 == 3 ? -1 : 0)), type);
                if (sideCapacity[side2] <= 0) continue;
                capacity += sideCapacity[side2];
            }
            if (capacity + firstBlockCapacity < 16) {
                return false;
            }
            GasesFramework.fill(world, x, y, z, type, firstBlockCapacity);
            int fill = 0;
            int[] sideFill = new int[6];
            for (side = 0; side < 6; ++side) {
                if (sideCapacity[side] == -1) continue;
                sideFill[side] = sideCapacity[side] * (16 - firstBlockCapacity) / capacity;
                fill += sideFill[side];
            }
            while (fill < 16 - firstBlockCapacity) {
                side = random.nextInt(6);
                if (!(sideFill[side] < sideCapacity[side] & sideCapacity[side] != -1)) continue;
                int n = side;
                sideFill[n] = sideFill[n] + 1;
                ++fill;
            }
            for (side = 0; side < 6; ++side) {
                int xDirection = x + (side == 4 ? 1 : (side == 5 ? -1 : 0));
                int yDirection = y + (side == 0 ? 1 : (side == 1 ? -1 : 0));
                int zDirection = z + (side == 2 ? 1 : (side == 3 ? -1 : 0));
                GasesFramework.fill(world, xDirection, yDirection, zDirection, type, sideFill[side]);
            }
            return true;
        }
        return false;
    }

    private static void fill(World world, int x, int y, int z, GasType type, int amount) {
        if (amount <= 0) {
            return;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block == type.block) {
            int newMetadata = 16 - world.func_72805_g(x, y, z) + amount;
            world.func_72921_c(x, y, z, 16 - newMetadata, 3);
        } else {
            world.func_147465_d(x, y, z, type.block, 16 - amount, 3);
        }
    }

    private static int fillCapacity(World world, int x, int y, int z, GasType type) {
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof BlockGas) {
            if (block == type.block) {
                return world.func_72805_g(x, y, z);
            }
            return -1;
        }
        if (block instanceof BlockLiquid) {
            return -1;
        }
        return block.isReplaceable((IBlockAccess)world, x, y, z) ? 16 : -1;
    }

    @Override
    public void placeGas(World world, int x, int y, int z, GasType type, int volume) {
        if (volume > 0) {
            if (volume > 16) {
                volume = 16;
            }
            world.func_147465_d(x, y, z, type.block, 16 - volume, 3);
        }
    }

    @Override
    public void ignite(World world, int x, int y, int z, Random random) {
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof BlockGas) {
            ((BlockGas)block).onFire(world, x, y, z, random, world.func_72805_g(x, y, z));
        }
    }

    @Override
    public GasType getGasType(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof BlockGas) {
            return ((BlockGas)block).type;
        }
        return null;
    }

    @Override
    public GasType getGasPipeType(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof BlockGasPipe) {
            return ((BlockGasPipe)block).type;
        }
        return null;
    }

    @Override
    public int getGasVolume(World world, int x, int y, int z) {
        return 16 - world.func_72805_g(x, y, z);
    }

    @Override
    public float getGasExplosionPowerFactor() {
        return GasesFramework.configurations.gases_gasExplosionFactor;
    }

    @Override
    public int getFireSmokeAmount() {
        return GasesFramework.configurations.gases_fireSmokeAmount;
    }

    @Override
    public Block registerGasType(GasType type) {
        if (type.isRegistered) {
            throw new RuntimeException("Gas type named " + type.name + " was attempted registered while it was already registered.");
        }
        if (type != GasesFrameworkAPI.gasTypeAir) {
            type.block = GameRegistry.registerBlock((Block)type.tweakGasBlock(new BlockGas(type)), (String)("gas_" + type.name));
            if (type.combustibility.fireSpreadRate >= 0 | type.combustibility.explosionPower > 0.0f) {
                Blocks.field_150480_ab.setFireInfo(type.block, 1000, 1000);
            }
        }
        if (type.isIndustrial) {
            type.pipeBlock = GameRegistry.registerBlock((Block)type.tweakPipeBlock(new BlockGasPipe(type)), ItemGasPipe.class, (String)("gasPipe_" + type.name));
            LanternType lanternType = GasesFrameworkAPI.lanternTypesGas[type.combustibility.burnRate];
            if (lanternType != GasesFrameworkAPI.lanternTypeGasEmpty) {
                lanternType.addItemIn(new ItemKey(GasesFrameworkAPI.gasBottle, type.gasID));
            }
        }
        type.isRegistered = true;
        return type.block;
    }

    @Override
    public Block registerGasType(GasType type, CreativeTabs creativeTab) {
        Block result = this.registerGasType(type);
        if (result != null) {
            result.func_149647_a(creativeTab);
        }
        return result;
    }

    @Override
    public Block registerLanternType(LanternType type) {
        if (type.isRegistered) {
            throw new RuntimeException("Lantern type named " + type.name + " was attempted registered while it was already registered.");
        }
        type.block = GameRegistry.registerBlock((Block)type.tweakLanternBlock(new BlockLantern(type)), (String)("lantern_" + type.name));
        type.isRegistered = true;
        return type.block;
    }

    @Override
    public Block registerLanternType(LanternType type, CreativeTabs creativeTab) {
        Block result = this.registerLanternType(type);
        if (result != null) {
            result.func_149647_a(creativeTab);
        }
        return result;
    }

    @Override
    public void registerGasWorldGenType(GasWorldGenType type, String[] dimensionNames) {
        if (type.generationFrequency > 0.0f) {
            for (String dimensionName : dimensionNames) {
                worldGenerator.registerGasWorldGenType(type, dimensionName);
            }
        }
    }

    @Override
    public void registerGasTransposerHandler(IGasTransposerHandler handler) {
        TileEntityGasTransposer.registerHandler(handler);
    }

    static {
        guiHandler = new GuiHandler();
        networkWrapper = new SimpleNetworkWrapper(MODID);
        worldGenerator = new WorldGeneratorGasesFramework();
    }
}

