/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import glenn.gasesframework.GasesFramework;
import glenn.gasesframework.api.GasesFrameworkAPI;
import glenn.gasesframework.api.block.IGasReceptor;
import glenn.gasesframework.common.block.BlockGasFurnace;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityGasFurnace
extends TileEntity
implements ISidedInventory {
    private static final int[] slots_top_sides = new int[]{0};
    private static final int[] slots_bottom = new int[]{1};
    public static final ArrayList<SpecialFurnaceRecipe> specialFurnaceRecipes = new ArrayList();
    private ItemStack[] furnaceItemStacks = new ItemStack[2];
    public int furnaceBurnTime;
    public int furnaceCookTime = 0;
    public int furnaceCookSpeed = 0;
    public int smokeTimer = 0;
    private String invName;
    public int prevStage;
    public static final int maxFurnaceBurnTime = 1000;
    public static final int maxFurnaceCookSpeed = 8000;

    public int func_70302_i_() {
        return this.furnaceItemStacks.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.furnaceItemStacks[par1];
    }

    public static SpecialFurnaceRecipe getSpecialFurnaceRecipe(ItemStack itemStack) {
        for (SpecialFurnaceRecipe recipe : specialFurnaceRecipes) {
            if (!recipe.is(itemStack)) continue;
            return recipe;
        }
        return null;
    }

    public int getCurrentItemBurnTime() {
        if (this.furnaceItemStacks[0] == null) {
            return 200;
        }
        SpecialFurnaceRecipe recipe = TileEntityGasFurnace.getSpecialFurnaceRecipe(this.furnaceItemStacks[0]);
        if (recipe != null) {
            return recipe.cookTime;
        }
        return 200;
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.furnaceItemStacks[par1] != null) {
            if (this.furnaceItemStacks[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.furnaceItemStacks[par1];
                this.furnaceItemStacks[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.furnaceItemStacks[par1].func_77979_a(par2);
            if (this.furnaceItemStacks[par1].field_77994_a == 0) {
                this.furnaceItemStacks[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.furnaceItemStacks[par1] != null) {
            ItemStack itemstack = this.furnaceItemStacks[par1];
            this.furnaceItemStacks[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.furnaceItemStacks[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.invName : "container.gasFurnace";
    }

    public boolean func_145818_k_() {
        return this.invName != null && this.invName.length() > 0;
    }

    public void setGuiDisplayName(String par1Str) {
        this.invName = par1Str;
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("Items", 10);
        this.furnaceItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.furnaceItemStacks.length) continue;
            this.furnaceItemStacks[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.furnaceBurnTime = par1NBTTagCompound.func_74765_d("BurnTime");
        this.furnaceCookTime = par1NBTTagCompound.func_74765_d("CookTime");
        this.furnaceCookSpeed = par1NBTTagCompound.func_74765_d("CookSpeed");
        if (par1NBTTagCompound.func_74764_b("SmokeTimer")) {
            this.smokeTimer = par1NBTTagCompound.func_74765_d("SmokeTimer");
        }
        if (par1NBTTagCompound.func_74764_b("CustomName")) {
            this.invName = par1NBTTagCompound.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        par1NBTTagCompound.func_74777_a("CookTime", (short)this.furnaceCookTime);
        par1NBTTagCompound.func_74777_a("CookSpeed", (short)this.furnaceCookSpeed);
        par1NBTTagCompound.func_74777_a("SmokeTimer", (short)this.smokeTimer);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.furnaceItemStacks.length; ++i) {
            if (this.furnaceItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.furnaceItemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            par1NBTTagCompound.func_74778_a("CustomName", this.invName);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int par1) {
        return this.furnaceCookTime * par1 / (this.getCurrentItemBurnTime() * 1000);
    }

    public boolean isBurning() {
        return this.furnaceCookSpeed > 0;
    }

    public void handleSmoke() {
        if (this.isBurning() && this.smokeTimer++ > 100) {
            if (GasesFrameworkAPI.fillWithGas(this.field_145850_b, this.field_145850_b.field_73012_v, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, GasesFrameworkAPI.gasTypeSmoke)) {
                this.smokeTimer = 0;
            } else {
                Block blockAbove = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                if (blockAbove instanceof IGasReceptor && ((IGasReceptor)blockAbove).receiveGas(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, ForgeDirection.DOWN, GasesFrameworkAPI.gasTypeSmoke)) {
                    this.smokeTimer = 0;
                }
            }
        }
    }

    public int getStage() {
        return (int)Math.ceil(4.0 * (double)this.furnaceCookSpeed / 8000.0);
    }

    public void func_145845_h() {
        int stage = this.getStage();
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            this.handleSmoke();
            if (this.smokeTimer <= 150 && this.canSmelt()) {
                this.furnaceCookTime += this.furnaceCookSpeed;
                if (this.furnaceCookTime >= this.getCurrentItemBurnTime() * 1000) {
                    this.furnaceCookTime -= this.getCurrentItemBurnTime() * 1000;
                    this.smeltItem();
                    flag1 = true;
                }
            }
            if (this.prevStage != stage) {
                flag1 = true;
                BlockGasFurnace.updateFurnaceBlockState(stage, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (!this.canSmelt()) {
            this.furnaceCookTime = 0;
        }
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
            this.furnaceCookSpeed += GasesFramework.configurations.other_gasFurnaceHeatingSpeed;
        } else {
            this.furnaceCookSpeed -= GasesFramework.configurations.other_gasFurnaceHeatingSpeed;
        }
        if (this.furnaceCookSpeed < 0) {
            this.furnaceCookSpeed = 0;
        } else if (this.furnaceCookSpeed > 8000) {
            this.furnaceCookSpeed = 8000;
        }
        if (flag1) {
            this.func_70296_d();
        }
        if (this.prevStage != stage) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.prevStage = stage;
    }

    public boolean canSmelt() {
        if (this.furnaceItemStacks[0] == null) {
            return false;
        }
        ItemStack itemstack = null;
        SpecialFurnaceRecipe recipe = TileEntityGasFurnace.getSpecialFurnaceRecipe(this.furnaceItemStacks[0]);
        if (recipe != null) {
            itemstack = recipe.result;
        }
        if (itemstack == null) {
            itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.furnaceItemStacks[0]);
        }
        if (itemstack != null) {
            if (this.furnaceItemStacks[1] == null) {
                return true;
            }
            if (!this.furnaceItemStacks[1].func_77969_a(itemstack)) {
                return false;
            }
            int result = this.furnaceItemStacks[1].field_77994_a + itemstack.field_77994_a;
            return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
        }
        return false;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.furnaceItemStacks[0]);
            if (itemstack == null) {
                SpecialFurnaceRecipe recipe = TileEntityGasFurnace.getSpecialFurnaceRecipe(this.furnaceItemStacks[0]);
                itemstack = recipe.result;
                if (this.furnaceItemStacks[1] == null) {
                    this.furnaceItemStacks[1] = itemstack.func_77946_l();
                } else if (this.furnaceItemStacks[1].func_77969_a(itemstack)) {
                    this.furnaceItemStacks[1].field_77994_a += itemstack.field_77994_a;
                }
                this.furnaceItemStacks[0].field_77994_a -= recipe.ingredient.field_77994_a;
                if (this.furnaceItemStacks[0].field_77994_a <= 0) {
                    this.furnaceItemStacks[0] = null;
                }
            } else {
                if (this.furnaceItemStacks[1] == null) {
                    this.furnaceItemStacks[1] = itemstack.func_77946_l();
                } else if (this.furnaceItemStacks[1].func_77969_a(itemstack)) {
                    this.furnaceItemStacks[1].field_77994_a += itemstack.field_77994_a;
                }
                --this.furnaceItemStacks[0].field_77994_a;
                if (this.furnaceItemStacks[0].field_77994_a <= 0) {
                    this.furnaceItemStacks[0] = null;
                }
            }
        }
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return par1 == 0;
    }

    public int[] func_94128_d(int par1) {
        return par1 == 0 ? slots_bottom : slots_top_sides;
    }

    public boolean func_102007_a(int par1, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    public boolean func_102008_b(int par1, ItemStack par2ItemStack, int par3) {
        return par1 != 0;
    }

    public Packet func_145844_m() {
        NBTTagCompound localNBTTagCompound = new NBTTagCompound();
        this.func_145841_b(localNBTTagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, localNBTTagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public static class SpecialFurnaceRecipe {
        public final ItemStack ingredient;
        public final ItemStack result;
        public final int cookTime;

        public SpecialFurnaceRecipe(ItemStack ingredient, ItemStack result, int cookTime) {
            this.ingredient = ingredient;
            this.result = result;
            this.cookTime = cookTime;
        }

        public boolean is(ItemStack itemStack) {
            return itemStack.func_77973_b() == this.ingredient.func_77973_b() & itemStack.func_77960_j() == this.ingredient.func_77960_j() & itemStack.field_77994_a >= this.ingredient.field_77994_a;
        }
    }
}

