/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.util;

import glenn.gasesframework.api.GasesFrameworkAPI;
import glenn.gasesframework.api.block.IGasInterface;
import glenn.gasesframework.api.block.IGasPropellor;
import glenn.gasesframework.api.block.IGasReceptor;
import glenn.gasesframework.common.block.BlockGasPipe;
import glenn.gasesframework.util.PipeBranch;
import glenn.moddingutils.IVec;
import glenn.moddingutils.KeyVec;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class PipeSearch {
    private static final IVec[] offsets = new IVec[]{new IVec(0, -1, 0), new IVec(0, 1, 0), new IVec(0, 0, -1), new IVec(0, 0, 1), new IVec(-1, 0, 0), new IVec(1, 0, 0)};
    public PipeBranch root;

    protected void search(World world, int x, int y, int z, int maxDepth) {
        HashMap<KeyVec, PipeBranch> branchMap = new HashMap<KeyVec, PipeBranch>();
        ArrayList<PipeBranch> top = new ArrayList<PipeBranch>();
        if (world.func_147439_a(x, y, z) instanceof BlockGasPipe) {
            this.root = PipeBranch.makeRoot(x, y, z, branchMap);
            top.add(this.root);
        }
        for (int depth = 1; depth <= maxDepth && !top.isEmpty(); ++depth) {
            ArrayList<PipeBranch> newTop = new ArrayList<PipeBranch>();
            for (PipeBranch branch : top) {
                IVec pos = branch.getPosition();
                BlockGasPipe pipeBlock = (BlockGasPipe)world.func_147439_a(pos.x, pos.y, pos.z);
                int connectionCount = 0;
                int lastConnection = -1;
                for (int i = 0; i < 6; ++i) {
                    ForgeDirection direction = ForgeDirection.getOrientation((int)i);
                    PipeBranch connection = branch.connections[i];
                    IVec connectionPos = pos.added(offsets[i]);
                    if (connection == null) {
                        Block directionBlock = world.func_147439_a(connectionPos.x, connectionPos.y, connectionPos.z);
                        if (directionBlock instanceof BlockGasPipe) {
                            connection = new PipeBranch(depth, branchMap, connectionPos);
                            newTop.add(connection);
                        } else {
                            this.inspectConnection(branch, world, connectionPos, pipeBlock, direction);
                        }
                        if (!(directionBlock instanceof IGasInterface) || !((IGasInterface)directionBlock).connectToPipe((IBlockAccess)world, connectionPos.x, connectionPos.y, connectionPos.z, direction.getOpposite())) continue;
                        ++connectionCount;
                        lastConnection = i;
                        continue;
                    }
                    ++connectionCount;
                    lastConnection = i;
                }
                if (connectionCount != true) continue;
                ForgeDirection direction = ForgeDirection.getOrientation((int)lastConnection).getOpposite();
                IVec looseConnectionPos = pos.added(new IVec(direction.offsetX, direction.offsetY, direction.offsetZ));
                this.inspectLooseEnd(branch, world, looseConnectionPos, pipeBlock, direction);
            }
            top = newTop;
        }
    }

    protected abstract void inspectConnection(PipeBranch var1, World var2, IVec var3, BlockGasPipe var4, ForgeDirection var5);

    protected void inspectLooseEnd(PipeBranch branch, World world, IVec looseConnectionPos, BlockGasPipe pipeBlock, ForgeDirection direction) {
    }

    public static class PropellorSearch
    extends PipeSearch {
        public final ArrayList<PipeEnd> propellors = new ArrayList();

        public PropellorSearch(World world, int x, int y, int z, int maxDepth) {
            this.search(world, x, y, z, maxDepth);
        }

        @Override
        protected void inspectConnection(PipeBranch branch, World world, IVec connectionPos, BlockGasPipe pipeBlock, ForgeDirection direction) {
            IGasPropellor gasPropellor;
            Block directionBlock = world.func_147439_a(connectionPos.x, connectionPos.y, connectionPos.z);
            if (directionBlock instanceof IGasPropellor && (gasPropellor = (IGasPropellor)directionBlock).canPropelGasFromSide(world, connectionPos.x, connectionPos.y, connectionPos.z, direction.getOpposite())) {
                this.propellors.add(new PipeEnd(branch, connectionPos, direction.getOpposite()));
            }
        }
    }

    public static class ReceptorSearch
    extends PipeSearch {
        public final ArrayList<PipeEnd> looseEnds = new ArrayList();
        public final ArrayList<PipeEnd> ends = new ArrayList();

        public ReceptorSearch(World world, int x, int y, int z, int maxDepth) {
            this.search(world, x, y, z, maxDepth);
        }

        @Override
        protected void inspectConnection(PipeBranch branch, World world, IVec connectionPos, BlockGasPipe pipeBlock, ForgeDirection direction) {
            IGasReceptor gasReceptor;
            Block directionBlock = world.func_147439_a(connectionPos.x, connectionPos.y, connectionPos.z);
            if (IGasReceptor.class.isAssignableFrom(directionBlock.getClass()) && (gasReceptor = (IGasReceptor)directionBlock).canReceiveGas(world, connectionPos.x, connectionPos.y, connectionPos.z, direction.getOpposite(), pipeBlock.type)) {
                this.ends.add(new PipeEnd(branch, connectionPos, direction));
            }
        }

        @Override
        protected void inspectLooseEnd(PipeBranch branch, World world, IVec looseConnectionPos, BlockGasPipe pipeBlock, ForgeDirection direction) {
            if (GasesFrameworkAPI.canFillWithGas(world, looseConnectionPos.x, looseConnectionPos.y, looseConnectionPos.z, pipeBlock.type)) {
                this.looseEnds.add(new PipeEnd(branch, looseConnectionPos, direction));
            }
        }
    }

    public static class PipeEnd {
        public final PipeBranch branch;
        public final IVec endPosition;
        public final ForgeDirection endDirection;

        protected PipeEnd(PipeBranch branch, IVec endPosition, ForgeDirection endDirection) {
            this.branch = branch;
            this.endPosition = endPosition;
            this.endDirection = endDirection;
        }
    }
}

