/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.forge;

import CoroUtil.config.ConfigCoroAI;
import CoroUtil.diplomacy.TeamTypes;
import CoroUtil.forge.CommandCoroUtil;
import CoroUtil.forge.CommonProxy;
import CoroUtil.forge.EventHandlerFML;
import CoroUtil.forge.EventHandlerForge;
import CoroUtil.forge.EventHandlerPacket;
import CoroUtil.pets.PetsManager;
import CoroUtil.quest.PlayerQuestManager;
import CoroUtil.util.CoroUtilFile;
import CoroUtil.world.WorldDirectorManager;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.NetworkRegistry;
import modconfig.ConfigMod;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="CoroAI", name="CoroAI", version="v1.0")
public class CoroAI {
    @Mod.Instance(value="CoroAI")
    public static CoroAI instance;
    public static String modID;
    @SidedProxy(clientSide="CoroUtil.forge.ClientProxy", serverSide="CoroUtil.forge.CommonProxy")
    public static CommonProxy proxy;
    public static boolean initProperNeededForInstance;
    public static String eventChannelName;
    public static final FMLEventChannel eventChannel;
    public static PetsManager petsManager;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigMod.addConfigFile(event, "coroai", new ConfigCoroAI());
        eventChannel.register((Object)new EventHandlerPacket());
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)new EventHandlerFML());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerForge());
        proxy.init(this);
        TeamTypes.initTypes();
        petsManager = new PetsManager();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandCoroUtil());
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
        CoroAI.writeOutData(true);
        initProperNeededForInstance = true;
    }

    public static void initTry() {
        if (initProperNeededForInstance) {
            System.out.println("CoroUtil being reinitialized");
            initProperNeededForInstance = false;
            CoroUtilFile.getWorldFolderName();
            petsManager.nbtReadFromDisk();
            WorldDirectorManager.instance().reset();
        }
    }

    public static void writeOutData(boolean unloadInstances) {
        try {
            petsManager.nbtWriteToDisk();
            if (unloadInstances) {
                petsManager.reset();
            }
            PlayerQuestManager.i().saveData(false, unloadInstances);
            WorldDirectorManager.instance().writeToFile(unloadInstances);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void dbg(Object obj) {
    }

    static {
        modID = "coroutil";
        initProperNeededForInstance = true;
        eventChannelName = "coroutil";
        eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(eventChannelName);
    }
}

