/*
 * Decompiled with CFR 0.152.
 */
package com.drullkus.thermalsmeltery.common.lib;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraftforge.fluids.Fluid;

public class FluidType {
    public final Block renderBlock;
    public final int renderMeta;
    public final int baseTemperature;
    public final Fluid fluid;
    public final boolean isToolpart;
    public static HashMap<String, FluidType> fluidTypes = new HashMap();

    public FluidType(Block block, int meta, int baseTemperature, Fluid fluid, boolean isToolpart) {
        this.renderBlock = block;
        this.renderMeta = meta;
        this.baseTemperature = baseTemperature;
        this.fluid = fluid;
        this.isToolpart = isToolpart;
    }

    public static void registerFluidType(String name, FluidType type) {
        fluidTypes.put(name, type);
    }

    public static void registerFluidType(String name, Block block, int meta, int baseTemperature, Fluid fluid, boolean isToolpart) {
        FluidType type = new FluidType(block, meta, baseTemperature, fluid, isToolpart);
        FluidType.registerFluidType(name, type);
    }

    public static FluidType getFluidType(String typeName) {
        return fluidTypes.get(typeName);
    }

    public static FluidType getFluidType(Fluid inputFluid) {
        for (Map.Entry<String, FluidType> pairs : fluidTypes.entrySet()) {
            if (!pairs.getValue().fluid.equals(inputFluid)) continue;
            return pairs.getValue();
        }
        return null;
    }

    public static int getTemperatureByFluid(Fluid searchedFluid) {
        for (Map.Entry<String, FluidType> pairs : fluidTypes.entrySet()) {
            if (!pairs.getValue().fluid.equals(searchedFluid)) continue;
            return pairs.getValue().baseTemperature;
        }
        return 800;
    }
}

