/*
 * Decompiled with CFR 0.152.
 */
package com.drullkus.thermalsmeltery.common.plugins.eio.smeltery;

import com.drullkus.thermalsmeltery.ThermalSmeltery;
import com.drullkus.thermalsmeltery.common.lib.TSmeltFluid;
import com.drullkus.thermalsmeltery.common.plugins.eio.smeltery.EnderIOSmeltery;
import com.drullkus.thermalsmeltery.common.plugins.eio.smeltery.FilledBucket;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidHelper {
    public static Fluid registerFluid(String name) {
        return FluidHelper.registerFluid(name, "liquid_" + name);
    }

    public static Fluid registerFluid(String name, String texture) {
        return FluidHelper.registerFluid(name, name, "fluid.molten." + name, texture, 3000, 6000, 1300, Material.field_151587_i);
    }

    public static Fluid registerFluid(String name, String fluidName, String blockName, String texture, int density, int viscosity, int temperature, Material material) {
        Fluid fluid = new Fluid(fluidName).setDensity(density).setViscosity(viscosity).setTemperature(temperature);
        if (material == Material.field_151587_i) {
            fluid.setLuminosity(12);
        }
        boolean isFluidPreRegistered = !FluidRegistry.registerFluid((Fluid)fluid);
        TSmeltFluid block = new TSmeltFluid(fluid, material, texture);
        block.func_149663_c(blockName);
        GameRegistry.registerBlock((Block)block, (String)blockName);
        fluid.setBlock((Block)block);
        block.setFluid(fluid);
        if (isFluidPreRegistered) {
            fluid = FluidRegistry.getFluid((String)fluidName);
            if (fluid.getBlock() != null) {
                block.suppressOverwritingFluidIcons();
            } else {
                fluid.setBlock((Block)block);
            }
        }
        if (FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(fluid, 1000), (ItemStack)new ItemStack(Items.field_151133_ar)) == null) {
            boolean reg = false;
            for (int i = 0; i < FilledBucket.textureNames.length; ++i) {
                if (!FilledBucket.materialNames[i].equals(name)) continue;
                FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(fluid, 1000), new ItemStack(EnderIOSmeltery.buckets, 1, i), new ItemStack(Items.field_151133_ar)));
                reg = true;
            }
            if (!reg) {
                ThermalSmeltery.logger.error("Couldn't register fluid container for " + name);
            }
        }
        return fluid;
    }
}

