/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.addons.jewelrycraft;

import cpw.mods.fml.common.Loader;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.util.Utilities;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class AddonJewelrycraftTiles
implements IWailaDataProvider {
    private static String showMoltenAmount = "wawla.jewelrycraft.showMoltenAmount";
    private static String showMetalAmount = "wawla.jewelrycraft.showMetalAmount";
    private static String showMeltTime = "wawla.jewelrycraft.showMeltTime";
    private static String showCooling = "wawla.jewelrycraft.showCooling";
    public static Class classTileEntitySmelter = null;
    public static Class classTileEntityMolder = null;

    public AddonJewelrycraftTiles() {
        if (Loader.isModLoaded((String)"Jewelrycraft2")) {
            try {
                classTileEntitySmelter = Class.forName("darkknight.jewelrycraft.tileentity.TileEntitySmelter");
                classTileEntityMolder = Class.forName("darkknight.jewelrycraft.tileentity.TileEntityMolder");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    public ItemStack getWailaStack(IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return data.getStack();
    }

    public List<String> getWailaHead(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public List<String> getWailaBody(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        if (data.getBlock() != null && data.getTileEntity() != null) {
            if (Utilities.compareTileEntityByClass(data.getTileEntity(), classTileEntitySmelter)) {
                NBTTagCompound moltenTag;
                if (data.getNBTData().func_74767_n("hasMoltenMetal")) {
                    moltenTag = data.getNBTData().func_74775_l("moltenMetal");
                    ItemStack moltenStack = this.getMetalStack(moltenTag);
                    if (cfg.getConfig(showMoltenAmount)) {
                        tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.jewelry.molten") + ": " + moltenStack.func_82833_r() + " X " + Utilities.round(data.getNBTData().func_74760_g("quantity") * 10.0f, 2));
                    }
                }
                if (data.getNBTData().func_74767_n("hasMetal")) {
                    moltenTag = data.getNBTData().func_74775_l("metal");
                    ItemStack metalStack = this.getMetalStack(moltenTag);
                    if (cfg.getConfig(showMetalAmount)) {
                        tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.jewelry.unmelted") + ": " + metalStack.func_82833_r() + " X " + metalStack.field_77994_a);
                    }
                    if (cfg.getConfig(showMeltTime)) {
                        tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.jewelry.melttime") + ": " + data.getNBTData().func_74762_e("melting") / 20 + " " + StatCollector.func_74838_a((String)"tooltip.wawla.seconds"));
                    }
                }
            }
            if (Utilities.compareTileEntityByClass(data.getTileEntity(), classTileEntityMolder) && cfg.getConfig(showCooling) && data.getNBTData().func_74762_e("cooling") > 0) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.jewelry.cooling") + ": " + data.getNBTData().func_74762_e("cooling") / 20 + " " + StatCollector.func_74838_a((String)"tooltip.wawla.seconds"));
            }
        }
        return tip;
    }

    public ItemStack getMetalStack(NBTTagCompound metalTag) {
        return new ItemStack(Item.func_150899_d((int)metalTag.func_74765_d("id")), (int)metalTag.func_74771_c("Count"), (int)metalTag.func_74765_d("Damage"));
    }

    public List<String> getWailaTail(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te != null) {
            te.func_145841_b(tag);
        }
        return tag;
    }

    public static void registerAddon(IWailaRegistrar register) {
        AddonJewelrycraftTiles dataProvider = new AddonJewelrycraftTiles();
        register.addConfig("Jewelrycraft", showMoltenAmount);
        register.addConfig("Jewelrycraft", showMetalAmount);
        register.addConfig("Jewelrycraft", showMeltTime);
        register.addConfig("Jewelrycraft", showCooling);
        register.registerBodyProvider((IWailaDataProvider)dataProvider, classTileEntitySmelter);
        register.registerNBTProvider((IWailaDataProvider)dataProvider, classTileEntitySmelter);
        register.registerBodyProvider((IWailaDataProvider)dataProvider, classTileEntityMolder);
        register.registerNBTProvider((IWailaDataProvider)dataProvider, classTileEntityMolder);
    }
}

