/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;

public final class StringHelper {
    public static final String BLACK = "\u00a70";
    public static final String BLUE = "\u00a71";
    public static final String GREEN = "\u00a72";
    public static final String TEAL = "\u00a73";
    public static final String RED = "\u00a74";
    public static final String PURPLE = "\u00a75";
    public static final String ORANGE = "\u00a76";
    public static final String LIGHT_GRAY = "\u00a77";
    public static final String GRAY = "\u00a78";
    public static final String LIGHT_BLUE = "\u00a79";
    public static final String BRIGHT_GREEN = "\u00a7a";
    public static final String BRIGHT_BLUE = "\u00a7b";
    public static final String LIGHT_RED = "\u00a7c";
    public static final String PINK = "\u00a7d";
    public static final String YELLOW = "\u00a7e";
    public static final String WHITE = "\u00a7f";
    public static final String OBFUSCATED = "\u00a7k";
    public static final String BOLD = "\u00a7l";
    public static final String STRIKETHROUGH = "\u00a7m";
    public static final String UNDERLINE = "\u00a7n";
    public static final String ITALIC = "\u00a7o";
    public static final String END = "\u00a7r";
    public static final String[] ROMAN_NUMERAL = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
    public static boolean displayShiftForDetail = true;
    public static boolean displayStackCount = false;

    private StringHelper() {
    }

    public static boolean isAltKeyDown() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }

    public static boolean isControlKeyDown() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static int getSplitStringHeight(FontRenderer fontRenderer, String input, int width) {
        List stringRows = fontRenderer.func_78271_c(input, width);
        return stringRows.size() * fontRenderer.field_78288_b;
    }

    public static String camelCase(String input) {
        return input.substring(0, 1).toLowerCase() + input.substring(1);
    }

    public static String titleCase(String input) {
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    public static String localize(String key) {
        return StatCollector.func_74838_a((String)key);
    }

    public static String getFluidName(FluidStack stack) {
        Fluid fluid = stack.getFluid();
        String name = END;
        if (fluid.getRarity() == EnumRarity.uncommon) {
            name = name + YELLOW;
        } else if (fluid.getRarity() == EnumRarity.rare) {
            name = name + BRIGHT_BLUE;
        } else if (fluid.getRarity() == EnumRarity.epic) {
            name = name + PINK;
        }
        name = name + fluid.getLocalizedName(stack) + END;
        return name;
    }

    public static String getFluidName(FluidStack stack, String defaultName) {
        if (stack == null) {
            return defaultName;
        }
        return StringHelper.getFluidName(stack);
    }

    public static String getItemName(ItemStack stack) {
        String name = END;
        if (stack.func_77953_t() == EnumRarity.uncommon) {
            name = name + YELLOW;
        } else if (stack.func_77953_t() == EnumRarity.rare) {
            name = name + BRIGHT_BLUE;
        } else if (stack.func_77953_t() == EnumRarity.epic) {
            name = name + PINK;
        }
        name = name + stack.func_82833_r() + END;
        return name;
    }

    public static String getScaledNumber(long number) {
        if (number >= 1000000000L) {
            return number / 1000000000L + "." + number % 1000000000L / 10000000L + "G";
        }
        if (number >= 1000000L) {
            return number / 1000000L + "." + number % 1000000L / 10000L + "M";
        }
        if (number >= 1000L) {
            return number / 1000L + "." + number % 1000L / 10L + "k";
        }
        return String.valueOf(number);
    }

    @Deprecated
    public static String getScaledNumber(long number, int minDigits) {
        return StringHelper.getScaledNumber(number);
    }

    public static String getActivationText(String key) {
        return BRIGHT_BLUE + StringHelper.localize(key) + END;
    }

    public static String getDeactivationText(String key) {
        return YELLOW + StringHelper.localize(key) + END;
    }

    public static String getInfoText(String key) {
        return BRIGHT_GREEN + StringHelper.localize(key) + END;
    }

    public static String getFlavorText(String key) {
        return "\u00a77\u00a7o" + StringHelper.localize(key) + END;
    }

    public static String getRarity(int level) {
        switch (level) {
            case 2: {
                return YELLOW;
            }
            case 3: {
                return BRIGHT_BLUE;
            }
        }
        return LIGHT_GRAY;
    }

    public static String shiftForDetails() {
        return LIGHT_GRAY + StringHelper.localize("info.cofh.hold") + " " + YELLOW + ITALIC + StringHelper.localize("info.cofh.shift") + " " + END + LIGHT_GRAY + StringHelper.localize("info.cofh.forDetails") + END;
    }

    public static String tutorialTabAugment() {
        return StringHelper.localize("info.cofh.tutorial.tabAugment");
    }

    public static String tutorialTabConfiguration() {
        return StringHelper.localize("info.cofh.tutorial.tabConfiguration.0");
    }

    public static String tutorialTabOperation() {
        return StringHelper.localize("info.cofh.tutorial.tabConfiguration.1");
    }

    public static String tutorialTabRedstone() {
        return StringHelper.localize("info.cofh.tutorial.tabRedstone");
    }

    public static String tutorialTabSecurity() {
        return StringHelper.localize("info.cofh.tutorial.tabSecurity");
    }

    public static String tutorialTabFluxRequired() {
        return StringHelper.localize("info.cofh.tutorial.fluxRequired");
    }
}

