/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenMinableCluster;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenSmallTree
extends WorldGenerator {
    private final List<WeightedRandomBlock> leaves;
    private final List<WeightedRandomBlock> trunk;
    private final WeightedRandomBlock[] genBlock;
    public WeightedRandomBlock[] genSurface = null;
    public int minHeight = 5;
    public int heightVariance = 3;
    public boolean treeChecks = true;
    public boolean relaxedGrowth = false;
    public boolean waterLoving = false;

    public WorldGenSmallTree(List<WeightedRandomBlock> resource, List<WeightedRandomBlock> leaf, List<WeightedRandomBlock> block) {
        this.trunk = resource;
        this.leaves = leaf;
        this.genBlock = block.toArray(new WeightedRandomBlock[block.size()]);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int worldHeight;
        int treeHeight = (this.heightVariance <= 1 ? 0 : rand.nextInt(this.heightVariance)) + this.minHeight;
        if (y + treeHeight + 1 <= (worldHeight = world.func_72800_K())) {
            if (!WorldGenMinableCluster.canGenerateInBlock(world, x, y - 1, z, this.genSurface)) {
                return false;
            }
            if (y < worldHeight - treeHeight - 1) {
                int zOffset;
                int xOffset;
                Block block;
                int yOffset;
                if (this.treeChecks) {
                    for (yOffset = y; yOffset <= y + 1 + treeHeight; ++yOffset) {
                        int radius = yOffset >= y + 1 + treeHeight - 2 ? 2 : (this.relaxedGrowth ? 0 : 1);
                        if (yOffset >= 0 & yOffset < worldHeight) {
                            if (radius == 0) {
                                block = world.func_147439_a(x, yOffset, z);
                                if (!(block.isLeaves((IBlockAccess)world, x, yOffset, z) || block.isAir((IBlockAccess)world, x, yOffset, z) || block.isReplaceable((IBlockAccess)world, x, yOffset, z) || block.canBeReplacedByLeaves((IBlockAccess)world, x, yOffset, z))) {
                                    return false;
                                }
                                if (this.waterLoving || yOffset < y + 1) continue;
                                radius = 1;
                                for (xOffset = x - radius; xOffset <= x + radius; ++xOffset) {
                                    for (zOffset = z - radius; zOffset <= z + radius; ++zOffset) {
                                        block = world.func_147439_a(xOffset, yOffset, zOffset);
                                        if (!block.func_149688_o().func_76224_d()) continue;
                                        return false;
                                    }
                                }
                                continue;
                            }
                            for (xOffset = x - radius; xOffset <= x + radius; ++xOffset) {
                                for (zOffset = z - radius; zOffset <= z + radius; ++zOffset) {
                                    block = world.func_147439_a(xOffset, yOffset, zOffset);
                                    if (block.isLeaves((IBlockAccess)world, xOffset, yOffset, zOffset) || block.isAir((IBlockAccess)world, xOffset, yOffset, zOffset) || block.canBeReplacedByLeaves((IBlockAccess)world, xOffset, yOffset, zOffset)) continue;
                                    return false;
                                }
                            }
                            continue;
                        }
                        return false;
                    }
                    if (this.genSurface != null && !WorldGenMinableCluster.canGenerateInBlock(world, x, y - 1, z, this.genSurface)) {
                        return false;
                    }
                    block = world.func_147439_a(x, y - 1, z);
                    block.onPlantGrow(world, x, y - 1, z, x, y, z);
                }
                boolean r = false;
                for (yOffset = y - 3 + treeHeight; yOffset <= y + treeHeight; ++yOffset) {
                    int var12 = yOffset - (y + treeHeight);
                    int center = 1 - var12 / 2;
                    for (xOffset = x - center; xOffset <= x + center; ++xOffset) {
                        int xPos = xOffset - x;
                        int t = xPos >> 31;
                        xPos = xPos + t ^ t;
                        for (zOffset = z - center; zOffset <= z + center; ++zOffset) {
                            int zPos = zOffset - z;
                            t = zPos >> 31;
                            zPos = zPos + t ^ t;
                            block = world.func_147439_a(xOffset, yOffset, zOffset);
                            if (!(xPos != center | zPos != center) && (rand.nextInt(2) == 0 || var12 == 0) || this.treeChecks && !block.isLeaves((IBlockAccess)world, xOffset, yOffset, zOffset) && !block.isAir((IBlockAccess)world, xOffset, yOffset, zOffset) && !block.canBeReplacedByLeaves((IBlockAccess)world, xOffset, yOffset, zOffset)) continue;
                            r |= WorldGenMinableCluster.generateBlock(world, xOffset, yOffset, zOffset, this.genBlock, this.leaves);
                        }
                    }
                }
                for (yOffset = 0; yOffset < treeHeight; ++yOffset) {
                    block = world.func_147439_a(x, y + yOffset, z);
                    if (this.treeChecks && !block.isAir((IBlockAccess)world, x, y + yOffset, z) && !block.isLeaves((IBlockAccess)world, x, y + yOffset, z) && !block.isReplaceable((IBlockAccess)world, x, y + yOffset, z)) continue;
                    r |= WorldGenMinableCluster.generateBlock(world, x, yOffset + y, z, this.genBlock, this.trunk);
                }
                return r;
            }
        }
        return false;
    }
}

