/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.multiblock;

import io.endertech.multiblock.IMultiblockPart;
import io.endertech.multiblock.MultiblockControllerBase;
import io.endertech.multiblock.MultiblockRegistry;
import io.endertech.network.PacketETBase;
import io.endertech.util.BlockCoord;
import io.endertech.util.helper.LocalisationHelper;
import io.endertech.util.helper.LogHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.chunk.IChunkProvider;

public abstract class MultiblockTileEntityBase
extends IMultiblockPart {
    protected PacketETBase cachedMultiblockPacket = null;
    protected NBTTagCompound cachedMultiblockNBT = null;
    private MultiblockControllerBase controller = null;
    private boolean visited = false;
    private boolean saveMultiblockData = false;
    private boolean paused = false;

    @Override
    public Set<MultiblockControllerBase> attachToNeighbors() {
        IMultiblockPart[] partsToCheck;
        HashSet<MultiblockControllerBase> controllers = null;
        MultiblockControllerBase bestController = null;
        for (IMultiblockPart neighborPart : partsToCheck = this.getNeighboringParts()) {
            MultiblockControllerBase candidate;
            if (!neighborPart.isConnected() || !(candidate = neighborPart.getMultiblockController()).getClass().equals(this.getMultiblockControllerType())) continue;
            if (controllers == null) {
                controllers = new HashSet<MultiblockControllerBase>();
                bestController = candidate;
            } else if (!controllers.contains(candidate) && candidate.shouldConsume(bestController)) {
                bestController = candidate;
            }
            controllers.add(candidate);
        }
        if (bestController != null) {
            this.controller = bestController;
            bestController.attachBlock(this);
        }
        return controllers;
    }

    @Override
    public void assertDetached() {
        if (this.controller != null) {
            LogHelper.info(LocalisationHelper.localiseString("assert.multiblock.part.detached", this.field_145851_c, this.field_145848_d, this.field_145849_e), new Object[0]);
            this.controller = null;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b("multiblockData")) {
            this.cachedMultiblockNBT = data.func_74775_l("multiblockData");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        if (this.isMultiblockSaveDelegate() && this.isConnected()) {
            NBTTagCompound multiblockData = new NBTTagCompound();
            this.controller.writeToNBT(multiblockData);
            data.func_74782_a("multiblockData", (NBTBase)multiblockData);
        }
    }

    public boolean canUpdate() {
        return false;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.detachSelf(false);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.detachSelf(true);
    }

    public void func_145829_t() {
        super.func_145829_t();
        MultiblockRegistry.onPartAdded(this.field_145850_b, this);
    }

    @Override
    public boolean hasMultiblockNBTCache() {
        return this.cachedMultiblockNBT != null;
    }

    @Override
    public boolean hasMultiblockMessageCache() {
        return this.cachedMultiblockPacket != null;
    }

    @Override
    public NBTTagCompound getMultiblockNBTCache() {
        return this.cachedMultiblockNBT;
    }

    @Override
    public PacketETBase getMultiblockPacketCache() {
        return this.cachedMultiblockPacket;
    }

    @Override
    public void onMultiblockDataAssimilated() {
        this.cachedMultiblockNBT = null;
        this.cachedMultiblockPacket = null;
    }

    @Override
    public abstract void onMachineAssembled(MultiblockControllerBase var1);

    @Override
    public abstract void onMachineBroken();

    @Override
    public abstract void onMachineActivated();

    @Override
    public abstract void onMachineDeactivated();

    @Override
    public boolean isConnected() {
        return this.controller != null;
    }

    @Override
    public MultiblockControllerBase getMultiblockController() {
        return this.controller;
    }

    @Override
    public BlockCoord getWorldLocation() {
        return new BlockCoord(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void becomeMultiblockSaveDelegate() {
        this.saveMultiblockData = true;
    }

    @Override
    public void forfeitMultiblockSaveDelegate() {
        this.saveMultiblockData = false;
    }

    @Override
    public boolean isMultiblockSaveDelegate() {
        return this.saveMultiblockData;
    }

    @Override
    public void setUnvisited() {
        this.visited = false;
    }

    @Override
    public void setVisited() {
        this.visited = true;
    }

    @Override
    public boolean isVisited() {
        return this.visited;
    }

    @Override
    public void onAssimilated(MultiblockControllerBase newController) {
        assert (this.controller != newController);
        this.controller = newController;
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        this.controller = newController;
    }

    @Override
    public void onDetached(MultiblockControllerBase oldController) {
        this.controller = null;
    }

    @Override
    public abstract MultiblockControllerBase createNewMultiblock();

    @Override
    public IMultiblockPart[] getNeighboringParts() {
        BlockCoord[] neighbors = new BlockCoord[]{new BlockCoord(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e), new BlockCoord(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e), new BlockCoord(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1), new BlockCoord(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1), new BlockCoord(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e), new BlockCoord(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)};
        ArrayList<IMultiblockPart> neighborParts = new ArrayList<IMultiblockPart>();
        IChunkProvider chunkProvider = this.field_145850_b.func_72863_F();
        for (BlockCoord neighbor : neighbors) {
            TileEntity te;
            if (!chunkProvider.func_73149_a(neighbor.getChunkX(), neighbor.getChunkZ()) || !((te = this.field_145850_b.func_147438_o(neighbor.x, neighbor.y, neighbor.z)) instanceof IMultiblockPart)) continue;
            neighborParts.add((IMultiblockPart)te);
        }
        IMultiblockPart[] tmp = new IMultiblockPart[neighborParts.size()];
        return neighborParts.toArray(tmp);
    }

    @Override
    public void onOrphaned(MultiblockControllerBase controller, int oldSize, int newSize) {
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
    }

    protected void detachSelf(boolean chunkUnloading) {
        if (this.controller != null) {
            this.controller.detachBlock(this, chunkUnloading);
            this.controller = null;
        }
        MultiblockRegistry.onPartRemovedFromWorld(this.field_145850_b, this);
    }
}

