/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.multiblock.rectangular;

import io.endertech.multiblock.MultiblockControllerBase;
import io.endertech.multiblock.MultiblockValidationException;
import io.endertech.multiblock.rectangular.RectangularMultiblockTileEntityBase;
import io.endertech.util.BlockCoord;
import io.endertech.util.helper.LocalisationHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class RectangularMultiblockControllerBase
extends MultiblockControllerBase {
    protected RectangularMultiblockControllerBase(World world) {
        super(world);
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        if (this.connectedParts.size() < this.getMinimumNumberOfBlocksForAssembledMachine()) {
            throw new MultiblockValidationException("Machine is too small.");
        }
        BlockCoord maximumCoord = this.getMaximumCoord();
        BlockCoord minimumCoord = this.getMinimumCoord();
        int deltaX = maximumCoord.x - minimumCoord.x + 1;
        int deltaY = maximumCoord.y - minimumCoord.y + 1;
        int deltaZ = maximumCoord.z - minimumCoord.z + 1;
        int maxX = this.getMaximumXSize();
        int maxY = this.getMaximumYSize();
        int maxZ = this.getMaximumZSize();
        int minX = this.getMinimumXSize();
        int minY = this.getMinimumYSize();
        int minZ = this.getMinimumZSize();
        if (maxX > 0 && deltaX > maxX) {
            throw new MultiblockValidationException(LocalisationHelper.localiseString("info.multiblock.rectangular.dimensions_wrong", "large", "most", maxX, "X"));
        }
        if (maxY > 0 && deltaY > maxY) {
            throw new MultiblockValidationException(LocalisationHelper.localiseString("info.multiblock.rectangular.dimensions_wrong", "large", "most", maxY, "Y"));
        }
        if (maxZ > 0 && deltaZ > maxZ) {
            throw new MultiblockValidationException(LocalisationHelper.localiseString("info.multiblock.rectangular.dimensions_wrong", "large", "most", maxZ, "Z"));
        }
        if (deltaX < minX) {
            throw new MultiblockValidationException(LocalisationHelper.localiseString("info.multiblock.rectangular.dimensions_wrong", "small", "least", minX, "X"));
        }
        if (deltaY < minY) {
            throw new MultiblockValidationException(LocalisationHelper.localiseString("info.multiblock.rectangular.dimensions_wrong", "small", "least", minY, "Y"));
        }
        if (deltaZ < minZ) {
            throw new MultiblockValidationException(LocalisationHelper.localiseString("info.multiblock.rectangular.dimensions_wrong", "small", "least", minZ, "Z"));
        }
        Class<?> myClass = this.getClass();
        for (int x = minimumCoord.x; x <= maximumCoord.x; ++x) {
            for (int y = minimumCoord.y; y <= maximumCoord.y; ++y) {
                for (int z = minimumCoord.z; z <= maximumCoord.z; ++z) {
                    RectangularMultiblockTileEntityBase part;
                    TileEntity te = this.worldObj.func_147438_o(x, y, z);
                    if (te instanceof RectangularMultiblockTileEntityBase) {
                        part = (RectangularMultiblockTileEntityBase)te;
                        if (!myClass.equals(part.getMultiblockControllerType())) {
                            throw new MultiblockValidationException(LocalisationHelper.localiseString("info.multiblock.rectangular.part_not_compatible", x, y, z, myClass.getSimpleName()));
                        }
                    } else {
                        part = null;
                    }
                    int extremes = 0;
                    if (x == minimumCoord.x) {
                        ++extremes;
                    }
                    if (y == minimumCoord.y) {
                        ++extremes;
                    }
                    if (z == minimumCoord.z) {
                        ++extremes;
                    }
                    if (x == maximumCoord.x) {
                        ++extremes;
                    }
                    if (y == maximumCoord.y) {
                        ++extremes;
                    }
                    if (z == maximumCoord.z) {
                        ++extremes;
                    }
                    if (extremes >= 2) {
                        if (part != null) {
                            part.isGoodForFrame();
                            continue;
                        }
                        this.isBlockGoodForFrame(this.worldObj, x, y, z);
                        continue;
                    }
                    if (extremes == 1) {
                        if (y == maximumCoord.y) {
                            if (part != null) {
                                part.isGoodForTop();
                                continue;
                            }
                            this.isBlockGoodForTop(this.worldObj, x, y, z);
                            continue;
                        }
                        if (y == minimumCoord.y) {
                            if (part != null) {
                                part.isGoodForBottom();
                                continue;
                            }
                            this.isBlockGoodForBottom(this.worldObj, x, y, z);
                            continue;
                        }
                        if (part != null) {
                            part.isGoodForSides();
                            continue;
                        }
                        this.isBlockGoodForSides(this.worldObj, x, y, z);
                        continue;
                    }
                    if (part != null) {
                        part.isGoodForInterior();
                        continue;
                    }
                    this.isBlockGoodForInterior(this.worldObj, x, y, z);
                }
            }
        }
    }
}

