/*
 * Decompiled with CFR 0.152.
 */
package toast.specialAI.ai;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import toast.specialAI._SpecialAI;
import toast.specialAI.util.BlockHelper;

public class EntityAIDig
extends EntityAIBase {
    private static final boolean PLAYER_ONLY = false;
    private static final boolean LEAVE_DROPS = false;
    private static final boolean NEEDS_TOOL = false;
    protected EntityLiving theEntity;
    private double startX;
    private double startY;
    private double startZ;
    private int blockX;
    private int blockY;
    private int blockZ;
    private Block targetBlock;
    private float blockDamage;

    public EntityAIDig(EntityLiving entity) {
        this.theEntity = entity;
    }

    public EntityLivingBase target() {
        return this.theEntity.func_70638_az();
    }

    public Random random() {
        return this.theEntity.func_70681_au();
    }

    public double distance() {
        EntityLivingBase target = this.target();
        return target == null ? Double.POSITIVE_INFINITY : this.theEntity.func_70068_e((Entity)target);
    }

    public boolean func_75250_a() {
        EntityLivingBase target = this.target();
        if (this.theEntity.field_70170_p.func_82736_K().func_82766_b("mobGriefing") && target != null) {
            return this.targetHighestObstruction(target);
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.theEntity.field_70170_p.func_147439_a(this.blockX, this.blockY, this.blockZ) == this.targetBlock && this.theEntity.func_70092_e(this.startX, this.startY, this.startZ) <= 4.0;
    }

    public void func_75249_e() {
        _SpecialAI.console("Starting!");
        this.startX = this.theEntity.field_70165_t;
        this.startY = this.theEntity.field_70163_u;
        this.startZ = this.theEntity.field_70161_v;
        this.blockDamage = 0.0f;
    }

    public void func_75246_d() {
        this.theEntity.func_70671_ap().func_75650_a((double)this.blockX, (double)this.blockY, (double)this.blockZ, 30.0f, 30.0f);
        if (this.random().nextInt(20) == 0) {
            this.theEntity.field_70170_p.func_72926_e(1010, this.blockX, this.blockY, this.blockZ, 0);
            this.theEntity.func_71038_i();
        }
        this.blockDamage += BlockHelper.getDamageAmount(this.targetBlock, this.theEntity, this.theEntity.field_70170_p, this.blockX, this.blockY, this.blockZ);
        if (this.blockDamage >= 1.0f) {
            this.theEntity.field_70170_p.func_147468_f(this.blockX, this.blockY, this.blockZ);
            this.theEntity.field_70170_p.func_72926_e(2001, this.blockX, this.blockY, this.blockZ, Block.func_149682_b((Block)this.targetBlock));
            this.theEntity.func_71038_i();
            this.blockDamage = 0.0f;
        }
        this.theEntity.field_70170_p.func_147443_d(this.theEntity.func_145782_y(), this.blockX, this.blockY, this.blockZ, (int)(this.blockDamage * 10.0f) - 1);
    }

    public void func_75251_c() {
        _SpecialAI.console("Stopping!");
        this.blockDamage = 0.0f;
        this.theEntity.field_70170_p.func_147443_d(this.theEntity.func_145782_y(), this.blockX, this.blockY, this.blockZ, -1);
    }

    private boolean targetHighestObstruction(EntityLivingBase target) {
        PathEntity path = this.theEntity.func_70661_as().func_75505_d();
        if (path == null || !path.func_75879_b()) {
            return false;
        }
        _SpecialAI.console("Blocked!");
        AxisAlignedBB boundingBox = this.theEntity.field_70121_D;
        double dX = target.field_70165_t - this.theEntity.field_70165_t;
        double dY = target.field_70163_u - this.theEntity.field_70163_u;
        double dZ = target.field_70161_v - this.theEntity.field_70161_v;
        double v = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        boundingBox = boundingBox.func_72321_a(dX / v, dY / v, dZ / v);
        ArrayList bbList = new ArrayList();
        int minX = MathHelper.func_76128_c((double)boundingBox.field_72340_a);
        int maxX = MathHelper.func_76128_c((double)boundingBox.field_72336_d);
        int minY = MathHelper.func_76128_c((double)boundingBox.field_72338_b);
        int maxY = MathHelper.func_76128_c((double)boundingBox.field_72337_e);
        int minZ = MathHelper.func_76128_c((double)boundingBox.field_72339_c);
        int maxZ = MathHelper.func_76128_c((double)boundingBox.field_72334_f);
        if (this.theEntity.field_70170_p.func_72904_c(minX, minY, minZ, maxX, maxY, maxZ)) {
            for (int y = maxY; y >= minY; --y) {
                for (int x = minX; x <= maxX; ++x) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        Block block = this.theEntity.field_70170_p.func_147439_a(x, y, z);
                        if (block == null) continue;
                        block.func_149743_a(this.theEntity.field_70170_p, x, y, z, boundingBox, bbList, (Entity)this.theEntity);
                        if (bbList.isEmpty()) continue;
                        if (this.tryTargetBlock(block, x, y, z)) {
                            return true;
                        }
                        bbList.clear();
                    }
                }
            }
        }
        return false;
    }

    private boolean tryTargetBlock(Block block, int x, int y, int z) {
        if (block != Blocks.field_150350_a && BlockHelper.shouldDamage(block, this.theEntity, false, this.theEntity.field_70170_p, x, y, z)) {
            this.blockX = x;
            this.blockY = y;
            this.blockZ = z;
            this.targetBlock = block;
            return true;
        }
        return false;
    }
}

