/*
 * Decompiled with CFR 0.152.
 */
package toast.specialAI.ai.special;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import toast.specialAI.ai.special.ISpecialAI;

public class EntityAIShaman
extends EntityAIBase
implements ISpecialAI {
    private int WEIGHT;
    protected EntityLiving theEntity;
    private float healAmount;
    private NBTTagList potionEffects;
    private EntityLiving followTarget;
    private int healTime;

    public EntityAIShaman() {
    }

    private EntityAIShaman(EntityLiving entity, float healAmount, NBTTagList effects) {
        this.theEntity = entity;
        this.healAmount = healAmount;
        this.potionEffects = effects;
        this.func_75248_a(3);
    }

    @Override
    public String getName() {
        return "shaman";
    }

    @Override
    public int getWeight() {
        return this.WEIGHT;
    }

    @Override
    public void setWeight(int weight) {
        this.WEIGHT = weight;
    }

    @Override
    public void addTo(EntityLiving entity, NBTTagCompound aiTag) {
        NBTTagList effects = aiTag.func_74764_b(this.getName() + "FX") ? aiTag.func_150295_c(this.getName() + "FX", (int)new NBTTagCompound().func_74732_a()) : null;
        entity.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIShaman(entity, aiTag.func_74760_g(this.getName()), effects));
    }

    @Override
    public void save(NBTTagCompound aiTag) {
        aiTag.func_74776_a(this.getName(), 1.0f);
    }

    @Override
    public boolean isSaved(NBTTagCompound aiTag) {
        return aiTag.func_74760_g(this.getName()) > 0.0f;
    }

    @Override
    public void initialize(EntityLiving entity) {
        entity.func_70062_b(0, new ItemStack(Items.field_151103_aS));
        entity.func_70062_b(4, new ItemStack(Blocks.field_150428_aP));
        entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(UUID.randomUUID(), "Shaman health boost", 20.0, 0));
        entity.func_70606_j(entity.func_110143_aJ() + 20.0f);
    }

    public boolean func_75250_a() {
        return this.findFollowTarget();
    }

    public boolean func_75253_b() {
        EntityLivingBase target = this.theEntity.func_70638_az();
        return target != null && this.followTarget != null && this.followTarget.func_70089_S() && (target == this.followTarget.func_70638_az() || this.findFollowTarget());
    }

    public void func_75246_d() {
        EntityLivingBase target = this.theEntity.func_70638_az();
        double distance = this.theEntity.func_70068_e((Entity)this.followTarget);
        if (distance > 36.0) {
            this.theEntity.func_70661_as().func_75497_a((Entity)this.followTarget, 1.3);
        } else if (distance < 4.0) {
            this.theEntity.func_70661_as().func_75499_g();
        }
        if (this.theEntity.func_70661_as().func_75500_f()) {
            this.theEntity.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
        } else {
            this.theEntity.func_70671_ap().func_75651_a((Entity)this.followTarget, 30.0f, 30.0f);
        }
        --this.healTime;
        if (this.healTime <= 0) {
            this.healTime = 20;
            List list = this.theEntity.field_70170_p.func_72839_b((Entity)this.theEntity, this.theEntity.field_70121_D.func_72314_b(16.0, 8.0, 16.0));
            Collections.shuffle(list);
            for (Object entity : list) {
                EntityLiving healTarget;
                if (!(entity instanceof EntityLiving) || target != (healTarget = (EntityLiving)entity).func_70638_az() || !this.theEntity.func_70635_at().func_75522_a((Entity)healTarget)) continue;
                healTarget.func_70691_i(this.healAmount);
                healTarget.func_70066_B();
                if (this.potionEffects == null) {
                    healTarget.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 31, 0));
                    healTarget.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 31, 1));
                    healTarget.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 31, 1));
                } else {
                    int length = this.potionEffects.func_74745_c();
                    for (int i = 0; i < length; ++i) {
                        PotionEffect effect = PotionEffect.func_82722_b((NBTTagCompound)this.potionEffects.func_150305_b(i));
                        if (effect == null) continue;
                        healTarget.func_70690_d(effect);
                    }
                }
                this.theEntity.field_70170_p.func_72926_e(2005, (int)Math.floor(healTarget.field_70165_t), (int)Math.floor(healTarget.field_70163_u + (double)healTarget.func_70047_e()), (int)Math.floor(healTarget.field_70161_v), 0);
            }
        }
    }

    private boolean findFollowTarget() {
        EntityLivingBase target = this.theEntity.func_70638_az();
        if (target != null) {
            List list = this.theEntity.field_70170_p.func_72839_b((Entity)this.theEntity, this.theEntity.field_70121_D.func_72314_b(16.0, 8.0, 16.0));
            Collections.shuffle(list);
            for (Object entity : list) {
                if (!(entity instanceof EntityLiving) || target != ((EntityLiving)entity).func_70638_az()) continue;
                this.followTarget = (EntityLiving)entity;
                return true;
            }
        }
        return false;
    }
}

