/*
 * Decompiled with CFR 0.152.
 */
package toast.specialAI.ai.special;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.world.World;
import toast.specialAI.ai.special.ISpecialAI;

public class EntityAISpawner
extends EntityAIBase
implements ISpecialAI {
    private static final NBTTagCompound SPAWNER_TAG = new NBTTagCompound();
    private int WEIGHT;
    public EntityLiving theEntity;
    private MobSpawnerBaseLogic mobSpawnerLogic;

    public EntityAISpawner() {
    }

    private EntityAISpawner(EntityLiving entity, NBTTagCompound spawnerTag) {
        this.theEntity = entity;
        this.mobSpawnerLogic = new MobSpawnerAILogic(entity);
        if (spawnerTag != null) {
            this.mobSpawnerLogic.func_98270_a(spawnerTag);
        } else {
            SPAWNER_TAG.func_74778_a("EntityId", EntityList.func_75621_b((Entity)entity));
            this.mobSpawnerLogic.func_98270_a(SPAWNER_TAG);
        }
        this.func_75248_a(0);
    }

    @Override
    public String getName() {
        return "spawner";
    }

    @Override
    public int getWeight() {
        return this.WEIGHT;
    }

    @Override
    public void setWeight(int weight) {
        this.WEIGHT = weight;
    }

    @Override
    public void addTo(EntityLiving entity, NBTTagCompound aiTag) {
        NBTTagCompound spawnerTag = aiTag.func_74764_b(this.getName() + "Tags") ? aiTag.func_74775_l(this.getName() + "Tags") : null;
        entity.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISpawner(entity, spawnerTag));
    }

    @Override
    public void save(NBTTagCompound aiTag) {
        aiTag.func_74774_a(this.getName(), (byte)1);
    }

    @Override
    public boolean isSaved(NBTTagCompound aiTag) {
        return aiTag.func_74771_c(this.getName()) > 0;
    }

    @Override
    public void initialize(EntityLiving entity) {
        entity.func_70062_b(4, new ItemStack(Blocks.field_150474_ac, 1, EntityList.func_75619_a((Entity)entity)));
        entity.func_96120_a(4, 0.0f);
        entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier(UUID.randomUUID(), "Spawner speed penalty", -0.2, 1));
        entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(UUID.randomUUID(), "Spawner health boost", 80.0, 0));
        entity.func_70606_j(entity.func_110143_aJ() + 80.0f);
    }

    public boolean func_75250_a() {
        EntityLivingBase target = this.theEntity.func_70638_az();
        return target != null && this.theEntity.func_70635_at().func_75522_a((Entity)target);
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    public void func_75246_d() {
        this.mobSpawnerLogic.func_98278_g();
    }

    static {
        SPAWNER_TAG.func_74778_a("EntityId", "");
        SPAWNER_TAG.func_74777_a("Delay", (short)20);
        SPAWNER_TAG.func_74777_a("MinSpawnDelay", (short)150);
        SPAWNER_TAG.func_74777_a("MaxSpawnDelay", (short)600);
        SPAWNER_TAG.func_74777_a("SpawnCount", (short)4);
        SPAWNER_TAG.func_74777_a("MaxNearbyEntities", (short)7);
        SPAWNER_TAG.func_74777_a("RequiredPlayerRange", (short)16);
        SPAWNER_TAG.func_74777_a("SpawnRange", (short)4);
    }

    private static class MobSpawnerAILogic
    extends MobSpawnerBaseLogic {
        private boolean justSpawned;
        private EntityLiving theEntity;

        public MobSpawnerAILogic(EntityLiving entity) {
            this.theEntity = entity;
        }

        public Entity func_98265_a(Entity entity) {
            entity = super.func_98265_a(entity);
            this.justSpawned = true;
            return entity;
        }

        public void func_98267_a(int p_98267_1_) {
        }

        public World func_98271_a() {
            return this.theEntity.field_70170_p;
        }

        public int func_98275_b() {
            return (int)Math.floor(this.theEntity.field_70165_t);
        }

        public int func_98274_c() {
            if (this.justSpawned) {
                this.justSpawned = false;
                return (int)Math.floor(this.theEntity.field_70163_u + (double)this.theEntity.func_70047_e());
            }
            return (int)Math.floor(this.theEntity.field_70163_u);
        }

        public int func_98266_d() {
            return (int)Math.floor(this.theEntity.field_70161_v);
        }
    }
}

